/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic.model;

import com.tl.uic.TLFCache;
import com.tl.uic.Tealeaf;
import com.tl.uic.model.JsonBase;
import com.tl.uic.model.MessageType;
import com.tl.uic.util.LogInternal;
import java.io.Serializable;
import org.json.JSONObject;

public class ClientMessageHeader
implements JsonBase,
Serializable {
    private static final long serialVersionUID = 876537710682369925L;
    private MessageType messageType;
    private long offset = TLFCache.timestampFromSession();
    private int logLevel;
    private long screenviewOffset = Tealeaf.getApplicationScreenviewOffset();
    private Boolean fromWeb = false;
    private int count = -1;

    public final MessageType getMessageType() {
        return this.messageType;
    }

    public final void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public final long getOffset() {
        return this.offset;
    }

    public final void setOffset(long offset) {
        this.offset = offset;
    }

    public final int getLogLevel() {
        return this.logLevel;
    }

    public final void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public final long getScreenviewOffset() {
        return this.screenviewOffset;
    }

    public final void setScreenviewOffset(long screenviewOffset) {
        this.screenviewOffset = screenviewOffset;
    }

    public final Boolean getFromWeb() {
        return this.fromWeb;
    }

    public final void setFromWeb(Boolean fromWeb) {
        this.fromWeb = fromWeb;
    }

    public final int getCount() {
        return this.count;
    }

    public final void setCount(int count) {
        this.count = count;
    }

    public JSONObject getJSON() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("fromWeb", (Object)this.getFromWeb());
            jsonObject.put("type", this.getMessageType().getValue());
            jsonObject.put("offset", this.getOffset());
            jsonObject.put("screenviewOffset", this.getScreenviewOffset());
            jsonObject.put("count", this.getCount());
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
        return jsonObject;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)(this.screenviewOffset ^ this.screenviewOffset >>> 32);
        result = 31 * result + this.logLevel;
        result = 31 * result + (this.messageType == null ? 0 : this.messageType.hashCode());
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        result = 31 * result + this.count;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ClientMessageHeader other = (ClientMessageHeader)obj;
        if (this.screenviewOffset != other.screenviewOffset) {
            return false;
        }
        if (this.logLevel != other.logLevel) {
            return false;
        }
        if (this.messageType != other.messageType) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        return this.count == other.count;
    }

    public Boolean clean() {
        this.messageType = null;
        this.offset = 0L;
        this.logLevel = 0;
        this.screenviewOffset = 0L;
        this.fromWeb = null;
        this.count = -1;
        return true;
    }
}

