/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic.http;

import com.tl.uic.TLFCache;
import com.tl.uic.Tealeaf;
import com.tl.uic.http.TLHttpRequestInterceptor;
import com.tl.uic.util.HTTPUtil;
import com.tl.uic.util.LogInternal;
import java.io.IOException;
import java.util.Date;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;

public class TLHttpResponseInterceptor
implements HttpResponseInterceptor {
    private final TLHttpRequestInterceptor tlHttpRequestInterceptor;
    private final Date startTime;
    private final long initTime;

    public TLHttpResponseInterceptor(TLHttpRequestInterceptor tlHttpRequestInterceptor) {
        this.tlHttpRequestInterceptor = tlHttpRequestInterceptor;
        this.startTime = new Date();
        this.initTime = TLFCache.timestampFromSession();
    }

    public final void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        try {
            Date endTime = new Date();
            Date startLoad = new Date();
            long loadTime = new Date().getTime() - startLoad.getTime();
            long responseTime = endTime.getTime() - this.startTime.getTime();
            Tealeaf.logConnection(this.tlHttpRequestInterceptor.getUrl(), response, this.initTime, loadTime, responseTime);
            LogInternal.log("vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv");
            LogInternal.log("Headers from response:");
            LogInternal.log(HTTPUtil.getHeaders(response.getAllHeaders()));
            LogInternal.log("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
    }
}

