/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic.http;

import android.webkit.CookieManager;
import com.tl.uic.Tealeaf;
import com.tl.uic.util.HTTPUtil;
import com.tl.uic.util.LogInternal;
import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

public class TLHttpRequestInterceptor
implements HttpRequestInterceptor {
    private String url;
    private final String sessionId;
    private final Boolean hasUICData;

    public TLHttpRequestInterceptor() {
        this.sessionId = null;
        this.hasUICData = false;
    }

    public TLHttpRequestInterceptor(String sessionId, Boolean hasUICData) {
        this.sessionId = sessionId;
        this.hasUICData = hasUICData;
    }

    public final String getUrl() {
        return this.url;
    }

    public final void setUrl(String url) {
        this.url = url;
    }

    public final void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        try {
            String extistingCookies;
            this.url = request.getRequestLine().getUri();
            if (!request.containsHeader("X-TEALEAF_HASUICDATA")) {
                request.addHeader("X-TEALEAF_HASUICDATA", this.hasUICData.toString());
            }
            if (!request.containsHeader("X-Tealeaf")) {
                request.addHeader("X-Tealeaf", "device (Android) Lib/" + Tealeaf.getLibraryVersion());
            }
            if (!request.containsHeader("X-Tealeaf-Property")) {
                request.addHeader("X-Tealeaf-Property", Tealeaf.getHttpXTealeafProperty());
            }
            if (Tealeaf.getAdditionalHeaders() != null) {
                for (Map.Entry<String, String> entry : Tealeaf.getAdditionalHeaders().entrySet()) {
                    request.addHeader(entry.getKey(), entry.getValue());
                }
            }
            StringBuffer cookies = new StringBuffer(Tealeaf.getTLCookie(Tealeaf.getCurrentSessionId()));
            if (this.getUrl() != null && (extistingCookies = HTTPUtil.validateData(CookieManager.getInstance().getCookie(this.getUrl()))) != null) {
                cookies.append(';');
                cookies.append(extistingCookies);
            }
            request.addHeader("Cookie", HTTPUtil.validateData(cookies.toString()));
            LogInternal.log("vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv");
            LogInternal.log("Header from request:");
            LogInternal.log(HTTPUtil.getHeaders(request.getAllHeaders()));
            LogInternal.log("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        }
        catch (Exception e) {
            Tealeaf.logException(e);
        }
    }
}

