/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Application;
import android.app.Dialog;
import android.content.DialogInterface;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.widget.Button;
import com.tl.uic.Logger;
import com.tl.uic.TLFCache;
import com.tl.uic.model.Layout;
import com.tl.uic.model.Screenview;
import com.tl.uic.model.ScreenviewType;
import com.tl.uic.util.CheckWhiteListTask;
import com.tl.uic.util.ConfigurationUtil;
import com.tl.uic.util.DialogLogScreenTask;
import com.tl.uic.util.LogInternal;
import com.tl.uic.util.LogScreenTask;
import com.tl.uic.util.PostTask;
import com.tl.uic.util.ScreenShotTask;
import com.tl.uic.util.TLUncaughtExceptionHandler;
import com.tl.uic.util.UICOnGlobalLayoutListener;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.impl.cookie.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tealeaf {
    private static String phoneId;
    private static Boolean _isEnabled;
    private static Boolean isKillSwitchEnabled;
    private static Boolean _appLoaded;
    private static int _applicationInForegroundCounter;
    private static Application application;
    private static HashMap<String, String> additionalHeaders;
    private static String additionalCookies;
    public static final String TLF_CACHE_DIR = "TLFCache";
    public static final String TAG = "UICAndroid";
    public static final String TLF_HEADER = "X-Tealeaf";
    public static final String TLF_SESSION_HEADER = "X-Tealeaf-Session";
    public static final String TLF_PROPERTY_HEADER = "X-Tealeaf-Property";
    public static final String TLF_HASUICDATA_HEADER = "X-TEALEAF_HASUICDATA";
    public static final String TLF_ON_FOCUS_CHANGE_IN = "OnFocusChange_In";
    public static final String TLF_ON_FOCUS_CHANGE_OUT = "OnFocusChange_Out";
    public static final String TLF_ON_GROUP_COLLAPSE = "OnGroupCollapse";
    public static final String TLF_ON_GROUP_EXPAND = "OnGroupExpand";
    public static final String TLF_ON_DRAWER_OPENED = "OnDrawerOpened";
    public static final String TLF_ON_DRAWER_CLOSED = "OnDrawerClosed";
    public static final String TLF_UI_KEYBOARD_DID_SHOW_NOTIFICATION = "UIKeyboardDidShowNotification";
    public static final String TLF_UI_KEYBOARD_DID_HIDE_NOTIFICATION = "UIKeyboardDidHideNotification";
    public static final String TLF_CONFIGURATION_FILENAME = "TLFConfigurableItems.properties";
    public static final String TLF_LOGGING_LEVEL = "LoggingLevel";
    public static final String DISPLAY_LOGGING = "DisplayLogging";
    public static final String TLF_CONNECTION_LOGGING_LEVEL = "Connection";
    public static final String TLF_KILL_SWITCH_ASYNC = "KillSwitchAsync";
    public static final String TLF_KILL_SWITCH_ENABLED = "KillSwitchEnabled";
    public static final String TLF_KILL_SWITCH_URL = "KillSwitchUrl";
    public static final String TLF_KILL_SWITCH_MAX_NUMBER_OF_TRIES = "KillSwitchMaxNumberOfTries";
    public static final String TLF_KILL_SWITCH_TIME_INTERVAL = "KillSwitchTimeInterval";
    public static final String TLF_USE_WHITE_LIST = "UseWhiteList";
    public static final String TLF_WHITE_LIST_PARAM = "WhiteListParam";
    public static final String TLF_USE_RANDOM_SAMPLE = "UseRandomSample";
    public static final String TLF_RANDOM_SAMPLE_PARAM = "RandomSampleParam";
    public static final String TLF_HAS_TO_PERSIST_LOCAL_CACHE = "HasToPersistLocalCache";
    public static final String TLF_CACHED_LEVEL = "CachingLevel";
    public static final String TLF_CACHED_FILE_MAX_BYTES_SIZE = "CachedFileMaxBytesSize";
    public static final String TLF_POST_MESSAGE_URL = "PostMessageUrl";
    public static final String TLF_POST_MESSAGE_LEVEL_WIFI = "PostMessageLevelWiFi";
    public static final String TLF_POST_MESSAGE_LEVEL_CELLULAR = "PostMessageLevelCellular";
    public static final String TLF_MAX_STRINGS_LENGTH = "MaxStringsLength";
    public static final String TLF_MANUAL_POST_ENABLED = "ManualPostEnabled";
    public static final String TLF_DO_POSTS_ON_INTERVALS = "DoPostOnIntervals";
    public static final String TLF_POST_MESSAGE_TIME_INTERVALS = "PostMessageTimeIntervals";
    public static final String TLF_POST_MESSAGE_MAX_BYTES_SIZE = "PostMessageMaxBytesSize";
    public static final String TLF_HAS_MASKING = "HasMasking";
    public static final String TLF_MASK_ID_LIST = "MaskIdList";
    public static final String TLF_HAS_CUSTOM_MASK = "HasCustomMask";
    public static final String TLF_SENSITIVE_SMALL_CASE_ALPHABET = "SensitiveSmallCaseAlphabet";
    public static final String TLF_SENSITIVE_CAPITAL_CASE_ALPHABET = "SensitiveCapitalCaseAlphabet";
    public static final String TLF_SENSITIVE_SYMBOL = "SensitiveSymbol";
    public static final String TLF_SENSITIVE_NUMBER = "SensitiveNumber";
    public static final String TLF_POST_MESSAGE_TIMEOUT = "PostMessageTimeout";
    public static final String TLF_POST_MESSAGE_SOCKET_TIMEOUT = "PostMessageSocketTimeout";
    public static final String TLF_COMPRESS_POST_MESSAGE = "CompressPostMessage";
    public static final String TLF_BUFFER_LIMIT = "BufferLimit";
    public static final String TLF_BUFFER_PERCENT = "BufferPercent";
    public static final String TLF_MESSAGE_VERSION = "MessageVersion";
    public static final String TLF_LIBRARY_VERSION = "LibraryVersion";
    public static final String TLF_BATTERY_SENSITIVITY = "BatterySensitivity";
    public static final String TLF_FREE_MEMORY_SENSITIVITY = "FreeMemorySensitivity";
    public static final String TLF_FREE_STORAGE_SENSITIVITY = "FreeStorageSensitivity";
    public static final String TLF_TIME_INTERVAL_BETWEEN_SNAPSHOTS = "TimeIntervalBetweenSnapshots";
    public static final String TLF_COOKIE_PARAM = "CookieParam";
    public static final String TLF_COOKIE_PATH = "CookiePath";
    public static final String TLF_COOKIE_DOMAIN = "CookieDomain";
    public static final String TLF_COOKIE_URL = "CookieUrl";
    public static final String TLF_COOKIE_SECURE = "CookieSecure";
    public static final String TLF_COOKIE_EXPIRES_FORMAT = "CookieExpiresFormat";
    public static final String TLF_SESSION_TIMEOUT = "SessionTimeout";
    public static final String TLF_COOKIE_EXPIRES = "CookieExpires";
    public static final String TLF_SESSION_TIMEOUT_KILLSWITCH = "SessionTimeoutKillSwitch";
    public static final String TLF_FILTER_MESSAGE_TYPES = "FilterMessageTypes";
    public static final String TLF_MESSAGE_TYPES = "MessageTypes";
    public static final String TLF_ADD_MESSAGE_TYPE_HEADER = "AddMessageTypeHeader";
    public static final String TLF_MESSAGE_TYPE_HEADER = "MessageTypeHeader";
    public static final String TLF_PRINT_SCREEN = "PrintScreen";
    public static final String TLF_SCREENSHOT_FORMAT = "ScreenshotFormat";
    public static final String TLF_PERCENT_OF_SCREENSHOTS_SIZE = "PercentOfScreenshotsSize";
    public static final String TLF_PERCENT_TO_COMPRESS_IMAGE = "PercentToCompressImage";
    public static final String TLF_LOG_SCREENLAYOUT = "LogViewLayoutOnScreenTransition";
    public static final String TLF_GET_IMAGE_DATA_ON_SCREEN_LAYOUT = "GetImageDataOnScreenLayout";
    public static final int VERBOSE = 5;
    private static volatile Tealeaf _myInstance;
    private static volatile TLUncaughtExceptionHandler tlUncaughtExceptionHandler;
    private static volatile Logger logger;

    static {
        _isEnabled = false;
        isKillSwitchEnabled = false;
        _appLoaded = false;
        _applicationInForegroundCounter = 0;
    }

    public static synchronized Tealeaf getInstance() {
        if (_myInstance == null) {
            _myInstance = new Tealeaf();
        }
        return _myInstance;
    }

    private Tealeaf() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tealeaf(Application app) {
        Tealeaf tealeaf = this;
        synchronized (tealeaf) {
            application = app;
        }
        ConfigurationUtil.init(application);
        Tealeaf.callKillSwitch(false);
    }

    private static void callKillSwitch(Boolean startSession) {
        try {
            if (ConfigurationUtil.getBoolean(TLF_KILL_SWITCH_ENABLED).booleanValue()) {
                CheckWhiteListTask checkWhiteListTask = new CheckWhiteListTask(startSession);
                if (ConfigurationUtil.getBoolean(TLF_KILL_SWITCH_ASYNC).booleanValue()) {
                    checkWhiteListTask.execute(new Void[0]);
                } else {
                    checkWhiteListTask.execute(new Void[0]).get();
                }
            } else {
                isKillSwitchEnabled = true;
                LogInternal.log("From killswitch enabled: " + isKillSwitchEnabled + " session id:" + Tealeaf.getCurrentSessionId());
            }
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
    }

    public static void resultKillSwitch(Map<String, String> result) {
        try {
            if (result != null) {
                String sessionId = result.get("sessionId");
                if (sessionId == null) {
                    if (Tealeaf.getCurrentSessionId() == null) {
                        TLFCache.setCurrentSessionId(TLFCache.createSessionId());
                        LogInternal.log("Session id was null will need to autogenerate a new id:" + Tealeaf.getCurrentSessionId());
                    }
                } else {
                    TLFCache.setCurrentSessionId(result.get("sessionId"));
                }
                if ((isKillSwitchEnabled = Boolean.valueOf(Boolean.parseBoolean(result.get("killSwitchEnabled")))).booleanValue()) {
                    Tealeaf.enable(Tealeaf.getCurrentSessionId());
                }
                LogInternal.log("From killswitch enabled: " + isKillSwitchEnabled + " session id:" + Tealeaf.getCurrentSessionId());
            }
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
    }

    public static String getCurrentSessionId() {
        return TLFCache.getCurrentSessionId();
    }

    public static String getPhoneId() {
        return phoneId;
    }

    public static void setPhoneId(String phoneId) {
        Tealeaf.phoneId = phoneId;
    }

    public static Boolean isEnabled() {
        return _isEnabled;
    }

    public static Application getApplication() {
        return application;
    }

    public static String getMessageVersion() {
        return ConfigurationUtil.getString(TLF_MESSAGE_VERSION);
    }

    public static String getLibraryVersion() {
        return ConfigurationUtil.getString(TLF_LIBRARY_VERSION);
    }

    public static Boolean enable() {
        return Tealeaf.enable(null);
    }

    public static synchronized Boolean enable(String sessionId) {
        if (_isEnabled.booleanValue()) {
            return _isEnabled;
        }
        if (!isKillSwitchEnabled.booleanValue()) {
            return isKillSwitchEnabled;
        }
        if (tlUncaughtExceptionHandler == null) {
            tlUncaughtExceptionHandler = new TLUncaughtExceptionHandler();
            Thread.setDefaultUncaughtExceptionHandler(tlUncaughtExceptionHandler);
        }
        if (logger == null) {
            logger = new Logger(application);
        }
        _isEnabled = logger.enable(sessionId);
        return _isEnabled;
    }

    public static Boolean disable() {
        _isEnabled = false;
        if (logger != null) {
            logger.terminate();
        }
        if (tlUncaughtExceptionHandler != null) {
            tlUncaughtExceptionHandler.setDefaultUncaughtExceptionHandler();
            tlUncaughtExceptionHandler = null;
        }
        return _isEnabled;
    }

    public static Boolean onPause(Activity activity, String logicalPageName) {
        if (logger != null) {
            logger.onPause(activity, logicalPageName);
        }
        --_applicationInForegroundCounter;
        CookieSyncManager.getInstance().sync();
        return true;
    }

    public static Boolean onPauseNoActivityInForeground() {
        if (!_appLoaded.booleanValue()) {
            return false;
        }
        Tealeaf.flush();
        if (logger != null) {
            logger.onPauseNoActivityInForeground();
        }
        return true;
    }

    public static Boolean onResume(Activity activity, String logicalPageName) {
        if (ConfigurationUtil.getLongMSFromMinute(TLF_SESSION_TIMEOUT) > 0L && TLFCache.timestampFromSession() > ConfigurationUtil.getLongMSFromMinute(TLF_SESSION_TIMEOUT)) {
            Tealeaf.startSession(ConfigurationUtil.getBoolean(TLF_SESSION_TIMEOUT_KILLSWITCH));
        }
        if (logger != null) {
            logger.onResume(logicalPageName, activity);
        }
        ++_applicationInForegroundCounter;
        _appLoaded = true;
        CookieSyncManager.getInstance().stopSync();
        return true;
    }

    public static Boolean onDestroy(Activity activity, String logicalPageName) {
        if (logger != null) {
            logger.onDestroy(logicalPageName);
        }
        return true;
    }

    public static Boolean onLowMemory() {
        long availableMemory = 0L;
        if (TLFCache.getEnvironmentalData() != null) {
            availableMemory = TLFCache.getEnvironmentalData().getAvailableMemory();
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("memoryLevelMB", String.valueOf(availableMemory));
        Tealeaf.logCustomEvent("Low Memory", data, 0);
        return Tealeaf.disable();
    }

    public static Boolean terminate() {
        logger = null;
        return true;
    }

    public static Boolean flush() {
        return TLFCache.saveToCache(true);
    }

    public static Boolean logEvent(View view) {
        if (logger == null) {
            return false;
        }
        return logger.logEvent(view, null, ConfigurationUtil.getInt(TLF_LOGGING_LEVEL));
    }

    public static Boolean logEvent(View view, String eventType) {
        if (logger == null) {
            return false;
        }
        return logger.logEvent(view, eventType, ConfigurationUtil.getInt(TLF_LOGGING_LEVEL));
    }

    public static Boolean logEvent(View view, String eventType, int logLevel) {
        if (logger == null) {
            return false;
        }
        return logger.logEvent(view, eventType, logLevel);
    }

    public static Boolean logDialogEvent(DialogInterface dialog, int id) {
        return Tealeaf.logDialogEvent(dialog, id, null, ConfigurationUtil.getInt(TLF_LOGGING_LEVEL));
    }

    public static Boolean logDialogEvent(DialogInterface dialog, int id, String eventType) {
        return Tealeaf.logDialogEvent(dialog, id, eventType, ConfigurationUtil.getInt(TLF_LOGGING_LEVEL));
    }

    public static Boolean logDialogEvent(DialogInterface dialog, int id, String eventType, int logLevel) {
        if (logger == null || dialog == null || !(dialog instanceof AlertDialog)) {
            return false;
        }
        Button view = ((AlertDialog)dialog).getButton(id);
        if (view == null) {
            return false;
        }
        return logger.logEvent((View)view, eventType, logLevel);
    }

    public static Boolean logCustomEvent(String eventName) {
        if (logger == null) {
            return false;
        }
        return logger.logCustomEvent(eventName, null, ConfigurationUtil.getInt(TLF_LOGGING_LEVEL));
    }

    public static Boolean logCustomEvent(String eventName, int logLevel) {
        if (logger == null) {
            return false;
        }
        return logger.logCustomEvent(eventName, null, logLevel);
    }

    public static Boolean logCustomEvent(String eventName, HashMap<String, String> data) {
        if (logger == null) {
            return false;
        }
        return logger.logCustomEvent(eventName, data, ConfigurationUtil.getInt(TLF_LOGGING_LEVEL));
    }

    public static Boolean logCustomEvent(String eventName, HashMap<String, String> data, int logLevel) {
        if (logger == null) {
            return false;
        }
        return logger.logCustomEvent(eventName, data, logLevel);
    }

    public static Boolean logException(Throwable exception) {
        if (logger == null) {
            return false;
        }
        return logger.logException(exception, null, null);
    }

    public static Boolean logException(Throwable exception, String extraMessage) {
        if (logger == null) {
            return false;
        }
        return logger.logException(exception, extraMessage);
    }

    public static Boolean logException(Throwable exception, HashMap<String, String> data) {
        if (logger == null) {
            return false;
        }
        return logger.logException(exception, data);
    }

    public static Boolean logTLLibErrorException(Throwable exception, String extraMessage) {
        if (logger == null) {
            return false;
        }
        return logger.logTLLibErrorException(exception, extraMessage);
    }

    public static Boolean logScreenview(Activity activity, String logicalPageName, ScreenviewType screenviewType) {
        if (logger == null) {
            return false;
        }
        return logger.logScreenview(activity, logicalPageName, screenviewType, null);
    }

    public static Boolean logScreenview(Activity activity, String logicalPageName, ScreenviewType screenviewType, String referrer) {
        if (logger == null) {
            return false;
        }
        return logger.logScreenview(activity, logicalPageName, screenviewType, referrer);
    }

    public static Boolean logConnection(String url, HttpResponse httpResponse, long initTime, long loadTime, long responseTime) {
        return Tealeaf.logConnection(url, httpResponse, initTime, loadTime, responseTime, ConfigurationUtil.getInt(TLF_CONNECTION_LOGGING_LEVEL));
    }

    public static Boolean logConnection(String url, HttpResponse httpResponse, long initTime, long loadTime, long responseTime, int logLevel) {
        if (logger == null) {
            return false;
        }
        if (logLevel > TLFCache.getLogLevel()) {
            return false;
        }
        return logger.logConnection(url, httpResponse, initTime, loadTime, responseTime);
    }

    public static Boolean takeScreenShot(View view, String imageFileName) {
        return Tealeaf.takeScreenShot(view, imageFileName, ConfigurationUtil.getInt(TLF_PRINT_SCREEN));
    }

    public static Boolean takeScreenShot(View view, String imageFileName, int logLevel) {
        if (logLevel > TLFCache.getLogLevel()) {
            return false;
        }
        try {
            ScreenShotTask screenShotTask = new ScreenShotTask(view, imageFileName);
            screenShotTask.execute(new Void[0]);
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
        return true;
    }

    public static Boolean startSession() {
        String sessionId = null;
        return Tealeaf.startSession(sessionId);
    }

    public static Boolean startSession(String sessionId) {
        Boolean hasStarted = false;
        if (logger != null) {
            hasStarted = logger.enable(sessionId);
        }
        return hasStarted;
    }

    public static Boolean startSession(Boolean useKillSwitch) {
        if (!useKillSwitch.booleanValue()) {
            String sessionId = null;
            return Tealeaf.startSession(sessionId);
        }
        Tealeaf.callKillSwitch(useKillSwitch);
        return true;
    }

    public static Boolean requestManualServerPost() {
        Boolean hasPosted = false;
        if (ConfigurationUtil.getBoolean(TLF_MANUAL_POST_ENABLED).booleanValue() && !ConfigurationUtil.getBoolean(TLF_DO_POSTS_ON_INTERVALS).booleanValue()) {
            TLFCache.saveToCache(true);
            PostTask postTask = new PostTask();
            postTask.execute(new Void[0]);
            hasPosted = true;
        }
        return hasPosted;
    }

    public static long getApplicationScreenviewOffset() {
        if (logger == null) {
            return 0L;
        }
        return logger.getApplicationScreenviewOffset();
    }

    public static Boolean registerFormField(View formField, Activity activity) {
        return Tealeaf.registerFormField(formField, activity, ConfigurationUtil.getInt(TLF_LOGGING_LEVEL));
    }

    public static Boolean registerFormField(View formField, Activity activity, int logLevel) {
        if (logger == null) {
            return false;
        }
        return logger.registerFormField(formField, activity, logLevel);
    }

    public static Boolean isApplicationInBackground() {
        if (_applicationInForegroundCounter <= 0 && !TLFCache.hasBeenPostedInBackground().booleanValue()) {
            return true;
        }
        return false;
    }

    public static String getHttpXTealeafProperty() {
        if (TLFCache.getEnvironmentalData() == null || TLFCache.getEnvironmentalData().getHttpXTealeafProperty() == null) {
            return "";
        }
        return TLFCache.getEnvironmentalData().getHttpXTealeafProperty();
    }

    public static Screenview getCurrentScreenView() {
        if (logger == null) {
            return null;
        }
        return logger.getCurrentScreenview();
    }

    public static void setTLCookie() {
        Tealeaf.setTLCookie(ConfigurationUtil.getString(TLF_COOKIE_URL));
    }

    public static void setTLCookie(String url) {
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.setAcceptCookie(true);
        cookieManager.acceptCookie();
        if (url != null) {
            cookieManager.setCookie(url, Tealeaf.getTLCookie());
        }
        CookieSyncManager.getInstance().sync();
    }

    public static String getTLCookie() {
        return Tealeaf.getTLCookie(null);
    }

    public static String getTLCookie(String sessionId) {
        String extistingCookies;
        String cookieUrl;
        StringBuffer cookie = new StringBuffer();
        cookie.append(ConfigurationUtil.getString(TLF_COOKIE_PARAM));
        cookie.append('=');
        cookie.append(sessionId == null ? Tealeaf.getCurrentSessionId() : sessionId);
        if (ConfigurationUtil.getString(TLF_COOKIE_PATH) != null) {
            cookie.append(";Path=");
            cookie.append(ConfigurationUtil.getString(TLF_COOKIE_PATH));
        }
        if (ConfigurationUtil.getString(TLF_COOKIE_DOMAIN) != null) {
            cookie.append(";Domain=");
            cookie.append(ConfigurationUtil.getString(TLF_COOKIE_DOMAIN));
        }
        if (ConfigurationUtil.getBoolean(TLF_COOKIE_EXPIRES).booleanValue()) {
            cookie.append(";Expires=");
            String datePattern = "EEE MMM d HH:mm:ss yyyy";
            if ("RFC1036".equalsIgnoreCase(ConfigurationUtil.getString(TLF_COOKIE_EXPIRES_FORMAT))) {
                datePattern = "EEEE, dd-MMM-yy HH:mm:ss zzz";
            } else if ("RFC1123".equalsIgnoreCase(ConfigurationUtil.getString(TLF_COOKIE_EXPIRES_FORMAT))) {
                datePattern = "EEE, dd MMM yyyy HH:mm:ss zzz";
            }
            Date date = new Date(new Date().getTime() + ConfigurationUtil.getLongMSFromMinute(TLF_SESSION_TIMEOUT));
            String expiresDate = DateUtils.formatDate((Date)date, (String)datePattern);
            cookie.append(expiresDate);
        }
        if (ConfigurationUtil.getBoolean(TLF_COOKIE_SECURE).booleanValue()) {
            cookie.append(";Secure");
        }
        if ((cookieUrl = ConfigurationUtil.getString(TLF_COOKIE_URL)) != null && (extistingCookies = CookieManager.getInstance().getCookie(cookieUrl)) != null) {
            cookie.append(';');
            cookie.append(extistingCookies);
        }
        if (additionalCookies != null) {
            if (cookie.length() > 0) {
                cookie.append(';');
            }
            cookie.append(additionalCookies);
        }
        return cookie.toString();
    }

    public static void setAdditionalHeaders(HashMap<String, String> headers) {
        additionalHeaders = headers;
    }

    public static HashMap<String, String> getAdditionalHeaders() {
        return additionalHeaders;
    }

    public static void setAdditionalCookie(String cookie) {
        additionalCookies = cookie;
    }

    public static String getAdditionalCookie() {
        return additionalCookies;
    }

    public static Boolean logScreenLayout(Activity activity, AlertDialog alertDialog) {
        return Tealeaf.logScreenLayout(activity, alertDialog, null);
    }

    public static Boolean logScreenLayout(Activity activity, AlertDialog alertDialog, String name) {
        if (logger == null) {
            return false;
        }
        logger.logLayout(activity, alertDialog, name, false);
        return true;
    }

    public static Boolean logScreenLayoutSetOnShowListener(Activity activity, AlertDialog alertDialog) {
        return Tealeaf.logScreenLayoutSetOnShowListener(activity, alertDialog, null);
    }

    public static Boolean logScreenLayoutSetOnShowListener(final Activity activity, final AlertDialog alertDialog, final String name) {
        if (logger == null) {
            return false;
        }
        alertDialog.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface dialog) {
                DialogLogScreenTask dialogLogScreenTask = new DialogLogScreenTask(logger, activity, name, (Dialog)alertDialog);
                dialogLogScreenTask.execute(new Void[0]);
            }
        });
        return true;
    }

    public static Boolean logScreenLayout(Activity activity) {
        return Tealeaf.logScreenLayout(activity, null, 1);
    }

    public static Boolean logScreenLayout(Activity activity, String name) {
        return Tealeaf.logScreenLayout(activity, name, 1);
    }

    public static Boolean logScreenLayout(Activity activity, String name, int delayMS) {
        if (logger == null) {
            return false;
        }
        LogScreenTask logScreenTask = new LogScreenTask(activity, name, delayMS);
        logScreenTask.execute(new Void[0]);
        return true;
    }

    public static Boolean logScreenLayoutOnCreate(Activity activity, String name) {
        return Tealeaf.logScreenLayoutOnCreate(activity, name, 1);
    }

    public static Boolean logScreenLayoutOnCreate(Activity activity, String name, int delayMS) {
        if (activity == null || activity.getWindow() == null) {
            return false;
        }
        try {
            ViewGroup view = (ViewGroup)activity.getWindow().getDecorView();
            view.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)new UICOnGlobalLayoutListener(activity, (View)view, name, delayMS, true, TLFCache.setCurrentLayoutKey()));
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
        return true;
    }

    public static Layout logLayout(Activity activity, String name, Boolean isAlert) {
        if (logger == null) {
            return null;
        }
        return logger.logLayout(activity, name, isAlert);
    }
}

