/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic;

import android.os.Handler;
import android.os.Looper;
import com.tl.uic.EnvironmentalData;
import com.tl.uic.Tealeaf;
import com.tl.uic.model.ClientMessageHeader;
import com.tl.uic.model.JSONMessage;
import com.tl.uic.model.Layout;
import com.tl.uic.model.MessageFormat;
import com.tl.uic.model.Screenview;
import com.tl.uic.model.ScreenviewType;
import com.tl.uic.model.Session;
import com.tl.uic.model.TLFCacheFile;
import com.tl.uic.util.ConfigurationUtil;
import com.tl.uic.util.FileUtil;
import com.tl.uic.util.JsonUtil;
import com.tl.uic.util.LogInternal;
import com.tl.uic.util.PostTask;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TLFCache {
    private static int _logLevel;
    private static int _messageVersion;
    private static int _count;
    private static int _startIndex;
    private static int _lastIndex;
    private static final int PERCENT = 100;
    private static long _currentBufferSize;
    private static long _currentSessionStartedDate;
    private static String _currentSessionId;
    private static String _currentLayoutKey;
    private static List<TLFCacheFile> _memoryFiles;
    private static Session _currentSession;
    private static PostTask _postTask;
    private static Boolean _hasBeenPostedInBackground;
    private static LinkedHashMap<String, List<ClientMessageHeader>> _tempQueue;
    private static volatile TimerTask _postTimerTask;
    private static volatile TLFCache _myInstance;
    private static volatile EnvironmentalData _environmentalData;

    static {
        _messageVersion = 1;
        _count = 1;
        _startIndex = 0;
        _lastIndex = 0;
        _currentBufferSize = 0L;
        _currentLayoutKey = null;
        _hasBeenPostedInBackground = false;
        _tempQueue = new LinkedHashMap();
    }

    public static synchronized TLFCache getInstance() {
        if (_myInstance == null) {
            _myInstance = new TLFCache();
        }
        return _myInstance;
    }

    private TLFCache() {
    }

    public static Boolean onPause() {
        if (_environmentalData != null) {
            _environmentalData.onPause();
        }
        return true;
    }

    public static Boolean onResume() {
        _hasBeenPostedInBackground = false;
        if (_environmentalData != null) {
            _environmentalData.onResume();
        }
        TLFCache.setupPostTask();
        return true;
    }

    public static synchronized Boolean terminate() {
        _messageVersion = 1;
        _count = 1;
        _currentSession.clean();
        _currentSession = null;
        _currentSessionStartedDate = 0L;
        _environmentalData.terminate();
        _environmentalData = null;
        _logLevel = 0;
        _currentBufferSize = 0L;
        if (_postTimerTask != null) {
            _postTimerTask.cancel();
            _postTimerTask = null;
            TLFCache.flushPostTask();
            _postTimerTask = null;
        }
        return true;
    }

    public static Boolean getHasToPersistLocalCache() {
        return ConfigurationUtil.getBoolean("HasToPersistLocalCache");
    }

    public static int getBufferLimit() {
        return ConfigurationUtil.getInt("BufferLimit");
    }

    public static int getBufferPercent() {
        return ConfigurationUtil.getInt("BufferPercent");
    }

    public static int getCacheLevel() {
        return ConfigurationUtil.getInt("CachingLevel");
    }

    public static long getCachedFileMaxBytesSize() {
        return ConfigurationUtil.getLong("CachedFileMaxBytesSize");
    }

    public static long getPostMessageMaxBytesSize() {
        return ConfigurationUtil.getLong("PostMessageMaxBytesSize");
    }

    public static long getTLFCacheFileMaxBytesSize() {
        return TLFCache.getCachedFileMaxBytesSize() > TLFCache.getPostMessageMaxBytesSize() ? TLFCache.getPostMessageMaxBytesSize() : TLFCache.getCachedFileMaxBytesSize();
    }

    public static String getCurrentSessionId() {
        return _currentSessionId;
    }

    public static void setCurrentSessionId(String sessionId) {
        _currentSessionId = sessionId;
    }

    public static int getLogLevel() {
        return _logLevel;
    }

    public static EnvironmentalData getEnvironmentalData() {
        return _environmentalData;
    }

    public static Boolean hasBeenPostedInBackground() {
        return _hasBeenPostedInBackground;
    }

    public static long getCurrentBufferSize() {
        return _currentBufferSize;
    }

    public static List<JSONMessage> getMessages() {
        if (_currentSession == null) {
            return null;
        }
        return _currentSession.getMessages();
    }

    private static Boolean removeMessage(JSONMessage jsonMessage) {
        if (jsonMessage == null) {
            return false;
        }
        try {
            TLFCache.getMessages().remove(jsonMessage);
            _currentBufferSize -= jsonMessage.getSize();
        }
        catch (Exception ex) {
            Tealeaf.logException(ex);
        }
        return true;
    }

    public static Boolean clearMessages() {
        if (TLFCache.getMessages() == null) {
            return false;
        }
        TLFCache.getMessages().clear();
        _currentSession.setHasUICData(false);
        return true;
    }

    public static Boolean clearMessages(int amount) {
        if (TLFCache.getMessages() == null) {
            return false;
        }
        int i = 0;
        Boolean hasUICData = false;
        for (JSONMessage jsonMessage : TLFCache.getMessages()) {
            if (i < amount) {
                TLFCache.removeMessage(jsonMessage);
                jsonMessage = null;
                ++i;
                continue;
            }
            if (!jsonMessage.getHasUICData().booleanValue()) continue;
            hasUICData = true;
            break;
        }
        _currentSession.setHasUICData(hasUICData);
        return true;
    }

    public static Boolean addMessage(ClientMessageHeader message) {
        if (message == null) {
            return false;
        }
        if (!TLFCache.checkType10(message).booleanValue()) {
            return true;
        }
        return TLFCache.addMessageNoTest(message);
    }

    private static Boolean addMessageNoTest(ClientMessageHeader message) {
        if (message == null) {
            return false;
        }
        return TLFCache.addMes(message);
    }

    public static String getCurrentLayoutKey() {
        if (_currentLayoutKey == null) {
            TLFCache.setCurrentLayoutKey();
        }
        return _currentLayoutKey;
    }

    public static String setCurrentLayoutKey() {
        _currentLayoutKey = Integer.toString(_lastIndex++);
        if (_tempQueue != null) {
            _tempQueue.put(_currentLayoutKey, new CopyOnWriteArrayList());
        }
        return _currentLayoutKey;
    }

    public static void flushLayout(String layoutKey, Layout layout) {
        if (_tempQueue != null && layoutKey != null) {
            try {
                int key = Integer.parseInt(layoutKey);
                if (key > _startIndex) {
                    int stop = key;
                    while (_startIndex <= stop) {
                        TLFCache.flushNonLayout(Integer.toString(_startIndex));
                        ++_startIndex;
                    }
                }
                TLFCache.addMessageNoTest(layout);
                TLFCache.flushNonLayout(layoutKey);
                _startIndex = key + 1;
            }
            catch (Exception exception) {
                LogInternal.logException(exception);
            }
        }
    }

    public static void flushNonLayout(String key) {
        if (_tempQueue != null && _tempQueue.containsKey(key)) {
            for (ClientMessageHeader clientMessageHeader : _tempQueue.get(key)) {
                LogInternal.log("Key:" + key + "=" + clientMessageHeader.getJSON());
                TLFCache.addMessageNoTest(clientMessageHeader);
            }
            _tempQueue.get(key).clear();
            _tempQueue.remove(key);
            if (_tempQueue.size() == 0) {
                _currentLayoutKey = null;
            }
        }
    }

    private static Boolean checkType10(ClientMessageHeader message) {
        if (!ConfigurationUtil.getBoolean("LogViewLayoutOnScreenTransition").booleanValue()) {
            return true;
        }
        if (_tempQueue != null && _tempQueue.size() <= 0) {
            TLFCache.setCurrentLayoutKey();
        }
        List<ClientMessageHeader> tempMessages = null;
        if (_tempQueue != null) {
            tempMessages = _tempQueue.get(_currentLayoutKey);
        }
        if (message instanceof Screenview) {
            if (ScreenviewType.LOAD.equals(((Screenview)message).getScreenviewType())) {
                tempMessages.add(message);
                TLFCache.setCurrentLayoutKey();
            }
        } else {
            tempMessages.add(message);
        }
        return false;
    }

    private static Boolean addMes(ClientMessageHeader message) {
        if (!JsonUtil.testMessageType(message, false).booleanValue()) {
            return false;
        }
        message.setCount(_count++);
        JSONMessage jsonMessage = new JSONMessage(message);
        return TLFCache.addJSONMessage(jsonMessage);
    }

    public static Boolean addMessage(String bridgeMessage) {
        JSONObject jsonObject = null;
        if (!JsonUtil.testMessageType(bridgeMessage, false).booleanValue()) {
            return false;
        }
        try {
            jsonObject = new JSONObject(bridgeMessage);
            jsonObject.put("offset", TLFCache.timestampFromSession());
            jsonObject.put("count", _count++);
        }
        catch (Exception e) {
            LogInternal.logException(e, "Issue changing offset from :" + bridgeMessage);
        }
        JSONMessage jsonMessage = new JSONMessage(true);
        jsonMessage.setJsonData(jsonObject == null ? bridgeMessage : jsonObject.toString());
        jsonMessage.setLogLevel(1);
        return TLFCache.addJSONMessage(jsonMessage);
    }

    private static Boolean addJSONMessage(JSONMessage message) {
        Boolean hasBeenAdded = false;
        if (message.getJsonData() == null || "".equals(message.getJsonData())) {
            return hasBeenAdded;
        }
        if (TLFCache.getMessages() != null || _currentBufferSize >= TLFCache.getTLFCacheFileMaxBytesSize() || !TLFCache.saveToCache(false).booleanValue()) {
            TLFCache.cleanByCacheLevel();
            long idealSize = TLFCache.getTLFCacheFileMaxBytesSize() - TLFCache.getTLFCacheFileMaxBytesSize() * (long)TLFCache.getBufferPercent() / 100L;
            if (_currentBufferSize > idealSize) {
                if (TLFCache.getHasToPersistLocalCache().booleanValue()) {
                    TLFCache.saveToCache(false);
                } else {
                    TLFCache.saveToCache(false);
                    while (TLFCache.getMessages().size() > 0 && _currentBufferSize > idealSize) {
                        _currentBufferSize -= TLFCache.getMessages().get(0).getSize();
                        TLFCache.clearMessages(1);
                    }
                }
            }
        }
        if (TLFCache.getMessages() != null) {
            long messageBytesSize = TLFCache.sizeOfObject(message);
            message.setSize(messageBytesSize);
            hasBeenAdded = TLFCache.getMessages().add(message);
            if (hasBeenAdded.booleanValue()) {
                StringBuffer logMessage = new StringBuffer("Added:");
                logMessage.append(message.toString());
                LogInternal.log(logMessage.toString());
                logMessage = null;
                _currentBufferSize += messageBytesSize;
                if (message.getHasUICData().booleanValue()) {
                    _currentSession.setHasUICData(true);
                }
            }
        }
        return hasBeenAdded;
    }

    public static synchronized List<TLFCacheFile> getMemoryFiles() {
        if (_memoryFiles == null) {
            _memoryFiles = new CopyOnWriteArrayList<TLFCacheFile>();
        }
        return _memoryFiles;
    }

    public static Boolean addToMemoryFiles(TLFCacheFile tlfCacheFile) {
        return TLFCache.getMemoryFiles().add(tlfCacheFile);
    }

    private static Boolean cleanByCacheLevel() {
        if (TLFCache.getMessages() == null || TLFCache.getMessages().size() <= 0) {
            return false;
        }
        for (JSONMessage jsonMessage : TLFCache.getMessages()) {
            if (jsonMessage.getLogLevel() <= TLFCache.getCacheLevel()) continue;
            TLFCache.removeMessage(jsonMessage);
            Object var1_1 = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Boolean startSession(String sessionId) {
        block8: {
            block7: {
                TLFCache.setupPostTask();
                TLFCache.saveToCache(false);
                _currentSessionStartedDate = new Date().getTime();
                if (sessionId != null) break block7;
                if (!ConfigurationUtil.getBoolean("KillSwitchEnabled").booleanValue()) {
                    _currentSessionId = TLFCache.createSessionId();
                    break block8;
                } else if (_currentSessionId == null) {
                    _currentSessionId = TLFCache.createSessionId();
                }
                break block8;
            }
            _currentSessionId = sessionId;
        }
        _currentSession = new Session();
        _currentSession.setSessionID(_currentSessionId);
        _currentSession.setSessionStartTime(_currentSessionStartedDate);
        if (_environmentalData == null) {
            EnvironmentalData eData;
            Class<TLFCache> clazz = TLFCache.class;
            // MONITORENTER : com.tl.uic.TLFCache.class
            _environmentalData = eData = new EnvironmentalData(Tealeaf.getApplication());
            // MONITOREXIT : clazz
        }
        _count = 1;
        return true;
    }

    private static synchronized void setupPostTask() {
        Boolean hasManualPost = ConfigurationUtil.getBoolean("ManualPostEnabled");
        if (hasManualPost.booleanValue() || _postTimerTask != null) {
            return;
        }
        if (_postTimerTask != null) {
            _postTimerTask.cancel();
        }
        final Handler handler = new Handler(Looper.getMainLooper());
        Timer timer = new Timer();
        _postTimerTask = new TimerTask(){

            public void run() {
                handler.post(new Runnable(){

                    public void run() {
                        try {
                            if (_postTask == null) {
                                _postTask = new PostTask();
                                _postTask.execute(new Void[0]);
                            }
                        }
                        catch (Exception e) {
                            LogInternal.logException(e);
                        }
                    }
                });
            }
        };
        timer.schedule(_postTimerTask, 0L, ConfigurationUtil.getLongMS("PostMessageTimeIntervals"));
    }

    public static synchronized Boolean closePostTask() {
        if (_postTask != null) {
            _postTask = null;
        }
        if (Tealeaf.isApplicationInBackground().booleanValue()) {
            Tealeaf.onPauseNoActivityInForeground();
            _hasBeenPostedInBackground = true;
        }
        return true;
    }

    private static void flushPostTask() {
        Handler handler = new Handler();
        handler.post(new Runnable(){

            public void run() {
                try {
                    if (_postTask != null && !_postTask.isRunning().booleanValue()) {
                        TLFCache.closePostTask();
                        _postTask = new PostTask();
                        _postTask.execute(new Void[0]);
                    }
                }
                catch (Exception e) {
                    LogInternal.logException(e);
                }
            }
        });
    }

    public static String createSessionId() {
        UUID uuid = UUID.randomUUID();
        String id = uuid.toString().replace("-", "");
        return id.toUpperCase(Locale.ENGLISH);
    }

    public static void setCurrentLogLevel(Boolean hasConnection, Boolean isWifi, Boolean isMobile) {
        if (hasConnection.booleanValue()) {
            if (isWifi.booleanValue()) {
                _logLevel = ConfigurationUtil.getInt("PostMessageLevelWiFi");
            } else if (isMobile.booleanValue()) {
                _logLevel = ConfigurationUtil.getInt("PostMessageLevelCellular");
            }
        } else {
            _logLevel = ConfigurationUtil.getInt("LoggingLevel");
        }
    }

    public static long timestampFromSession() {
        return new Date().getTime() - _currentSessionStartedDate;
    }

    private static TLFCacheFile createTLFCacheFile(MessageFormat messageFormat) {
        String json = messageFormat.getJSON().toString();
        String sessionID = messageFormat.getSession().getSessionID();
        Boolean hasUICData = messageFormat.getSession().getHasUICData();
        TLFCacheFile tlfCacheFile = new TLFCacheFile(json, sessionID, hasUICData);
        TLFCache.clearMessages(messageFormat.getSession().getMessages().size());
        return tlfCacheFile;
    }

    public static Boolean saveToCache(Boolean toFlush) {
        Boolean hasFlushed = toFlush;
        Boolean hasBeenSaved = false;
        if (_currentSession == null) {
            return hasBeenSaved;
        }
        MessageFormat messageFormat = TLFCache.createMessageFormat();
        if (messageFormat != null) {
            Date currentDate = new Date();
            TLFCacheFile tlfCacheFile = TLFCache.createTLFCacheFile(messageFormat);
            hasBeenSaved = TLFCache.getHasToPersistLocalCache() != false ? FileUtil.saveObject(tlfCacheFile, "TLFCache", "cache_" + currentDate.getTime()) : TLFCache.addToMemoryFiles(tlfCacheFile);
        }
        if (_postTimerTask != null && hasFlushed.booleanValue()) {
            try {
                _postTimerTask.cancel();
                _postTimerTask = null;
                TLFCache.flushPostTask();
                hasBeenSaved = true;
            }
            catch (Exception e) {
                LogInternal.logException(e);
            }
        }
        if (hasBeenSaved.booleanValue()) {
            TLFCache.getMessages().clear();
            _currentBufferSize = 0L;
        }
        return hasBeenSaved;
    }

    private static MessageFormat createMessageFormat() {
        if (TLFCache.getMessages() == null || TLFCache.getMessages().size() <= 0) {
            return null;
        }
        MessageFormat messageFormat = new MessageFormat();
        messageFormat.setMessageVersion(Tealeaf.getMessageVersion());
        messageFormat.setSerialNumber(_messageVersion++);
        _currentSession.setClientEnvironment(_environmentalData.createClientEnvironment());
        messageFormat.setSession(_currentSession);
        LogInternal.log("MessageFormat created:" + messageFormat.getJSON().toString());
        return messageFormat;
    }

    public static List<TLFCacheFile> messageFormats() {
        MessageFormat messageFormat;
        List<Object> objects = new ArrayList();
        if (TLFCache.getHasToPersistLocalCache().booleanValue()) {
            objects = FileUtil.getObjects("TLFCache");
        } else if (TLFCache.getMemoryFiles().size() > 0 && TLFCache.getMemoryFiles().size() > 0) {
            for (TLFCacheFile tlfCacheFile : TLFCache.getMemoryFiles()) {
                objects.add(tlfCacheFile);
                try {
                    TLFCache.getMemoryFiles().remove(tlfCacheFile);
                }
                catch (Exception ex) {
                    Tealeaf.logException(ex);
                }
            }
        }
        if (objects.isEmpty() && (messageFormat = TLFCache.createMessageFormat()) != null && messageFormat.getSession() != null && messageFormat.getSession().getSessionID() != null) {
            TLFCacheFile tlfCacheFile;
            tlfCacheFile = TLFCache.createTLFCacheFile(messageFormat);
            objects.add(tlfCacheFile);
        }
        return objects;
    }

    public static long sizeOfObject(Object obj) {
        long size = 0L;
        try {
            ByteArrayOutputStream byteObject = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteObject);
            objectOutputStream.writeObject(obj);
            objectOutputStream.flush();
            objectOutputStream.close();
            byteObject.close();
            size = byteObject.toByteArray().length;
        }
        catch (IOException e) {
            LogInternal.logException(e);
        }
        return size;
    }
}

