/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Application;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.graphics.drawable.PaintDrawable;
import android.graphics.drawable.StateListDrawable;
import android.inputmethodservice.KeyboardView;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.webkit.WebView;
import android.widget.AbsListView;
import android.widget.AbsSeekBar;
import android.widget.AbsSpinner;
import android.widget.AnalogClock;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.DatePicker;
import android.widget.DialerFilter;
import android.widget.DigitalClock;
import android.widget.EditText;
import android.widget.ExpandableListView;
import android.widget.FrameLayout;
import android.widget.Gallery;
import android.widget.HorizontalScrollView;
import android.widget.ImageButton;
import android.widget.ImageSwitcher;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RatingBar;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.Scroller;
import android.widget.SlidingDrawer;
import android.widget.Spinner;
import android.widget.TabHost;
import android.widget.TabWidget;
import android.widget.TextView;
import android.widget.TimePicker;
import android.widget.ToggleButton;
import com.tl.uic.TLFCache;
import com.tl.uic.Tealeaf;
import com.tl.uic.model.BaseTarget;
import com.tl.uic.model.Connection;
import com.tl.uic.model.Control;
import com.tl.uic.model.CustomEvent;
import com.tl.uic.model.EventInfo;
import com.tl.uic.model.Image;
import com.tl.uic.model.ImageType;
import com.tl.uic.model.JSONException;
import com.tl.uic.model.Layout;
import com.tl.uic.model.Position;
import com.tl.uic.model.Screenview;
import com.tl.uic.model.ScreenviewType;
import com.tl.uic.model.Style;
import com.tl.uic.model.TableRowStyleType;
import com.tl.uic.model.Target;
import com.tl.uic.util.ConfigurationUtil;
import com.tl.uic.util.ImageUtil;
import com.tl.uic.util.LogInternal;
import com.tl.uic.util.ReflectionUtil;
import com.tl.uic.util.ValueUtil;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressLint(value={"NewApi"})
public class Logger {
    private static final int MASK_OUT_ALPHA = 0xFF00FF;
    private Date loadDate;
    private Screenview currentScreenview;
    private Application _application;
    private Date _previousFocusControlDate;
    private Target _previousFocusTarget;
    private final ConcurrentHashMap<Integer, ConcurrentHashMap<Integer, Control>> _formActivities;
    private Activity _currentActivity;
    private static final String TEXT_KEY_NAME = "text";
    private static final String VALUE_KEY_NAME = "value";
    private static final String IS_SELECTED_KEY_NAME = "isSelected";
    private static final int KEY_LEFT = 0;
    private static final int KEY_TOP = 1;
    private static final int KEY_RIGHT = 2;
    private static final int KEY_BOTTOM = 3;

    public Logger(Application application) {
        this._application = application;
        this._formActivities = new ConcurrentHashMap();
    }

    public final Screenview getCurrentScreenview() {
        return this.currentScreenview;
    }

    protected final Boolean enable(String sessionId) {
        return TLFCache.startSession(sessionId);
    }

    protected final Boolean onPause(Activity activity, String logicalPageName) {
        LogInternal.log(String.valueOf(logicalPageName) + " goes to background");
        Tealeaf.logScreenview(activity, logicalPageName, ScreenviewType.UNLOAD);
        this.onPauseNoActivityInForeground();
        return true;
    }

    protected final Boolean onPauseNoActivityInForeground() {
        TLFCache.onPause();
        LogInternal.log("Application goes to background");
        return true;
    }

    protected final Boolean onResume(String logicalPageName, Activity activity) {
        TLFCache.onResume();
        LogInternal.log(String.valueOf(logicalPageName) + " comes from background");
        this.logScreenview(activity, logicalPageName, ScreenviewType.LOAD, null);
        return true;
    }

    protected final Boolean onDestroy(String logicalPageName) {
        LogInternal.log(String.valueOf(logicalPageName) + " is destroyed", 5);
        Tealeaf.flush();
        return true;
    }

    protected final Boolean terminate() {
        this._application = null;
        TLFCache.terminate();
        return true;
    }

    protected final long getApplicationScreenviewOffset() {
        if (this.loadDate != null) {
            return new Date().getTime() - this.loadDate.getTime();
        }
        return 0L;
    }

    protected final Boolean logEvent(View view, String eventType, int logLevel) {
        if (logLevel > TLFCache.getLogLevel()) {
            return false;
        }
        Control control = this.createControl(view, eventType, logLevel, false);
        if (eventType != null && eventType.equals("OnFocusChange_In")) {
            return true;
        }
        return TLFCache.addMessage(control);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Control createControl(View view, String eventType, int logLevel, Boolean isAlert) {
        Control control = new Control();
        control.setLogLevel(logLevel);
        Target target = this.createTarget(view, isAlert);
        Boolean saveFormField = this.getState(target, view, eventType, false);
        control.setTarget(target);
        if (eventType != null) {
            int keyboardHeight;
            int deviceHeight;
            int deviceWidth;
            EventInfo eventInfo = new EventInfo();
            eventInfo.setType(eventType);
            eventInfo.setTlEvent(this.getTlEvent(control.getTarget().getTlType(), eventInfo.getType()));
            control.setEventInfo(eventInfo);
            if (eventType.equals("OnFocusChange_Out") && control.getTarget() != null && control.getTarget().getDwell() > 0L) {
                control.setFocusInOffset(control.getOffset() - control.getTarget().getDwell());
            }
            if ("kbHidden".equals(control.getEventInfo().getTlEvent())) {
                control.getTarget().getStyle().setHidden(true);
                deviceWidth = (int)TLFCache.getEnvironmentalData().getScreenReceiver().getDeviceWidth();
                deviceHeight = (int)TLFCache.getEnvironmentalData().getScreenReceiver().getDeviceHeight();
                keyboardHeight = (int)(0.38 * (double)deviceHeight);
                control.getTarget().getPosition().setWidth(deviceWidth);
                control.getTarget().getPosition().setHeight(keyboardHeight);
                control.getTarget().getPosition().setY(deviceHeight);
            }
            if ("kbDisplayed".equals(control.getEventInfo().getTlEvent())) {
                deviceWidth = (int)TLFCache.getEnvironmentalData().getScreenReceiver().getDeviceWidth();
                deviceHeight = (int)TLFCache.getEnvironmentalData().getScreenReceiver().getDeviceHeight();
                keyboardHeight = (int)(0.38 * (double)deviceHeight);
                control.getTarget().getPosition().setWidth(deviceWidth);
                control.getTarget().getPosition().setHeight(keyboardHeight);
                control.getTarget().getPosition().setY(deviceHeight - keyboardHeight);
            }
        }
        if (saveFormField.booleanValue() && this._currentActivity != null) {
            if (!this._formActivities.containsKey(this._currentActivity.hashCode())) {
                Logger logger = this;
                synchronized (logger) {
                    this._formActivities.putIfAbsent(this._currentActivity.hashCode(), new ConcurrentHashMap());
                }
            }
            this._formActivities.get(this._currentActivity.hashCode()).put(view.getId(), control);
        }
        return control;
    }

    private Target createTarget(View view, Boolean isAlert) {
        Target target = new Target();
        target.setType(this.getControlType(view));
        target.setSubType(this.getControlSubType(view));
        target.setId(this.getPropertyName(view));
        target.setPosition(this.getPosition(view, isAlert));
        target.setTlType(this.getTlType(view));
        target.setStyle(this.getStyle(view, false));
        return target;
    }

    private String getControlType(Object control) {
        return control == null ? null : control.getClass().getSimpleName();
    }

    private String getControlSubType(Object control) {
        return control == null ? null : (control.getClass().getSuperclass() == null ? null : control.getClass().getSuperclass().getSimpleName());
    }

    private String getPropertyName(View view) {
        String propertyName = "-1";
        try {
            Resources resources = this._application.getResources();
            propertyName = view.getId() == -1 ? "-1" : resources.getResourceName(view.getId());
        }
        catch (Exception e) {
            propertyName = "-1";
        }
        if ("-1".equals(propertyName)) {
            propertyName = String.valueOf(Integer.toString(view.hashCode())) + "h";
        }
        return propertyName;
    }

    private Position getPosition(View view, Boolean isAlert) {
        Position position = new Position();
        position.setHeight(view.getHeight());
        position.setWidth(view.getWidth());
        int[] location = new int[2];
        if (!isAlert.booleanValue()) {
            view.getLocationInWindow(location);
        } else {
            view.getLocationOnScreen(location);
        }
        position.setX(location[0]);
        position.setY(location[1]);
        return position;
    }

    private Position getPosition(View view, Drawable drawable, Boolean isAlert) {
        Position basePosition = this.getPosition(view, isAlert);
        Position position = new Position();
        position.setHeight(drawable.getIntrinsicHeight());
        position.setWidth(drawable.getIntrinsicWidth());
        position.setX(basePosition.getX());
        position.setY(basePosition.getY());
        return position;
    }

    private Boolean getState(BaseTarget target, Object widget, String eventType, Boolean isLayout) {
        Boolean saveState = false;
        HashMap<String, Object> current = new HashMap<String, Object>();
        if (target == null || widget == null) {
            return saveState;
        }
        if (widget instanceof ToggleButton) {
            current.put("isToggled", ((ToggleButton)widget).isChecked());
            this.trimAndMaskValueForControl(current, TEXT_KEY_NAME, ((ToggleButton)widget).getText() != null ? ((ToggleButton)widget).getText().toString() : "", target.getId());
        } else if (this.checkClass(widget, "Switch").booleanValue()) {
            Boolean isChecked = (Boolean)ReflectionUtil.getValueFromObject(widget, "isChecked");
            current.put("isToggled", isChecked);
            String text = (String)ReflectionUtil.getValueFromObject(widget, "getText");
            this.trimAndMaskValueForControl(current, TEXT_KEY_NAME, text != null ? text : "", target.getId());
        } else if (widget instanceof Button) {
            this.trimAndMaskValueForControl(current, TEXT_KEY_NAME, ((Button)widget).getText() == null ? null : ((Button)widget).getText().toString(), target.getId());
            current.put("font", this.getFont(widget));
            if (widget instanceof CheckBox) {
                current.put("isChecked", ((CheckBox)widget).isChecked());
            } else if (widget instanceof RadioButton) {
                current.put(IS_SELECTED_KEY_NAME, ((RadioButton)widget).isSelected());
            }
        } else if (widget instanceof DatePicker) {
            GregorianCalendar datePickerValue = new GregorianCalendar(((DatePicker)widget).getYear(), ((DatePicker)widget).getMonth(), ((DatePicker)widget).getDayOfMonth());
            this.trimAndMaskValueForControl(current, "date", String.valueOf(datePickerValue.getTime()), target.getId());
        } else if (widget instanceof Scroller) {
            this.trimAndMaskValueForControl(current, "x", Integer.toString(((Scroller)widget).getFinalX()), target.getId());
            this.trimAndMaskValueForControl(current, "y", Integer.toString(((Scroller)widget).getFinalY()), target.getId());
        } else if (widget instanceof HorizontalScrollView) {
            this.trimAndMaskValueForControl(current, "x", Integer.toString(((HorizontalScrollView)widget).getScrollX()), target.getId());
            this.trimAndMaskValueForControl(current, "y", Integer.toString(((HorizontalScrollView)widget).getScrollY()), target.getId());
        } else if (widget instanceof ScrollView) {
            this.trimAndMaskValueForControl(current, "x", Integer.toString(((ScrollView)widget).getScrollX()), target.getId());
            this.trimAndMaskValueForControl(current, "y", Integer.toString(((ScrollView)widget).getScrollY()), target.getId());
        } else if (widget instanceof DialerFilter) {
            this.trimAndMaskValueForControl(current, TEXT_KEY_NAME, ((DialerFilter)widget).getFilterText() == null ? null : ((DialerFilter)widget).getFilterText().toString(), target.getId());
        } else if (widget instanceof ProgressBar) {
            this.trimAndMaskValueForControl(current, VALUE_KEY_NAME, Integer.toString(((ProgressBar)widget).getProgress()), target.getId());
            this.trimAndMaskValueForControl(current, "maxValue", Integer.toString(((ProgressBar)widget).getMax()), target.getId());
            if (widget instanceof RatingBar) {
                this.trimAndMaskValueForControl(current, "numStars", Integer.toString(((RatingBar)widget).getNumStars()), target.getId());
            }
        } else if (widget instanceof RadioGroup) {
            RadioButton radioButton = (RadioButton)((View)widget).findViewById(((RadioGroup)widget).getCheckedRadioButtonId());
            this.trimAndMaskValueForControl(current, TEXT_KEY_NAME, radioButton == null || radioButton.getText() == null ? null : radioButton.getText().toString(), target.getId());
        } else if (widget instanceof Spinner) {
            TextView textView;
            if (!isLayout.booleanValue() && this._formActivities != null && this._currentActivity != null) {
                Control control;
                ConcurrentHashMap<Integer, Control> controls = this._formActivities.get(this._currentActivity.hashCode());
                if (controls != null && (control = controls.get(((Spinner)widget).getId())) != null && control.getTarget() != null && control.getTarget().getCurrentState() != null) {
                    HashMap<String, Object> preState = new HashMap<String, Object>();
                    preState.put(VALUE_KEY_NAME, control.getTarget().getCurrentState().get(VALUE_KEY_NAME).toString());
                    preState.put(TEXT_KEY_NAME, control.getTarget().getCurrentState().get(TEXT_KEY_NAME).toString());
                    preState.put("IS_SELECTED_KEY_NAME", "false");
                    ((Target)target).setPreviousState(preState);
                }
                saveState = true;
            }
            Object value = null;
            value = ((Spinner)widget).getPrompt() != null ? ((Spinner)widget).getPrompt().toString() : ((textView = (TextView)((Spinner)widget).getChildAt(0)) == null ? null : (textView.getText() == null ? null : textView.getText().toString()));
            this.trimAndMaskValueForControl(current, TEXT_KEY_NAME, (String)value, target.getId());
            this.trimAndMaskValueForControl(current, VALUE_KEY_NAME, (String)value, target.getId());
            this.trimAndMaskValueForControl(current, IS_SELECTED_KEY_NAME, "true", target.getId());
        } else if (widget instanceof TabHost) {
            this.trimAndMaskValueForControl(current, TEXT_KEY_NAME, ((TabHost)widget).getCurrentTabTag() == null ? null : ((TabHost)widget).getCurrentTabTag().toString(), target.getId());
        } else if (widget instanceof TabWidget) {
            this.trimAndMaskValueForControl(current, TEXT_KEY_NAME, ((TabWidget)widget).getTag() == null ? null : ((TabWidget)widget).getTag().toString(), target.getId());
        } else if (widget instanceof TextView) {
            if (!isLayout.booleanValue()) {
                if (eventType != null && (eventType.equals("OnFocusChange_In") || eventType.equals("OnFocusChange_Out"))) {
                    if (eventType.equals("OnFocusChange_In")) {
                        this._previousFocusControlDate = new Date();
                        this.trimAndMaskValueForControl(current, TEXT_KEY_NAME, ((TextView)widget).getText() == null ? null : ((TextView)widget).getText().toString(), target.getId());
                        target.setCurrentState(current);
                        this._previousFocusTarget = (Target)target;
                    } else if (eventType.equals("OnFocusChange_Out")) {
                        this.trimAndMaskValueForControl(current, TEXT_KEY_NAME, ((TextView)widget).getText() == null ? null : ((TextView)widget).getText().toString(), target.getId());
                        if (this._previousFocusTarget != null && this._previousFocusTarget.equals(target) && this._previousFocusControlDate != null) {
                            ((Target)target).setPreviousState(this._previousFocusTarget.getCurrentState());
                            ((Target)target).setDwell(new Date().getTime() - this._previousFocusControlDate.getTime());
                        }
                        this.setVisitedCount((View)((TextView)widget), (Target)target);
                        saveState = true;
                    }
                } else {
                    this.trimAndMaskValueForControl(current, TEXT_KEY_NAME, ((TextView)widget).getText() == null ? null : ((TextView)widget).getText().toString(), target.getId());
                    this.setVisitedCount((View)((TextView)widget), (Target)target);
                }
            } else {
                this.trimAndMaskValueForControl(current, TEXT_KEY_NAME, ((TextView)widget).getText() == null ? null : ((TextView)widget).getText().toString(), target.getId());
                this.trimAndMaskValueForControl(current, "placeHolder", ((TextView)widget).getHint() == null ? null : ((TextView)widget).getHint().toString(), target.getId());
                target.setCurrentState(current);
            }
            current.put("font", this.getFont(widget));
        } else if (widget instanceof TimePicker) {
            StringBuffer timePickerValue = new StringBuffer(Integer.toString(((TimePicker)widget).getCurrentHour()));
            String minutes = Integer.toString(((TimePicker)widget).getCurrentMinute());
            timePickerValue.append(minutes.length() == 1 ? ":0" + minutes : ":" + minutes);
            this.trimAndMaskValueForControl(current, "time", timePickerValue.toString(), target.getId());
        } else if (widget instanceof AbsListView) {
            if (widget instanceof ExpandableListView && eventType != null) {
                if (eventType.equals("OnGroupCollapse")) {
                    this.trimAndMaskValueForControl(current, TEXT_KEY_NAME, "collapsed", target.getId());
                } else if (eventType.equals("OnGroupExpand")) {
                    this.trimAndMaskValueForControl(current, TEXT_KEY_NAME, "expanded", target.getId());
                }
            }
            this.trimAndMaskValueForControl(current, "x", Integer.toString(((AbsListView)widget).getLeft()), target.getId());
            this.trimAndMaskValueForControl(current, "y", Integer.toString(((AbsListView)widget).getTop()), target.getId());
        } else if (widget instanceof SlidingDrawer) {
            if (eventType != null) {
                if (eventType.equals("OnDrawerOpened")) {
                    this.trimAndMaskValueForControl(current, TEXT_KEY_NAME, "opened", target.getId());
                } else if (eventType.equals("OnDrawerClosed")) {
                    this.trimAndMaskValueForControl(current, TEXT_KEY_NAME, "closed", target.getId());
                }
            }
            this.trimAndMaskValueForControl(current, "x", Integer.toString(((SlidingDrawer)widget).getLeft()), target.getId());
            this.trimAndMaskValueForControl(current, "y", Integer.toString(((SlidingDrawer)widget).getTop()), target.getId());
        } else if (widget instanceof AlertDialog) {
            Activity alertActivity = ((AlertDialog)widget).getOwnerActivity();
            if (alertActivity != null) {
                TextView message = (TextView)alertActivity.findViewById(16908299);
                TextView title = (TextView)alertActivity.findViewById(16908310);
                this.trimAndMaskValueForControl(current, "title", message.getText() == null ? null : message.getText().toString(), target.getId());
                this.trimAndMaskValueForControl(current, "message", title.getText() == null ? null : title.getText().toString(), target.getId());
            }
        } else if (widget instanceof KeyboardView) {
            this.trimAndMaskValueForControl(current, "x", Integer.toString(((KeyboardView)widget).getLeft()), target.getId());
            this.trimAndMaskValueForControl(current, "y", Integer.toString(((KeyboardView)widget).getTop()), target.getId());
        }
        target.setCurrentState(current);
        return saveState;
    }

    private JSONObject getFont(Object widget) {
        JSONObject font = new JSONObject();
        String fontFamilyName = "sans-serif";
        if (((TextView)widget).getTypeface() != null) {
            try {
                if (Typeface.SERIF.equals((Object)((TextView)widget).getTypeface())) {
                    fontFamilyName = "serif";
                } else if (Typeface.MONOSPACE.equals((Object)((TextView)widget).getTypeface())) {
                    fontFamilyName = "mono";
                }
                font.put("name", (Object)fontFamilyName);
                font.put("size", (double)((TextView)widget).getTextSize());
                font.put("bold", ((TextView)widget).getTypeface().isBold());
                font.put("italic", ((TextView)widget).getTypeface().isItalic());
            }
            catch (Exception e) {
                LogInternal.logException(e);
            }
        } else {
            try {
                font.put("name", (Object)fontFamilyName);
                font.put("size", (double)((TextView)widget).getTextSize());
                font.put("bold", false);
                font.put("italic", false);
            }
            catch (Exception e) {
                LogInternal.logException(e);
            }
        }
        return font;
    }

    private void setVisitedCount(View widget, Target target) {
        if (this._currentActivity != null && this._formActivities.containsKey(this._currentActivity.hashCode())) {
            Control visitedControl = this._formActivities.get(this._currentActivity.hashCode()).get(((TextView)widget).getId());
            int visitedCount = visitedControl == null ? 1 : visitedControl.getTarget().getVisitedCount() + 1;
            target.setVisitedCount(visitedCount);
        }
    }

    private Object trimAndMaskValueForControl(HashMap<String, Object> current, String keyName, String value, String controlId) {
        String masked = "";
        if (value != null) {
            masked = ValueUtil.trimValue(value);
            masked = ValueUtil.compareListAndMask(controlId, masked);
        }
        return current.put(keyName, masked == null ? value : masked);
    }

    private String getTlType(Object object) {
        String scrollType = "scroll";
        String tlType = "";
        if (object instanceof ToggleButton) {
            tlType = "switch";
        } else if (this.checkClass(object, "Switch").booleanValue()) {
            tlType = "switch";
        } else if (object instanceof RadioButton) {
            tlType = "radioButton";
        } else if (object instanceof CheckBox) {
            tlType = "checkBox";
        } else if (object instanceof Button) {
            tlType = "button";
        } else if (object instanceof DatePicker) {
            tlType = "datePicker";
        } else if (object instanceof Scroller) {
            tlType = "scroll";
        } else if (object instanceof HorizontalScrollView) {
            tlType = "scroll";
        } else if (object instanceof ScrollView) {
            tlType = "scroll";
        } else if (object instanceof DialerFilter) {
            tlType = "dialerFilter";
        } else if (object instanceof RatingBar) {
            tlType = "ratingBar";
        } else if (object instanceof AbsSeekBar) {
            tlType = "slider";
        } else if (object instanceof ProgressBar) {
            ProgressBar progressBar = (ProgressBar)object;
            tlType = progressBar.getWidth() == progressBar.getHeight() ? "progressSpinner" : "progressBar";
        } else if (object instanceof RadioGroup) {
            tlType = "radioButton";
        } else if (object instanceof Gallery) {
            tlType = "gallery";
        } else if (object instanceof AbsSpinner) {
            tlType = "selectList";
        } else if (object instanceof TabHost) {
            tlType = "tabContainer";
        } else if (object instanceof TabWidget) {
            tlType = "tabBar";
        } else if (object instanceof EditText) {
            tlType = "textBox";
        } else if (object instanceof TextView) {
            tlType = "label";
        } else if (object instanceof TimePicker) {
            tlType = "timePicker";
        } else if (object instanceof Canvas) {
            tlType = "view";
        } else if (object instanceof ImageSwitcher) {
            tlType = "imageSwitcher";
        } else if (object instanceof Activity) {
            tlType = "page";
        } else if (object instanceof TabHost.TabSpec) {
            tlType = "tabBarItem";
        } else if (object instanceof WebView) {
            tlType = "webView";
        } else if (object instanceof ImageView) {
            tlType = "image";
        } else if (object instanceof AbsListView) {
            tlType = "grid";
        } else if (object instanceof FrameLayout || object instanceof LinearLayout || object instanceof ViewStub) {
            tlType = "canvas";
        } else if (object instanceof AlertDialog) {
            tlType = "alert";
        } else if (object instanceof KeyboardView) {
            tlType = "keyboard";
        } else if (object instanceof AnalogClock || object instanceof DigitalClock) {
            tlType = "clock";
        } else if (object instanceof View) {
            tlType = "canvas";
        }
        return tlType;
    }

    private Boolean checkClass(Object control, String compareTo) {
        if (control == null || control.getClass() == null || control.getClass().getSuperclass() == null) {
            return false;
        }
        if (compareTo.equalsIgnoreCase(control.getClass().getSimpleName())) {
            return true;
        }
        if (compareTo.equalsIgnoreCase(control.getClass().getSuperclass().getSimpleName())) {
            return true;
        }
        return false;
    }

    private String getTlEvent(String tlType, String type) {
        String tlEvent = "";
        if (tlType == null) {
            tlEvent = "";
        } else if ("button".equals(tlType) || "image".equals(tlType) || "checkBox".equals(tlType) || "gallery".equals(tlType) || "radioButton".equals(tlType) || "toggleButton".equals(tlType) || "switch".equals(tlType)) {
            tlEvent = "click";
        } else if ("calendar".equals(tlType) || "datePicker".equals(tlType)) {
            tlEvent = "dateChange";
        } else if ("numberPicker".equals(tlType) || "searchBox".equals(tlType) || "selectList".equals(tlType) || "slider".equals(tlType)) {
            tlEvent = "valueChange";
        } else if ("scroll".equals(tlType)) {
            tlEvent = "scrollChange";
        } else if ("tabContainer".equals(tlType)) {
            tlEvent = "tabChange";
        } else if ("textBox".equals(tlType)) {
            tlEvent = type != null && "unchanged".equals(tlType) ? "unchanged" : "textChange";
        } else if ("timePicker".equals(tlType)) {
            tlEvent = "timeChange";
        } else if ("keyboard".equals(tlType)) {
            tlEvent = type != null && "UIKeyboardDidHideNotification".equals(type) ? "kbHidden" : "kbDisplayed";
        }
        return tlEvent;
    }

    protected final Boolean logCustomEvent(String eventName, HashMap<String, String> data, int logLevel) {
        if (logLevel > TLFCache.getLogLevel()) {
            return false;
        }
        return TLFCache.addMessage(new CustomEvent(logLevel, eventName, data));
    }

    protected final Boolean logException(Throwable exception, String extraMessage) {
        return this.logException(exception, extraMessage, null);
    }

    protected final Boolean logException(Throwable exception, HashMap<String, String> data) {
        return this.logException(exception, null, data);
    }

    protected final Boolean logException(Throwable exception, String extraMessage, HashMap<String, String> data) {
        JSONException jsonException = new JSONException();
        jsonException.setDescription(LogInternal.getExceptionMessage(exception, extraMessage));
        jsonException.setName(exception.getClass().toString());
        jsonException.setStackTrace(LogInternal.getStackTrace(exception));
        if (data != null) {
            jsonException.setData(data);
        }
        Boolean hasBeenLogged = TLFCache.addMessage(jsonException);
        Boolean hasBeenFlushed = TLFCache.saveToCache(false);
        if (hasBeenLogged.booleanValue() && hasBeenFlushed.booleanValue()) {
            return true;
        }
        return false;
    }

    protected final Boolean logTLLibErrorException(Throwable exception, String extraMessage) {
        JSONException jsonException = new JSONException();
        jsonException.setDescription(LogInternal.getTLLibErrorExceptionMessage(exception, extraMessage));
        jsonException.setName(exception.getClass().toString());
        jsonException.setStackTrace(LogInternal.getStackTrace(exception));
        Boolean hasBeenLogged = TLFCache.addMessage(jsonException);
        Boolean hasBeenFlushed = TLFCache.saveToCache(false);
        if (hasBeenLogged.booleanValue() && hasBeenFlushed.booleanValue()) {
            return true;
        }
        return false;
    }

    protected final Boolean logScreenview(Activity activity, String logicalPageName, ScreenviewType screenviewType, String referrer) {
        Screenview screenview = new Screenview(logicalPageName, screenviewType, referrer);
        if (screenviewType != null && screenviewType.equals(ScreenviewType.LOAD)) {
            if (referrer == null && this.currentScreenview != null) {
                screenview.setReferringLogicalPageName(this.currentScreenview.getLogicalPageName());
            }
            this.loadDate = new Date();
            this._currentActivity = activity;
        }
        if (screenviewType != null && screenviewType.equals(ScreenviewType.UNLOAD) && activity != null) {
            this._formActivities.remove(activity.hashCode());
        }
        this.currentScreenview = screenview;
        return TLFCache.addMessage(screenview);
    }

    protected final Boolean logConnection(String url, HttpResponse httpResponse, long initTime, long loadTime, long responseTime) {
        Connection connection = new Connection();
        if (httpResponse != null) {
            HttpEntity entity = httpResponse.getEntity();
            if (entity != null) {
                connection.setResponseDataSize(entity.getContentLength());
            }
            if (httpResponse.getStatusLine() != null) {
                connection.setStatusCode(httpResponse.getStatusLine().getStatusCode());
            }
            if (url != null) {
                connection.setUrl(url);
            } else if (httpResponse.getLastHeader("Location") != null) {
                connection.setUrl(httpResponse.getLastHeader("Location").getValue());
            } else {
                connection.setUrl(null);
            }
        }
        connection.setInitTime(TLFCache.timestampFromSession() - initTime);
        connection.setLoadTime(TLFCache.timestampFromSession() - loadTime);
        connection.setResponseTime(responseTime);
        return TLFCache.addMessage(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Boolean registerFormField(View formField, Activity activity, int logLevel) {
        Control control = this.createControl(formField, "unchanged", logLevel, false);
        control.setOffset(0L);
        control.getTarget().setVisitedCount(0);
        if (!this._formActivities.containsKey(activity.hashCode())) {
            Logger logger = this;
            synchronized (logger) {
                this._formActivities.putIfAbsent(activity.hashCode(), new ConcurrentHashMap());
            }
        }
        this._formActivities.get(activity.hashCode()).put(formField.getId(), control);
        return this._formActivities.get(activity.hashCode()).containsKey(formField.getId());
    }

    public final Layout logLayout(Activity activity, String name, Boolean isAlert) {
        if (activity == null) {
            return null;
        }
        ViewGroup view = (ViewGroup)activity.getWindow().getDecorView();
        Layout layout = new Layout();
        if (name == null) {
            if (Tealeaf.getCurrentScreenView() != null && Tealeaf.getCurrentScreenView().getLogicalPageName() != null) {
                layout.setName(Tealeaf.getCurrentScreenView().getLogicalPageName());
            } else {
                layout.setName(this.getClassName(activity));
            }
        } else {
            layout.setName(name);
        }
        layout.setClassName(this.getClassName(activity));
        layout.setStyle(this.getStyle((View)view, true));
        Long startTime = System.currentTimeMillis();
        LogInternal.log("**Log Layout Start         *********************************");
        LogInternal.log("Parent id:" + this.getPropertyName((View)view) + "::" + view.toString());
        this.displayLayout(activity, (View)view, "Child", layout, isAlert);
        Long totalMS = System.currentTimeMillis() - startTime;
        LogInternal.log("**Log Layout End total time: " + totalMS + " ms. *******************");
        return layout;
    }

    private String getClassName(Object object) {
        if (object == null) {
            return "";
        }
        return object.getClass().getName().substring(object.getClass().getName().lastIndexOf(46) + 1);
    }

    private void displayLayout(Activity activity, View view, String title, Layout layout, Boolean isAlert) {
        if (!(view instanceof ViewGroup)) {
            return;
        }
        int children = ((ViewGroup)view).getChildCount();
        int i = 0;
        while (i < children) {
            View child = ((ViewGroup)view).getChildAt(i);
            LogInternal.log(String.valueOf(title) + " id:" + this.getPropertyName(child) + "::" + child.toString());
            if (child.getVisibility() == 0) {
                if (child instanceof AbsListView) {
                    BaseTarget table = this.createBaseTarget(child, isAlert);
                    if (table == null) {
                        LogInternal.log("View's x/y is a negative value for a control.");
                        return;
                    }
                    if (child instanceof ListView) {
                        if (((ListView)child).getDividerHeight() > 0) {
                            table.getStyle().setTableRowStyle(TableRowStyleType.LINE);
                            long dividerColor = ImageUtil.getColor(((ListView)child).getDivider());
                            if (dividerColor != 0L) {
                                table.getStyle().setTableRowStyleColor(dividerColor);
                            } else {
                                table.getStyle().setTableRowStyleColor(-12303292L);
                            }
                        } else {
                            table.getStyle().setTableRowStyle(TableRowStyleType.NONE);
                        }
                    } else {
                        table.getStyle().setTableRowStyle(TableRowStyleType.NONE);
                    }
                    this.createGridData(table, child, isAlert);
                    layout.getControls().add(table);
                } else if (!(child instanceof ViewGroup) || child instanceof LinearLayout || child instanceof FrameLayout || child instanceof RelativeLayout) {
                    if (child.getMeasuredHeight() != 0 || child.getMeasuredWidth() != 0) {
                        BaseTarget baseTarget = null;
                        if ((View)child.getParent() instanceof AbsSpinner) {
                            baseTarget = this.createBaseTarget((View)child.getParent(), isAlert);
                        }
                        BaseTarget baseTarget2 = baseTarget = baseTarget == null ? this.createBaseTarget(child, isAlert) : baseTarget;
                        if (baseTarget != null) {
                            LogInternal.log(baseTarget.getJSON().toString());
                            layout.getControls().add(baseTarget);
                        } else {
                            LogInternal.log("View's id was -1 or bgcolor null for LinearLayout/FrameLayout or x/y is a negative value for a control.");
                        }
                        if (baseTarget == null || baseTarget != null && !baseTarget.getStyle().getHidden().booleanValue()) {
                            this.displayLayout(activity, child, "Child=" + i, layout, isAlert);
                        }
                    }
                } else {
                    this.displayLayout(activity, child, "Child=" + i, layout, isAlert);
                }
            }
            ++i;
        }
    }

    private void createGridData(BaseTarget table, View child, Boolean isAlert) {
        HashMap<String, Object> current = new HashMap<String, Object>();
        JSONArray data = new JSONArray();
        this.displayGridLayout(child, data, isAlert);
        current.put("data", data);
        table.setCurrentState(current);
        LogInternal.log(table.getJSON().toString());
    }

    private Boolean isValid(BaseTarget baseTarget) {
        if (baseTarget == null) {
            return false;
        }
        if (baseTarget.getId().endsWith("h") && baseTarget.getStyle() == null && baseTarget.getImage() == null) {
            return false;
        }
        if (baseTarget.getId().endsWith("h") && baseTarget.getStyle().getBgColor() == -1L && baseTarget.getImage() == null && baseTarget.getTlType() != null && "canvas".equals(baseTarget.getTlType())) {
            return false;
        }
        return true;
    }

    private void displayGridLayout(View child, JSONArray data, Boolean isAlert) {
        int rowChildren = ((ViewGroup)child).getChildCount();
        int j = 0;
        while (j < rowChildren) {
            JSONArray rowData = new JSONArray();
            View row = ((ViewGroup)child).getChildAt(j);
            LogInternal.log("Row no." + j + " id:" + this.getPropertyName(row) + "::" + row.toString());
            if (row.getVisibility() == 0) {
                if (row instanceof ViewGroup) {
                    this.displayRowLayout(row, rowData, isAlert);
                } else if (!(row instanceof ViewGroup)) {
                    BaseTarget baseTarget = this.createBaseTarget(row, isAlert);
                    rowData.put((Object)baseTarget.getJSON());
                }
                BaseTarget rowTarget = this.createBaseTarget(row, true, false, isAlert);
                rowTarget.setTlType("gridRow");
                HashMap<String, Object> currentRow = new HashMap<String, Object>();
                currentRow.put("data", rowData);
                rowTarget.setCurrentState(currentRow);
                data.put((Object)rowTarget.getJSON());
            }
            ++j;
        }
    }

    private void displayRowLayout(View child, JSONArray rowData, Boolean isAlert) {
        int tableChildren = ((ViewGroup)child).getChildCount();
        int j = 0;
        while (j < tableChildren) {
            View row = ((ViewGroup)child).getChildAt(j);
            LogInternal.log("Item no." + j + " id:" + this.getPropertyName(row) + "::" + row.toString());
            if (row.getVisibility() == 0) {
                BaseTarget baseTarget;
                if (row instanceof ViewGroup) {
                    if (row instanceof RelativeLayout && this.isValid(baseTarget = this.createBaseTarget(row, isAlert)).booleanValue()) {
                        rowData.put((Object)baseTarget.getJSON());
                    }
                    this.displayRowLayout(row, rowData, isAlert);
                } else if (!(row instanceof ViewGroup) && this.isValid(baseTarget = this.createBaseTarget(row, isAlert)).booleanValue()) {
                    rowData.put((Object)baseTarget.getJSON());
                }
            }
            ++j;
        }
    }

    public final Layout logLayout(Activity activity, AlertDialog alertDialog, String name, Boolean isAlert) {
        if (alertDialog == null) {
            return null;
        }
        View view = alertDialog.getWindow().getDecorView();
        Layout layout = new Layout();
        if (name == null) {
            if (Tealeaf.getCurrentScreenView() != null && Tealeaf.getCurrentScreenView().getLogicalPageName() != null) {
                layout.setName(Tealeaf.getCurrentScreenView().getLogicalPageName());
            } else {
                layout.setName(alertDialog.getClass().getName().substring(alertDialog.getClass().getName().lastIndexOf(46) + 1));
            }
        } else {
            layout.setName(name);
        }
        layout.setClassName(this.getClassName(activity));
        layout.setStyle(this.getStyle(view, true));
        Layout alertLayout = new Layout();
        this.displayLayout(activity, view, "Child", alertLayout, isAlert);
        Layout backgroundLayout = this.logLayout(activity, name, isAlert);
        BaseTarget baseTarget = new BaseTarget();
        baseTarget.setId("alertDialog");
        baseTarget.setSubType(this.getControlSubType(alertDialog));
        baseTarget.setType(this.getControlType(alertDialog));
        baseTarget.setTlType(this.getTlType(alertDialog));
        baseTarget.setPosition(this.getPosition(view, true));
        baseTarget.setStyle(this.getStyle(view, false));
        HashMap<String, Object> current = new HashMap<String, Object>();
        current.put("background", this.getControlsJsonArray(backgroundLayout));
        current.put("alert", this.getControlsJsonArray(alertLayout));
        baseTarget.setCurrentState(current);
        LogInternal.log(baseTarget.getJSON().toString());
        layout.getControls().add(baseTarget);
        return layout;
    }

    private JSONArray getControlsJsonArray(Layout layout) {
        JSONArray controls = new JSONArray();
        if (layout == null || layout.getControls() == null) {
            return controls;
        }
        List<BaseTarget> list = layout.getControls();
        if (list == null || list.size() <= 0) {
            return controls;
        }
        int i = 0;
        while (i < list.size()) {
            controls.put((Object)list.get(i).getJSON());
            ++i;
        }
        return controls;
    }

    private BaseTarget createBaseTarget(View view, Boolean isAlert) {
        return this.createBaseTarget(view, false, false, isAlert);
    }

    private BaseTarget createBaseTarget(View view, Boolean isRow, Boolean isTopMostView, Boolean isAlert) {
        JSONObject compoundDrawables;
        if (view == null) {
            return null;
        }
        BaseTarget baseTarget = new BaseTarget();
        baseTarget.setId(this.getPropertyName(view));
        baseTarget.setStyle(this.getStyle(view, isTopMostView));
        if (!isRow.booleanValue() && "-1".equals(baseTarget.getId()) && baseTarget.getStyle() != null && baseTarget.getStyle().getBgColor() == -1L && (view instanceof LinearLayout || view instanceof FrameLayout)) {
            return null;
        }
        Position reSetPositionForImageView = this.getPosition(view, isAlert);
        if (view instanceof ImageView && !"com.android.internal.widget.ActionBarView$HomeView".equals(view.getParent().getClass().getName())) {
            Drawable drawable = ((ImageView)view).getDrawable();
            if (drawable != null) {
                reSetPositionForImageView.setHeight(drawable.getIntrinsicHeight());
                reSetPositionForImageView.setWidth(drawable.getIntrinsicWidth());
            }
            if (view.getLayoutParams().height == -1) {
                int y = view.getBottom() / 2;
                reSetPositionForImageView.setY(y);
            }
        }
        baseTarget.setPosition(reSetPositionForImageView);
        if (baseTarget.getPosition().getX() < 0 || baseTarget.getPosition().getY() < 0) {
            return null;
        }
        baseTarget.setSubType(this.getControlSubType(view));
        baseTarget.setType(this.getControlType(view));
        baseTarget.setTlType(this.getTlType(view));
        this.getState(baseTarget, view, "layout", true);
        baseTarget.setImage(this.getImage(view, isAlert));
        this.testButton(view, baseTarget);
        if (view instanceof Button && (compoundDrawables = this.getButtonCompoundDrawables((Button)view, isAlert)) != null) {
            baseTarget.getCurrentState().put("compoundDrawables", compoundDrawables);
            baseTarget.setTlType("compoundButton");
        }
        return baseTarget;
    }

    private Boolean testButton(View view, BaseTarget baseTarget) {
        if (!(view instanceof Button)) {
            return false;
        }
        if (baseTarget.getImage() != null && (baseTarget.getImage().getBase64Image() != null || baseTarget.getImage().getValue() != null)) {
            baseTarget.setTlType("imageButton");
            return true;
        }
        return false;
    }

    private Style getStyle(View view, Boolean isTopMostView) {
        Style style = new Style();
        try {
            long bgColor;
            PaintDrawable background;
            if (view.getBackground() instanceof PaintDrawable) {
                background = (PaintDrawable)view.getBackground();
                style.setBgColor(background.getPaint().getColor());
                style.setTextBGColor(background.getPaint().getColor());
                style.setBgAlphaColor(background.getPaint().getAlpha());
                style.setTextBGAlphaColor(background.getPaint().getAlpha());
            } else if (view.getBackground() instanceof ColorDrawable) {
                background = (ColorDrawable)view.getBackground();
                style.setBgAlphaColor(background.getAlpha());
                style.setTextBGAlphaColor(background.getAlpha());
                long bgColor2 = ImageUtil.getColor((Drawable)background);
                if (bgColor2 != 0L) {
                    style.setBgColor(bgColor2);
                }
            } else if (view.getBackground() instanceof NinePatchDrawable) {
                long bgColor3;
                background = (NinePatchDrawable)view.getBackground();
                if (Build.VERSION.SDK_INT > 18) {
                    style.setBgAlphaColor(background.getAlpha());
                    style.setTextBGAlphaColor(background.getAlpha());
                }
                if ((bgColor3 = ImageUtil.getColor((Drawable)background)) != 0L) {
                    style.setBgColor(bgColor3);
                }
            } else if ((view.getBackground() instanceof StateListDrawable && view instanceof Button || view.getBackground() instanceof StateListDrawable && view instanceof ViewGroup) && (bgColor = ImageUtil.getColor((Drawable)(background = (StateListDrawable)view.getBackground()))) != 0L) {
                style.setBgColor(bgColor);
            }
            if (isTopMostView.booleanValue()) {
                try {
                    TypedArray array = Tealeaf.getApplication().getApplicationContext().getTheme().obtainStyledAttributes(new int[]{0x1010031, 16842806});
                    if (style.getBgColor() == -1L) {
                        style.setBgColor(array.getColor(0, 0xFF00FF));
                    }
                    if (style.getTextColor() == -1L) {
                        style.setTextColor(array.getColor(1, 0xFF00FF));
                    }
                    array.recycle();
                }
                catch (Exception e) {
                    LogInternal.logException(e);
                }
            }
            if (view instanceof TextView) {
                TextView textView = (TextView)view;
                style.setTextAlphaColor(Color.alpha((int)textView.getCurrentTextColor()));
                style.setTextColor(textView.getCurrentTextColor());
                switch (textView.getGravity()) {
                    case 3: {
                        style.setTextAlignment("left");
                        break;
                    }
                    case 17: {
                        style.setTextAlignment("center");
                        break;
                    }
                    case 5: {
                        style.setTextAlignment("right");
                        break;
                    }
                    default: {
                        style.setTextAlignment("left");
                    }
                }
            }
            if (view.getVisibility() == 0) {
                style.setHidden(false);
            } else {
                style.setHidden(true);
            }
            style.setPaddingBottom(view.getPaddingBottom());
            style.setPaddingLeft(view.getPaddingLeft());
            style.setPaddingRight(view.getPaddingRight());
            style.setPaddingTop(view.getPaddingTop());
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
        return style;
    }

    private Image getImage(View view, Boolean isAlert) {
        Image image = null;
        if (view == null) {
            return image;
        }
        if (view instanceof ImageView || view instanceof FrameLayout || view instanceof Button || view instanceof RelativeLayout || view instanceof LinearLayout) {
            Drawable drawable;
            image = new Image();
            byte[] imageBtyeArray = null;
            if (view instanceof ImageView) {
                drawable = ((ImageView)view).getDrawable();
                if (drawable == null && view instanceof ImageView) {
                    drawable = ((ImageView)view).getBackground();
                }
                if (drawable == null && view instanceof ImageButton) {
                    drawable = ((ImageButton)view).getBackground();
                }
                imageBtyeArray = ImageUtil.getBitmapByteArray(drawable, null);
            } else if (view instanceof FrameLayout) {
                imageBtyeArray = ImageUtil.getBitmapByteArray(view.getBackground(), view);
            } else if ((view instanceof Button || view instanceof RelativeLayout || view instanceof LinearLayout) && (drawable = view.getBackground()) != null) {
                imageBtyeArray = ImageUtil.getBitmapByteArray(drawable.getCurrent(), view);
            }
            this.setImageData(image, imageBtyeArray, view);
            Position reSetPositionForImageView = this.getPosition(view, isAlert);
            if (view instanceof ImageView && !"com.android.internal.widget.ActionBarView$HomeView".equals(view.getParent().getClass().getName())) {
                Drawable drawable2 = ((ImageView)view).getDrawable();
                if (drawable2 != null) {
                    reSetPositionForImageView.setHeight(drawable2.getIntrinsicHeight());
                    reSetPositionForImageView.setWidth(drawable2.getIntrinsicWidth());
                }
                if (view.getLayoutParams() != null && view.getLayoutParams().height == -1) {
                    int y = view.getBottom() / 2;
                    reSetPositionForImageView.setY(y);
                }
            }
            image.setPosition(reSetPositionForImageView);
        }
        return image;
    }

    private void setImageData(Image image, byte[] imageBtyeArray, View view) {
        if (imageBtyeArray != null) {
            if (ConfigurationUtil.getBoolean("GetImageDataOnScreenLayout").booleanValue()) {
                image.setBase64Image(imageBtyeArray);
            } else {
                image.setValue(ImageUtil.getMD5Hash(imageBtyeArray));
                image.setType(ImageType.MD5_CHECKSUM.toString());
            }
            image.setMimeExtension(ImageUtil.getImageType());
        }
    }

    private JSONObject getButtonCompoundDrawables(Button button, Boolean isAlert) {
        JSONObject compoundDrawables = null;
        Drawable[] drawables = button.getCompoundDrawables();
        if (drawables != null) {
            try {
                int i = 0;
                while (i < drawables.length) {
                    if (drawables[i] != null) {
                        Image image = new Image();
                        byte[] imageBtyeArray = ImageUtil.getBitmapByteArray(drawables[i], (View)button);
                        this.setImageData(image, imageBtyeArray, (View)button);
                        image.setPosition(this.getPosition((View)button, drawables[i], isAlert));
                        if (compoundDrawables == null) {
                            compoundDrawables = new JSONObject();
                        }
                        compoundDrawables.accumulate(this.getCompoundDrawableKey(i), (Object)image.getJSON());
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                LogInternal.logException(e);
            }
        }
        return compoundDrawables;
    }

    private String getCompoundDrawableKey(int keyValue) {
        String key = null;
        switch (keyValue) {
            case 0: {
                key = "left";
                break;
            }
            case 1: {
                key = "top";
                break;
            }
            case 2: {
                key = "right";
                break;
            }
            case 3: {
                key = "bottom";
                break;
            }
        }
        return key;
    }
}

