/*
 * Decompiled with CFR 0.152.
 */
package com.tl.uic;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.StatFs;
import android.telephony.TelephonyManager;
import com.tl.uic.TLFCache;
import com.tl.uic.Tealeaf;
import com.tl.uic.model.AndroidArray;
import com.tl.uic.model.AndroidState;
import com.tl.uic.model.ClientEnvironment;
import com.tl.uic.model.ClientState;
import com.tl.uic.model.KeyboardStateType;
import com.tl.uic.model.KeyboardType;
import com.tl.uic.model.MobileEnvironment;
import com.tl.uic.model.MobileState;
import com.tl.uic.model.OrientationType;
import com.tl.uic.model.StorageType;
import com.tl.uic.util.BatteryReceiver;
import com.tl.uic.util.ClientStateTask;
import com.tl.uic.util.ConfigurationUtil;
import com.tl.uic.util.ConnectionReceiver;
import com.tl.uic.util.LogInternal;
import com.tl.uic.util.ScreenReceiver;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;

@SuppressLint(value={"NewApi"})
public class EnvironmentalData {
    private Application _application;
    private BatteryReceiver batteryReceiver;
    private String applicationName;
    private String applicationVersion;
    private String applicationPackageName;
    private ConnectionReceiver connectionReceiver;
    private ClientState prevClientState;
    private ScreenReceiver screenReceiver;
    private TimerTask clientStateTimerTask;
    private static ClientStateTask _clientStateTask;
    private static int lastWidth;
    private static int lastHeight;
    private static final int IP_BIT_8 = 8;
    private static final int IP_BIT_16 = 16;
    private static final int IP_BIT_24 = 24;
    private static final int SET_BITS_TO_CHAR = 255;
    private static final String TEALEAF_DEVICE_ID = "TEALEAF_DEVICE_ID";

    static {
        lastWidth = 0;
        lastHeight = 0;
    }

    public EnvironmentalData(Application application) {
        this._application = application;
        this.init();
    }

    private void init() {
        this.enableBatteryManager();
        this.enableConnectionListener();
        this.getApplicationData();
        this.enableClientStateTask();
        this.enableScreenReceiver();
    }

    public final Boolean onPause() {
        if (TLFCache.hasBeenPostedInBackground().booleanValue()) {
            this.disableBatteryManager();
            this.disableClientStateTask();
            this.disableConnectionListener();
            this.disableScreenReceiver();
        }
        return true;
    }

    public final Boolean onResume() {
        this.enableBatteryManager();
        this.enableClientStateTask();
        this.enableConnectionListener();
        this.enableScreenReceiver();
        return true;
    }

    public final Boolean terminate() {
        this.disableBatteryManager();
        this.disableConnectionListener();
        this.disableClientStateTask();
        this.disableScreenReceiver();
        this._application = null;
        this.applicationName = null;
        this.applicationVersion = null;
        this.applicationPackageName = null;
        return true;
    }

    public final String getApplicationName() {
        if (this.applicationName == null) {
            return "";
        }
        return this.applicationName;
    }

    public final String getApplicationVersion() {
        return this.applicationVersion;
    }

    public final String getApplicationPackageName() {
        return this.applicationPackageName;
    }

    public final BatteryReceiver getBatteryReceiver() {
        return this.batteryReceiver;
    }

    public final ConnectionReceiver getConnectionReceiver() {
        return this.connectionReceiver;
    }

    public final TimerTask getClientStateTimerTask() {
        return this.clientStateTimerTask;
    }

    public final ScreenReceiver getScreenReceiver() {
        if (this.screenReceiver == null) {
            this.enableScreenReceiver();
        }
        return this.screenReceiver;
    }

    public final String getHttpXTealeafProperty() {
        String[] appVersions = this.applicationVersion == null ? null : this.applicationVersion.split("\\.");
        StringBuilder applicationVersionMajorMinor = new StringBuilder();
        applicationVersionMajorMinor.append(appVersions == null ? "" : appVersions[0]);
        applicationVersionMajorMinor.append(appVersions == null || appVersions.length < 2 ? "" : "." + appVersions[1]);
        StringBuilder value = new StringBuilder(99);
        value.append("TLT_BROWSER=");
        value.append(this.getApplicationName());
        value.append("Native;TLT_BROWSER_VERSION=");
        value.append(applicationVersionMajorMinor.toString());
        value.append(";TLT_BRAND=");
        value.append(Build.BRAND);
        value.append(";TLT_MODEL=");
        value.append(this.getModel());
        if (this.screenReceiver != null) {
            value.append(";TLT_SCREEN_HEIGHT=");
            value.append(this.screenReceiver.getHeight());
            value.append(";TLT_SCREEN_WIDTH=");
            value.append(this.screenReceiver.getWidth());
        } else {
            if (lastHeight > 0) {
                value.append(";TLT_SCREEN_HEIGHT=");
                value.append(lastHeight);
            }
            if (lastWidth > 0) {
                value.append(";TLT_SCREEN_WIDTH=");
                value.append(lastWidth);
            }
        }
        return value.toString();
    }

    public final ClientEnvironment createClientEnvironment() {
        ClientEnvironment clientEnvironment = new ClientEnvironment();
        clientEnvironment.setOsVersion(Build.VERSION.RELEASE);
        if (this.screenReceiver == null) {
            this.hasClientStateChanged();
        }
        clientEnvironment.setHeight(this.screenReceiver.getHeight());
        lastHeight = this.screenReceiver.getHeight();
        clientEnvironment.setWidth(this.screenReceiver.getWidth());
        lastWidth = this.screenReceiver.getWidth();
        clientEnvironment.setDeviceHeight(this.screenReceiver.getDeviceHeight());
        clientEnvironment.setDeviceWidth(this.screenReceiver.getDeviceWidth());
        clientEnvironment.setPixelDensity(this.screenReceiver.getPixelDensity());
        MobileEnvironment mobileEnvironment = new MobileEnvironment();
        mobileEnvironment.setTotalStorage(this.getStorage(StorageType.PHONE_TOTAL));
        mobileEnvironment.setTotalMemory(this.getAvailableMemory());
        mobileEnvironment.setLocale(Locale.getDefault().getDisplayName());
        mobileEnvironment.setLanguage(Locale.getDefault().getDisplayLanguage());
        mobileEnvironment.setManufacturer(this.getManufacturer());
        mobileEnvironment.setDeviceModel(this.getModel());
        mobileEnvironment.setAppName(this.getApplicationName());
        mobileEnvironment.setAppVersion(this.getApplicationVersion());
        mobileEnvironment.setUserID(this.getDeviceId());
        mobileEnvironment.setOrientationType(this.getOrientationType());
        AndroidArray androidArray = new AndroidArray();
        androidArray.setBrand(Build.BRAND);
        androidArray.setFingerPrint(Build.FINGERPRINT);
        androidArray.setKeyboardType(this.getKeyboardType());
        mobileEnvironment.setAndroidArray(androidArray);
        clientEnvironment.setMobileEnvironment(mobileEnvironment);
        return clientEnvironment;
    }

    public final Boolean hasClientStateChanged() {
        Boolean hasChanged = false;
        if (this.batteryReceiver == null || this.connectionReceiver == null || this.screenReceiver == null) {
            this.onResume();
        }
        ClientState currentClientState = this.createClientState();
        if (this.prevClientState == null || !this.prevClientState.equals(currentClientState)) {
            this.prevClientState = currentClientState;
            TLFCache.addMessage(this.prevClientState);
            hasChanged = true;
        }
        return hasChanged;
    }

    public final ClientState createClientState() {
        ClientState clientState = new ClientState();
        MobileState mobileState = new MobileState();
        mobileState.setFreeStorage(this.getStorage(StorageType.PHONE_FREE));
        mobileState.setFreeMemory(this.getAvailableMemory());
        if (this.batteryReceiver != null) {
            mobileState.setBattery(this.batteryReceiver.getValue());
        }
        mobileState.setIp(this.getIpAddress());
        mobileState.setCarrier(this.getCarrier());
        if (this.screenReceiver != null) {
            mobileState.setOrientation(this.screenReceiver.getRotation());
        }
        if (this.connectionReceiver != null) {
            mobileState.setConnectionType(this.connectionReceiver.getConnectionType());
            mobileState.setNetworkReachability(this.connectionReceiver.getNetworkReachability());
        }
        AndroidState androidState = new AndroidState();
        androidState.setKeyboardStateType(this.getKeyboardStateType());
        mobileState.setAndroidState(androidState);
        clientState.setMobileState(mobileState);
        return clientState;
    }

    public final long getAvailableMemory() {
        long availableMemoryBytes = 0L;
        try {
            ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
            ActivityManager activityManager = (ActivityManager)this._application.getApplicationContext().getSystemService("activity");
            if (activityManager != null) {
                activityManager.getMemoryInfo(memoryInfo);
            }
            availableMemoryBytes = memoryInfo.availMem;
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
        return availableMemoryBytes;
    }

    public final long getStorage(StorageType storageType) {
        long memoryInBytes = 0L;
        try {
            File path = null;
            path = storageType == StorageType.PHONE_FREE || storageType == StorageType.PHONE_USED || storageType == StorageType.PHONE_TOTAL ? Environment.getDataDirectory() : Environment.getExternalStorageDirectory();
            StatFs statFs = new StatFs(path.getPath());
            switch (storageType) {
                case PHONE_FREE: 
                case SD_CARD_FREE: {
                    if (Build.VERSION.SDK_INT > 17) {
                        memoryInBytes = statFs.getAvailableBlocksLong() * statFs.getBlockSizeLong();
                        break;
                    }
                    memoryInBytes = (long)statFs.getAvailableBlocks() * (long)statFs.getBlockSize();
                    break;
                }
                case PHONE_USED: 
                case SD_CARD_USED: {
                    if (Build.VERSION.SDK_INT > 17) {
                        memoryInBytes = statFs.getAvailableBlocksLong() * statFs.getBlockSizeLong();
                        break;
                    }
                    memoryInBytes = (long)statFs.getAvailableBlocks() * (long)statFs.getBlockSize();
                    break;
                }
                case PHONE_TOTAL: 
                case SD_CARD_TOTAL: {
                    if (Build.VERSION.SDK_INT > 17) {
                        memoryInBytes = statFs.getBlockCountLong() - statFs.getBlockSizeLong();
                        break;
                    }
                    memoryInBytes = (long)statFs.getBlockCount() - (long)statFs.getBlockSize();
                    break;
                }
            }
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
        return memoryInBytes;
    }

    public final void getApplicationData() {
        try {
            PackageManager packageManager = this._application.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(this._application.getPackageName(), 0);
            this.applicationVersion = packageInfo.versionName;
            this.applicationPackageName = packageInfo.packageName;
            this.applicationName = packageInfo.applicationInfo.name == null ? (String)packageManager.getApplicationLabel(packageManager.getApplicationInfo(this._application.getPackageName(), 0)) : packageInfo.applicationInfo.name;
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
    }

    public final String getCarrier() {
        String carrierName = null;
        try {
            TelephonyManager manager = (TelephonyManager)this._application.getApplicationContext().getSystemService("phone");
            carrierName = manager.getNetworkOperatorName();
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
        return carrierName;
    }

    public final String getIpAddress() {
        String ip = "";
        try {
            WifiManager wifiManager = (WifiManager)this._application.getApplicationContext().getSystemService("wifi");
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            int ipAddress = wifiInfo.getIpAddress();
            ip = String.format(Locale.US, "%d.%d.%d.%d", ipAddress & 0xFF, ipAddress >> 8 & 0xFF, ipAddress >> 16 & 0xFF, ipAddress >> 24 & 0xFF);
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
        return ip;
    }

    public final String getManufacturer() {
        String myManufacturer = "";
        try {
            if ("1.5".equals(Build.VERSION.RELEASE)) {
                return myManufacturer;
            }
            Field manufacturer = Build.class.getDeclaredField("MANUFACTURER");
            manufacturer.setAccessible(true);
            myManufacturer = (String)manufacturer.get(Build.class);
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
        return myManufacturer;
    }

    public final String getModel() {
        String myModel = "";
        try {
            myModel = Build.MODEL;
            if ("sdk".equals(myModel) || "Full Android on x86 Emulator".equals(myModel) || "Android SDK build for x86".equals(myModel)) {
                myModel = "Android Simulator";
            }
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
        return myModel;
    }

    private Boolean isNotApplicationResourcesNull() {
        if (this._application != null && this._application.getResources() != null) {
            return true;
        }
        return false;
    }

    public final KeyboardType getKeyboardType() {
        KeyboardType keyboardType = KeyboardType.UNDEFINED;
        try {
            if (this.isNotApplicationResourcesNull().booleanValue()) {
                Configuration configuration = this._application.getResources().getConfiguration();
                switch (configuration.keyboard) {
                    case 1: {
                        keyboardType = KeyboardType.NO_KEYS;
                        break;
                    }
                    case 2: {
                        keyboardType = KeyboardType.QWERTY;
                        break;
                    }
                    case 3: {
                        keyboardType = KeyboardType.TWELVE_KEYS;
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
        return keyboardType;
    }

    public final KeyboardStateType getKeyboardStateType() {
        KeyboardStateType keyboardStateType = KeyboardStateType.UNDEFINED;
        try {
            if (this.isNotApplicationResourcesNull().booleanValue()) {
                Configuration configuration = this._application.getResources().getConfiguration();
                switch (configuration.keyboardHidden) {
                    case 1: {
                        keyboardStateType = KeyboardStateType.HIDDEN_FALSE;
                        break;
                    }
                    case 2: {
                        keyboardStateType = KeyboardStateType.HIDDEN_TRUE;
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
        return keyboardStateType;
    }

    public final OrientationType getOrientationType() {
        OrientationType orientationType;
        block7: {
            orientationType = OrientationType.UNDEFINED;
            try {
                if (!this.isNotApplicationResourcesNull().booleanValue()) break block7;
                Configuration configuration = this._application.getResources().getConfiguration();
                switch (configuration.orientation) {
                    case 2: {
                        orientationType = OrientationType.LANDSCAPE;
                        break;
                    }
                    case 1: {
                        orientationType = OrientationType.PORTRAIT;
                        break;
                    }
                    default: {
                        if (Build.VERSION.SDK_INT < 15 && configuration.orientation == 3) {
                            orientationType = OrientationType.SQUARE;
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                LogInternal.logException(e);
            }
        }
        return orientationType;
    }

    private Boolean isNotApplicationContextNull() {
        if (this._application != null && this._application.getApplicationContext() != null) {
            return true;
        }
        return false;
    }

    public final void enableBatteryManager() {
        if (this.batteryReceiver == null && this.isNotApplicationContextNull().booleanValue()) {
            this.batteryReceiver = new BatteryReceiver();
            IntentFilter filter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            this._application.getApplicationContext().registerReceiver((BroadcastReceiver)this.batteryReceiver, filter);
        }
    }

    public final void disableBatteryManager() {
        if (this.batteryReceiver != null && this.isNotApplicationContextNull().booleanValue()) {
            this._application.getApplicationContext().unregisterReceiver((BroadcastReceiver)this.batteryReceiver);
            this.batteryReceiver = null;
        }
    }

    public final void enableConnectionListener() {
        if (this.connectionReceiver == null && this.isNotApplicationContextNull().booleanValue()) {
            this.connectionReceiver = new ConnectionReceiver();
            IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            this._application.getApplicationContext().registerReceiver((BroadcastReceiver)this.connectionReceiver, filter);
        }
    }

    public final void disableConnectionListener() {
        if (this.connectionReceiver != null && this.isNotApplicationContextNull().booleanValue()) {
            this._application.getApplicationContext().unregisterReceiver((BroadcastReceiver)this.connectionReceiver);
            this.connectionReceiver = null;
        }
    }

    public final void enableClientStateTask() {
        if (this.clientStateTimerTask == null) {
            this.setupClientStateTask();
        }
    }

    public final void disableClientStateTask() {
        if (this.clientStateTimerTask != null) {
            this.clientStateTimerTask.cancel();
            this.clientStateTimerTask = null;
        }
    }

    public final void setupClientStateTask() {
        final Handler handler = new Handler(Looper.getMainLooper());
        Timer timer = new Timer();
        this.clientStateTimerTask = new TimerTask(){

            public void run() {
                handler.post(new Runnable(){

                    public void run() {
                        try {
                            if (_clientStateTask == null) {
                                _clientStateTask = new ClientStateTask();
                                _clientStateTask.execute(new Void[0]);
                            }
                        }
                        catch (Exception e) {
                            LogInternal.logException(e);
                        }
                    }
                });
            }
        };
        timer.schedule(this.clientStateTimerTask, 0L, ConfigurationUtil.getLongMS("TimeIntervalBetweenSnapshots"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Boolean closeClientStateTask() {
        if (_clientStateTask != null) {
            ClientStateTask clientStateTask = _clientStateTask;
            synchronized (clientStateTask) {
                _clientStateTask = null;
            }
        }
        if (TLFCache.hasBeenPostedInBackground().booleanValue()) {
            this.onPause();
        }
        return true;
    }

    public final void enableScreenReceiver() {
        if (this.screenReceiver == null && this.isNotApplicationContextNull().booleanValue()) {
            this.screenReceiver = new ScreenReceiver();
            IntentFilter filter = new IntentFilter("android.intent.action.CONFIGURATION_CHANGED");
            this._application.getApplicationContext().registerReceiver((BroadcastReceiver)this.screenReceiver, filter);
        }
    }

    public final void disableScreenReceiver() {
        if (this.screenReceiver != null && this.isNotApplicationContextNull().booleanValue()) {
            this._application.getApplicationContext().unregisterReceiver((BroadcastReceiver)this.screenReceiver);
            this.screenReceiver = null;
        }
    }

    public final String getDeviceId() {
        String deviceId = null;
        try {
            SharedPreferences sharedPreferences;
            if (deviceId == null && (deviceId = (sharedPreferences = Tealeaf.getApplication().getSharedPreferences(TEALEAF_DEVICE_ID, 0)).getString(TEALEAF_DEVICE_ID, null)) == null) {
                deviceId = UUID.randomUUID().toString();
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.putString(TEALEAF_DEVICE_ID, deviceId);
                editor.commit();
            }
        }
        catch (Exception e) {
            LogInternal.logException(e);
        }
        return deviceId;
    }
}

