/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.wlclient.ui;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.Menu;
import com.worklight.common.Logger;
import com.worklight.common.security.PRNGFixes;
import com.worklight.wlclient.api.WLClient;
import com.worklight.wlclient.api.challengehandler.WLChallengeHandler;

public class UIActivity
extends Activity {
    private static Logger logger = Logger.getInstance("UIActivity");

    public void onCreate(Bundle savedInstanceState) {
        Logger.setContext((Context)this);
        super.onCreate(savedInstanceState);
        try {
            PRNGFixes.apply();
        }
        catch (Exception e) {
            logger.error("Failed to apply Android PRNG secure random fixes.");
        }
        this.handleDialogue(this.getIntent().getStringExtra("action"));
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        return true;
    }

    private void handleDialogue(String action) {
        Intent intent = this.getIntent();
        if (action.equalsIgnoreCase("wl_remoteDisableRealm")) {
            this.handleRemoteDisableDialogue(intent);
        } else if (action.equalsIgnoreCase("notify")) {
            this.handleNotifyDialogue(intent);
        } else if (action.equalsIgnoreCase("exit")) {
            this.handleExitDialogue(intent);
        }
    }

    private void handleExitDialogue(Intent intent) {
        String title = intent.getStringExtra("dialogue_title");
        String message = intent.getStringExtra("dialogue_message");
        String positiveButtonText = intent.getStringExtra("positive_button_text");
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                UIActivity.this.finish();
            }
        };
        this.createAndShowDialogue(title, message, positiveButtonText, listener, null, null);
    }

    private void handleNotifyDialogue(Intent intent) {
        String title = intent.getStringExtra("dialogue_title");
        String message = intent.getStringExtra("dialogue_message");
        final String messageId = intent.getStringExtra("dialogue_message_id");
        String positiveButtonText = intent.getStringExtra("positive_button_text");
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                WLChallengeHandler ch = WLClient.getInstance().getWLChallengeHandler("wl_remoteDisableRealm");
                if (ch != null) {
                    ch.submitChallengeAnswer(messageId);
                }
                UIActivity.this.finish();
            }
        };
        this.createAndShowDialogue(title, message, positiveButtonText, listener, null, null);
    }

    private void handleRemoteDisableDialogue(Intent intent) {
        String title = intent.getStringExtra("dialogue_title");
        String message = intent.getStringExtra("dialogue_message");
        String positiveButtonText = intent.getStringExtra("positive_button_text");
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                UIActivity.this.finish();
            }
        };
        final String downloadLink = intent.getStringExtra("download_link");
        String downloadButtonText = null;
        DialogInterface.OnClickListener downlaodListener = null;
        if (downloadLink != null) {
            downloadButtonText = intent.getStringExtra("neutral_button_text");
            downlaodListener = new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    UIActivity.this.openURL(downloadLink);
                    UIActivity.this.finish();
                }
            };
        }
        this.createAndShowDialogue(title, message, positiveButtonText, listener, downloadButtonText, downlaodListener);
    }

    private void openURL(String url) {
        Uri uri = Uri.parse((String)url);
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        this.startActivity(intent);
    }

    private void exitApplication() {
        this.finish();
        this.moveTaskToBack(true);
    }

    private void createAndShowDialogue(String title, String message, String positiveButtonText, DialogInterface.OnClickListener positiveButtonListener, String neutralButtonText, DialogInterface.OnClickListener neutralButtonListener) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle((CharSequence)title);
        builder.setMessage((CharSequence)message);
        if (positiveButtonText != null && positiveButtonListener != null) {
            builder.setPositiveButton((CharSequence)positiveButtonText, positiveButtonListener);
        }
        if (neutralButtonText != null && neutralButtonListener != null) {
            builder.setNeutralButton((CharSequence)neutralButtonText, neutralButtonListener);
        }
        AlertDialog dlg = builder.create();
        dlg.setCanceledOnTouchOutside(false);
        dlg.setCancelable(false);
        dlg.show();
    }
}

