/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.wlclient.push;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gcm.GCMBaseIntentService;
import com.worklight.common.Logger;
import com.worklight.common.WLConfig;
import com.worklight.nativeandroid.common.WLUtils;
import java.util.LinkedList;
import org.json.JSONException;
import org.json.JSONObject;

public class GCMIntentService
extends GCMBaseIntentService {
    private static Logger logger = Logger.getInstance("GCMIntentService");
    private static int RES_PUSH_NOTIFICATION_ICON = -1;
    private static int RES_PUSH_NOTIFICATION_TITLE = -1;
    public static final String GCM_NOTIFICATION = ".NOTIFICATION";
    public static final String GCM_REGISTERED = ".C2DM_REGISTERED";
    public static final String GCM_UNREGISTERED = ".C2DM_UNREGISTERED";
    public static final String GCM_MESSAGE = ".C2DM_MESSAGE";
    public static final String GCM_ERROR = ".C2DM_ERROR";
    public static final String GCM_EXTRA_ALERT = "alert";
    public static final String GCM_EXTRA_BADGE = "badge";
    public static final String GCM_EXTRA_SOUND = "sound";
    public static final String GCM_EXTRA_PAYLOAD = "payload";
    public static final String GCM_EXTRA_MESSAGE = "message";
    public static final String GCM_EXTRA_REGISTRATION_ID = "registrationId";
    public static final String GCM_EXTRA_ERROR_ID = "errorId";
    public static LinkedList<Intent> intentsQueue = new LinkedList();
    private static boolean isAppForeground = false;
    private BroadcastReceiver resultReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (this.getResultCode() == 1 || !GCMIntentService.isAppForeground()) {
                GCMIntentService.this.onUnhandled(context, intent);
            }
        }
    };

    public GCMIntentService() {
        this.setBroadcastReceiver(this.resultReceiver);
    }

    public GCMIntentService(String senderId) {
        super(new String[]{senderId});
    }

    public static boolean isAppForeground() {
        return isAppForeground;
    }

    public static void setAppForeground(boolean isAppForeground) {
        GCMIntentService.isAppForeground = isAppForeground;
    }

    protected void setResources() {
        try {
            this.setNotificationIcon(WLUtils.getResourceId(this.getApplicationContext(), "drawable", "push"));
        }
        catch (Exception e) {
            logger.error("Failed to find the icon resource. Add the icon file under the /res/drawable folder.");
        }
    }

    protected String getNotificationTitle(Context context) {
        int notificationTitle = -1;
        try {
            notificationTitle = WLUtils.getResourceId(this.getApplicationContext(), "string", "push_notification_title");
            return context.getString(notificationTitle);
        }
        catch (Exception e) {
            if (notificationTitle == -1) {
                ApplicationInfo appInfo = null;
                PackageManager packManager = context.getPackageManager();
                try {
                    appInfo = packManager.getApplicationInfo(context.getPackageName(), 0);
                }
                catch (Exception e2) {
                    logger.warn("Notification will not have a title because application name is not available. " + e2.getMessage());
                }
                if (appInfo != null) {
                    return (String)packManager.getApplicationLabel(appInfo);
                }
            }
            return "";
        }
    }

    protected String[] getSenderIds(Context context) {
        String senderId = WLConfig.getInstance().getGCMSender();
        if (senderId == null) {
            return null;
        }
        return new String[]{senderId};
    }

    protected void addToIntentQueue(Intent intent) {
        if (!GCMIntentService.isAppForeground()) {
            logger.debug("WLGCMIntentService: App is not on foreground. Queue the intent for later re-sending when app is back on foreground.");
            intentsQueue.add(intent);
        }
    }

    public void onRegistered(Context context, String registrationId) {
        this.setResources();
        logger.debug("WLGCMIntentService: Registered at the GCM server with registration id " + registrationId);
        Intent intent = new Intent(WLUtils.getFullAppName(context) + GCM_REGISTERED);
        intent.putExtra(GCM_EXTRA_REGISTRATION_ID, registrationId);
        context.sendBroadcast(intent);
    }

    protected void onUnregistered(Context context, String registrationId) {
        logger.debug("WLGCMIntentService: Unregistered at the GCM server");
        context.sendBroadcast(new Intent(WLUtils.getFullAppName(context) + GCM_UNREGISTERED));
        intentsQueue.clear();
    }

    protected void onMessage(Context context, Intent intent) {
        logger.debug("WLGCMIntentService: Received a message from the GCM server");
        Message message = new Message();
        Bundle info = intent.getExtras();
        message.alert = info.getString(GCM_EXTRA_ALERT);
        try {
            message.badge = Integer.parseInt(info.getString(GCM_EXTRA_BADGE), 10);
        }
        catch (Exception e) {
            logger.warn("Unable to update badge while received push notification, becasue failed to parse badge number " + info.getString(GCM_EXTRA_BADGE) + ", badge must be an integer number.");
        }
        message.sound = info.getString(GCM_EXTRA_SOUND);
        message.payload = info.getString(GCM_EXTRA_PAYLOAD);
        intent = new Intent(WLUtils.getFullAppName(context) + GCM_MESSAGE);
        intent.putExtra(GCM_EXTRA_MESSAGE, (Parcelable)message);
        this.addToIntentQueue(intent);
        context.sendOrderedBroadcast(intent, null, this.resultReceiver, null, 1, null, null);
    }

    public void onError(Context context, String errorId) {
        logger.warn("Push notification will not work, because register/unregister to GCM service returned error " + errorId + ".");
        Intent intent = new Intent(WLUtils.getFullAppName(context) + GCM_ERROR);
        intent.putExtra(GCM_EXTRA_ERROR_ID, errorId);
        context.sendBroadcast(intent);
    }

    protected boolean onRecoverableError(Context context, String errorId) {
        logger.warn("Push notification will not work, because register/unregister to GCM service returned error " + errorId + ".");
        return super.onRecoverableError(context, errorId);
    }

    protected void setBroadcastReceiver(BroadcastReceiver resultReceiver) {
        this.resultReceiver = resultReceiver;
    }

    protected void onUnhandled(Context context, Intent intent) {
        this.setResources();
        String action = intent.getAction();
        if ((WLUtils.getFullAppName(context) + GCM_MESSAGE).equals(action)) {
            Message message = (Message)intent.getParcelableExtra(GCM_EXTRA_MESSAGE);
            logger.debug("WLGCMIntentService: Showing notification for unhandled " + message.toString());
            intent = new Intent(WLUtils.getFullAppName(context) + GCM_NOTIFICATION);
            intent.putExtra(GCM_EXTRA_MESSAGE, (Parcelable)message);
            this.notify(context, message.alert, message.badge, message.sound, intent);
        }
    }

    protected void setNotificationIcon(int icon) {
        RES_PUSH_NOTIFICATION_ICON = icon;
    }

    public void notify(Context context, String tickerText) {
        this.generateNotification(context, tickerText, this.getNotificationTitle(context), tickerText, 0, "1", null);
    }

    public void notify(Context context, String alert, int badge, String sound, Intent intent) {
        this.generateNotification(context, alert, this.getNotificationTitle(context), alert, badge, sound, intent);
    }

    private void generateNotification(Context context, String ticker, String title, String msg, int badge, String sound, Intent intent) {
        int icon = RES_PUSH_NOTIFICATION_ICON;
        long when = System.currentTimeMillis();
        Notification notification = new Notification(icon, (CharSequence)ticker, when);
        notification.setLatestEventInfo(context, (CharSequence)title, (CharSequence)msg, PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0x8000000));
        notification.number = badge;
        notification.flags |= 0x10;
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.notify(1, notification);
        if (sound != null && !"".equals(sound.trim())) {
            this.playNotificationSound(context, sound);
        }
    }

    private void playNotificationSound(Context context, String sound) {
        Ringtone ringtone;
        Uri uri = null;
        String soundResourceString = sound;
        try {
            if (soundResourceString.contains(".")) {
                soundResourceString = soundResourceString.substring(0, soundResourceString.indexOf("."));
            }
            uri = Uri.parse((String)("android.resource://" + this.getPackageName() + "/" + WLUtils.getResourceId(context, "raw", soundResourceString)));
        }
        catch (Exception e) {
            logger.error("Push notification sound will not be used because sound file name \"" + soundResourceString + "\" was not found. Add \"" + soundResourceString + "\" to native/res/raw folder.");
        }
        if (uri == null) {
            uri = RingtoneManager.getDefaultUri((int)2);
        }
        if (uri != null && (ringtone = RingtoneManager.getRingtone((Context)context, (Uri)uri)) != null) {
            ringtone.setStreamType(5);
            ringtone.play();
        }
    }

    public static class Message
    implements Parcelable {
        private String alert;
        private String sound;
        private String payload;
        private int badge;
        public static final Parcelable.Creator<Message> CREATOR = new Parcelable.Creator<Message>(){

            public Message[] newArray(int size) {
                return new Message[size];
            }

            public Message createFromParcel(Parcel source) {
                return new Message(source);
            }
        };

        public Message() {
            this.alert = null;
            this.badge = 1;
            this.sound = null;
            this.payload = null;
        }

        public JSONObject getProps() {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put(GCMIntentService.GCM_EXTRA_ALERT, this.alert == null ? JSONObject.NULL : this.alert);
                jsonObject.put(GCMIntentService.GCM_EXTRA_BADGE, this.badge);
                jsonObject.put(GCMIntentService.GCM_EXTRA_SOUND, this.sound == null ? JSONObject.NULL : this.sound);
            }
            catch (JSONException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return jsonObject;
        }

        public JSONObject getPayload() {
            if (this.payload != null) {
                try {
                    return new JSONObject(this.payload);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            return new JSONObject();
        }

        public String toString() {
            return String.format("Message(alert=%s, badge=%d, sound=%s, payload=%s)", this.alert, this.badge, this.sound, this.payload);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.alert);
            dest.writeInt(this.badge);
            dest.writeString(this.sound);
            dest.writeString(this.payload);
        }

        private Message(Parcel source) {
            this.alert = source.readString();
            this.badge = source.readInt();
            this.sound = source.readString();
            this.payload = source.readString();
        }
    }
}

