/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.wlclient.fips;

import android.content.Context;
import android.util.Log;
import com.worklight.common.Logger;
import com.worklight.nativeandroid.common.WLUtils;
import com.worklight.wlclient.fips.MicroVPNLib;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.io.AbstractSessionInputBuffer;
import org.apache.http.impl.io.HttpResponseParser;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.message.BasicLineParser;
import org.apache.http.message.LineParser;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class FipsHttpClient
implements HttpClient {
    private static final Logger logger = Logger.getInstance(FipsHttpClient.class.getName());
    private static final String LOG_TAG = FipsHttpClient.class.getSimpleName();
    private static final String UNIMPLEMENTED_METHOD_MSG = "FipsHttpClient does not implement this method";
    private MicroVPNLib nativeLib;
    private HttpParams mParams;
    private ClientConnectionManager mManager;
    private long share;
    private static Context ctx = null;
    private int uvpn;

    public static synchronized void setCtx(Context appCtx) {
        ctx = appCtx;
    }

    protected FipsHttpClient() {
        StackTraceElement[] traceElements = Thread.currentThread().getStackTrace();
        if (!traceElements[2].toString().contains("FipsHttpClientTest")) {
            throw new RuntimeException("This constructor is for unit tests only, and should not be called in production code!");
        }
        this.mParams = new BasicHttpParams();
    }

    public FipsHttpClient(ClientConnectionManager manager, HttpParams params) {
        WLUtils.loadLib(ctx, "libcrypto.so.1.0.0");
        WLUtils.loadLib(ctx, "libssl.so.1.0.0");
        this.nativeLib = new MicroVPNLib();
        int ret = this.nativeLib.FIPSInit();
        if (ret != 1) {
            throw new RuntimeException("FIPS initialization failed.");
        }
        this.share = this.nativeLib.curlInit();
        if (this.share == -1L) {
            throw new RuntimeException("HTTP client initialization failed.");
        }
        if (params == null) {
            params = new BasicHttpParams();
            HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)false);
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)60000);
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)60000);
            HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
            HttpClientParams.setRedirecting((HttpParams)params, (boolean)false);
        }
        this.mParams = params;
        this.mManager = manager;
        this.uvpn = 0;
    }

    public ClientConnectionManager getConnectionManager() {
        return this.mManager;
    }

    public HttpParams getParams() {
        return this.mParams;
    }

    public HttpResponse execute(HttpHost target, HttpRequest request) {
        throw new RuntimeException(UNIMPLEMENTED_METHOD_MSG);
    }

    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) {
        throw new RuntimeException(UNIMPLEMENTED_METHOD_MSG);
    }

    public String executeRaw(String url, String method, String body, String[] headers) throws IOException {
        String LOG_PREFIX = "entering executeRaw(), ";
        Log.d((String)FipsHttpClient.class.getName(), (String)("entering executeRaw(),  url = " + url));
        Log.d((String)FipsHttpClient.class.getName(), (String)("entering executeRaw(),  httpMethod = " + method));
        Log.d((String)FipsHttpClient.class.getName(), (String)("entering executeRaw(),  headers = " + headers));
        Log.d((String)FipsHttpClient.class.getName(), (String)("entering executeRaw(),  body = " + body));
        logger.debug("entering executeRaw(), ");
        String[] paramFields = new String[]{"redirect: " + HttpClientParams.isRedirecting((HttpParams)this.mParams), HttpConnectionParams.getConnectionTimeout((HttpParams)this.mParams) > 0 ? "connectTO: " + HttpConnectionParams.getConnectionTimeout((HttpParams)this.mParams) : "connectTO: 30", HttpConnectionParams.getSoTimeout((HttpParams)this.mParams) > 0 ? "socketTO: " + HttpConnectionParams.getSoTimeout((HttpParams)this.mParams) : "socketTO: 30", HttpConnectionParams.getSocketBufferSize((HttpParams)this.mParams) > 0 ? "socketSize: " + HttpConnectionParams.getSocketBufferSize((HttpParams)this.mParams) : "socketSize: 0", "CAPath: " + ctx.getFilesDir()};
        byte[] curlRetBytes = this.nativeLib.curlExecute(this.share, this.uvpn, url, method, body, headers, paramFields);
        return new String(curlRetBytes);
    }

    public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException {
        String method = request.getMethod().toString();
        String url = request.getURI().toString();
        String body = "";
        Header[] headerFields = request.getAllHeaders();
        String[] headers = new String[headerFields.length];
        for (int e = 0; e < headerFields.length; ++e) {
            headers[e] = headerFields[e].getName() + ": " + headerFields[e].getValue();
        }
        if (method == "POST") {
            try {
                HttpEntityEnclosingRequest postRequest = (HttpEntityEnclosingRequest)request;
                body = EntityUtils.toString((HttpEntity)postRequest.getEntity());
            }
            catch (IOException e) {
                logger.debug("IOException: " + e);
            }
        }
        String[] paramFields = new String[]{"redirect: " + HttpClientParams.isRedirecting((HttpParams)this.mParams), HttpConnectionParams.getConnectionTimeout((HttpParams)this.mParams) > 0 ? "connectTO: " + HttpConnectionParams.getConnectionTimeout((HttpParams)this.mParams) : "connectTO: 30", HttpConnectionParams.getSoTimeout((HttpParams)this.mParams) > 0 ? "socketTO: " + HttpConnectionParams.getSoTimeout((HttpParams)this.mParams) : "socketTO: 30", HttpConnectionParams.getSocketBufferSize((HttpParams)this.mParams) > 0 ? "socketSize: " + HttpConnectionParams.getSocketBufferSize((HttpParams)this.mParams) : "socketSize: 0", "CAPath: " + ctx.getFilesDir()};
        byte[] curlRetBytes = this.nativeLib.curlExecute(this.share, this.uvpn, url, method, body, headers, paramFields);
        return this.parseCurlResponse(curlRetBytes);
    }

    protected HttpResponse parseCurlResponse(final byte[] curlRetBytes) throws IOException {
        HttpResponse response;
        AbstractSessionInputBuffer inputBuffer = new AbstractSessionInputBuffer(){
            {
                this.init(new ByteArrayInputStream(curlRetBytes), 10, (HttpParams)new BasicHttpParams());
            }

            public boolean isDataAvailable(int timeout) throws IOException {
                throw new RuntimeException("SessionInputBuffer.isDataAvailable was unexpectedly called.");
            }
        };
        HttpResponseParser parser = new HttpResponseParser((SessionInputBuffer)inputBuffer, (LineParser)new BasicLineParser(), (HttpResponseFactory)new DefaultHttpResponseFactory(), (HttpParams)new BasicHttpParams());
        try {
            response = (HttpResponse)parser.parse();
            int contentLength = Integer.valueOf(response.getFirstHeader("Content-Length").getValue());
            byte[] entityBytes = new byte[contentLength];
            System.arraycopy(curlRetBytes, curlRetBytes.length - contentLength, entityBytes, 0, contentLength);
            InputStreamEntity entity = new InputStreamEntity((InputStream)new ByteArrayInputStream(entityBytes), (long)contentLength);
            entity.setContentType(response.getFirstHeader("Content-Type"));
            response.setEntity((HttpEntity)entity);
        }
        catch (HttpException e) {
            logger.error("Problem parsing Curl response: ", e);
            throw new IOException(e);
        }
        return response;
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException {
        try {
            return this.execute(request, (HttpContext)null);
        }
        catch (IOException e) {
            logger.error("IOException: ", e);
            return null;
        }
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) {
        throw new RuntimeException(UNIMPLEMENTED_METHOD_MSG);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) {
        throw new RuntimeException(UNIMPLEMENTED_METHOD_MSG);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) {
        throw new RuntimeException(UNIMPLEMENTED_METHOD_MSG);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) {
        throw new RuntimeException(UNIMPLEMENTED_METHOD_MSG);
    }
}

