/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.wlclient.challengehandler;

import android.content.Context;
import android.content.Intent;
import com.worklight.common.Logger;
import com.worklight.common.WLConfig;
import com.worklight.nativeandroid.common.WLUtils;
import com.worklight.wlclient.api.WLClient;
import com.worklight.wlclient.api.challengehandler.WLChallengeHandler;
import com.worklight.wlclient.ui.UIActivity;
import java.util.ResourceBundle;
import org.json.JSONException;
import org.json.JSONObject;

public class RemoteDisableChallengeHandler
extends WLChallengeHandler {
    private static Logger logger = Logger.getInstance("RemoteDisableChallengeHandler");
    private static final String NOTIFY_MESAGE = "NOTIFY";
    private static final String PROTOCOL_MESSAGE_TYPE = "messageType";
    private static final String PROTOCOL_MESSAGE_ID = "messageId";
    private static final String PROTOCOL_MESSAGE = "message";
    private static final String PROTOCOL_DOWNLOAD_LINK = "downloadLink";
    private static final String NOTIFICATION_TITLE_ID = "WLClient.notificationTitle";
    private static final String APPLICATION_DISABLED_ID = "WLClient.applicationDenied";
    private static final String CLOSE_ID = "WLClient.close";
    private static final String UPGRADE_ID = "WLClient.upgrade";
    private static final String RESOURCE_BUNDLE = "com/worklight/wlclient/messages";
    private static final String PROTOCOL_ERROR_MESSAGE = "Protocol Error - could not parse JSON object";

    public RemoteDisableChallengeHandler(String realm) {
        super(realm);
    }

    @Override
    public void handleSuccess(JSONObject identity) {
    }

    @Override
    public void handleFailure(JSONObject error) {
        try {
            String message = error.getString(PROTOCOL_MESSAGE);
            String downloadLink = error.getString(PROTOCOL_DOWNLOAD_LINK);
            this.createAndShowDisableDialogue(message, downloadLink);
        }
        catch (JSONException e) {
            logger.error(PROTOCOL_ERROR_MESSAGE, e);
            throw new RuntimeException(PROTOCOL_ERROR_MESSAGE);
        }
    }

    private void createAndShowDisableDialogue(String message, String downloadLink) {
        ResourceBundle bundle = WLUtils.getMessagesBundle();
        Context ctx = WLClient.getInstance().getContext();
        Intent intent = new Intent(ctx, UIActivity.class);
        intent.putExtra("action", "wl_remoteDisableRealm");
        intent.putExtra("dialogue_message", message);
        intent.putExtra("dialogue_title", bundle.getString(APPLICATION_DISABLED_ID));
        intent.putExtra("positive_button_text", bundle.getString(CLOSE_ID));
        if (downloadLink != null && downloadLink.length() != 0 && !downloadLink.equalsIgnoreCase("null")) {
            intent.putExtra("download_link", downloadLink);
            intent.putExtra("neutral_button_text", bundle.getString(UPGRADE_ID));
        }
        ctx.startActivity(intent);
    }

    @Override
    public void handleChallenge(JSONObject challenge) {
        try {
            String message = challenge.getString(PROTOCOL_MESSAGE);
            String messageId = challenge.getString(PROTOCOL_MESSAGE_ID);
            String messageType = challenge.getString(PROTOCOL_MESSAGE_TYPE);
            String storedMessageId = WLConfig.getInstance().readWLPref(PROTOCOL_MESSAGE_ID);
            if (this.isDisplayMessageDialogue(storedMessageId, messageId, messageType)) {
                this.createAndShowMessageDialogue(message, messageId);
                WLConfig.getInstance().writeWLPref(PROTOCOL_MESSAGE_ID, messageId);
            } else {
                this.submitChallengeAnswer(messageId);
            }
        }
        catch (JSONException e) {
            logger.error(PROTOCOL_ERROR_MESSAGE, e);
            throw new RuntimeException(PROTOCOL_ERROR_MESSAGE);
        }
    }

    private void createAndShowMessageDialogue(String message, String messageId) {
        ResourceBundle bundle = WLUtils.getMessagesBundle();
        Context ctx = WLClient.getInstance().getContext();
        Intent intent = new Intent(ctx, UIActivity.class);
        intent.putExtra("action", "notify");
        intent.putExtra("dialogue_message", message);
        intent.putExtra("dialogue_title", bundle.getString(NOTIFICATION_TITLE_ID));
        intent.putExtra("positive_button_text", bundle.getString(CLOSE_ID));
        ctx.startActivity(intent);
    }

    private boolean isDisplayMessageDialogue(String storedMessageId, String messageId, String messageType) {
        if (messageType == null || !messageType.equalsIgnoreCase(NOTIFY_MESAGE)) {
            return true;
        }
        return storedMessageId == null || !storedMessageId.equalsIgnoreCase(messageId);
    }
}

