/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.wlclient.challengehandler;

import android.content.Context;
import android.content.Intent;
import com.worklight.common.Logger;
import com.worklight.common.security.AppAuthenticityToken;
import com.worklight.nativeandroid.common.WLUtils;
import com.worklight.wlclient.api.WLClient;
import com.worklight.wlclient.api.challengehandler.WLChallengeHandler;
import com.worklight.wlclient.ui.UIActivity;
import java.util.ResourceBundle;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthenticityChallengeHandler
extends WLChallengeHandler {
    private static Logger logger = Logger.getInstance("AuthenticityChallengeHandler");
    private static final String RESOURCE_BUNDLE = "com/worklight/wlclient/messages";
    private static final String AUTH_FAIL_ID = "WLClient.authFailure";
    private static final String INIT_FAILURE_TITLE_ID = "WLClient.wlclientInitFailure";
    private static final String CLOSE_ID = "WLClient.close";

    public AuthenticityChallengeHandler(String realm) {
        super(realm);
    }

    @Override
    public void handleSuccess(JSONObject identity) {
    }

    @Override
    public void handleFailure(JSONObject error) {
        ResourceBundle bundle = WLUtils.getMessagesBundle();
        Context ctx = WLClient.getInstance().getContext();
        Intent intent = new Intent(ctx, UIActivity.class);
        intent.putExtra("action", "exit");
        intent.putExtra("dialogue_message", bundle.getString(AUTH_FAIL_ID));
        intent.putExtra("dialogue_title", bundle.getString(INIT_FAILURE_TITLE_ID));
        intent.putExtra("positive_button_text", bundle.getString(CLOSE_ID));
        ctx.startActivity(intent);
    }

    @Override
    public void handleChallenge(JSONObject challenge) {
        try {
            String challengeData = challenge.getString("WL-Challenge-Data");
            AppAuthenticityToken token = new AppAuthenticityToken();
            this.submitChallengeAnswer(token.a1(WLClient.getInstance().getContext(), challengeData.substring(0, challengeData.indexOf(43))));
        }
        catch (JSONException e) {
            logger.debug(e.getMessage());
        }
    }
}

