/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.wlclient.api.challengehandler;

import com.worklight.common.Logger;
import com.worklight.common.WLConfig;
import com.worklight.wlclient.AsynchronousRequestSender;
import com.worklight.wlclient.api.WLClient;
import com.worklight.wlclient.api.WLProcedureInvocationData;
import com.worklight.wlclient.api.WLRequestOptions;
import com.worklight.wlclient.api.WLResponse;
import com.worklight.wlclient.api.WLResponseListener;
import com.worklight.wlclient.api.challengehandler.BaseChallengeHandler;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;

public abstract class ChallengeHandler
extends BaseChallengeHandler<WLResponse>
implements WLResponseListener {
    private static Logger logger = Logger.getInstance("ChallengeHandler");

    public ChallengeHandler(String realm) {
        super(realm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void submitSuccess(WLResponse response) {
        ChallengeHandler challengeHandler = this;
        synchronized (challengeHandler) {
            this.activeRequest.removeExpectedAnswer(this.getRealm());
            this.activeRequest = null;
            this.releaseWaitingList();
        }
    }

    public abstract boolean isCustomResponse(WLResponse var1);

    protected void submitLoginForm(String requestURL, Map<String, String> requestParameters, Map<String, String> requestHeaders, int requestTimeoutInMilliseconds, String requestMethod) {
        logger.debug("Request [login]");
        String url = null;
        if (requestURL.indexOf("http") == 0 && requestURL.indexOf(":") > 0) {
            url = requestURL;
        } else {
            String extForm = WLConfig.getInstance().getAppURL().toExternalForm();
            if (extForm.charAt(extForm.length() - 1) == '/' && requestURL.length() > 0 && requestURL.charAt(0) == '/') {
                requestURL = requestURL.substring(1);
            }
            url = extForm + requestURL;
        }
        HttpPost httpRequest = null;
        if (requestMethod.equalsIgnoreCase("post")) {
            httpRequest = new HttpPost(url);
            this.addPostParams(httpRequest, requestParameters);
        } else if (requestMethod.equalsIgnoreCase("get")) {
            httpRequest = new HttpGet(url);
            this.addGetParams((HttpGet)httpRequest, requestParameters);
        } else {
            throw new RuntimeException("CustomChallengeHandler.submitLoginForm: invalid request method.");
        }
        httpRequest.addHeader("x-wl-app-version", WLConfig.getInstance().getApplicationVersion());
        if (requestHeaders != null) {
            for (String headerName : requestHeaders.keySet()) {
                httpRequest.addHeader(headerName, requestHeaders.get(headerName));
            }
        }
        AsynchronousRequestSender.getInstance().sendCustomRequestAsync((HttpRequestBase)httpRequest, requestTimeoutInMilliseconds, this);
    }

    public void submitAdapterAuthentication(WLProcedureInvocationData invocationData, WLRequestOptions requestOptions) {
        if (requestOptions == null) {
            requestOptions = new WLRequestOptions();
        }
        requestOptions.setFromChallenge(true);
        WLClient.getInstance().sendInvoke(invocationData, this, requestOptions);
    }

    private void addPostParams(HttpPost postRequest, Map<String, String> requestParams) {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("isAjaxRequest", "true"));
        if (requestParams != null) {
            for (String paramName : requestParams.keySet()) {
                params.add(new BasicNameValuePair(paramName, requestParams.get(paramName)));
            }
        }
        UrlEncodedFormEntity encodedFormEntity = null;
        try {
            encodedFormEntity = new UrlEncodedFormEntity(params, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
        postRequest.setEntity((HttpEntity)encodedFormEntity);
    }

    private void addGetParams(HttpGet getRequest, Map<String, String> requestParams) {
        BasicHttpParams httpParams = new BasicHttpParams();
        httpParams.setParameter("isAjaxRequest", (Object)"true");
        for (String paramName : requestParams.keySet()) {
            httpParams.setParameter(paramName, (Object)requestParams.get(paramName));
        }
        getRequest.setParams((HttpParams)httpParams);
    }
}

