/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.wlclient.api.challengehandler;

import android.os.Build;
import com.worklight.common.WLConfig;
import com.worklight.common.security.WLDeviceAuthManager;
import com.worklight.wlclient.api.WLClient;
import com.worklight.wlclient.api.challengehandler.WLChallengeHandler;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseDeviceAuthChallengeHandler
extends WLChallengeHandler {
    public BaseDeviceAuthChallengeHandler(String realm) {
        super(realm);
    }

    protected void getDeviceAuthDataAsync(String token) throws Exception, JSONException {
        JSONObject payload = new JSONObject();
        JSONObject appData = new JSONObject();
        JSONObject deviceData = new JSONObject();
        WLClient client = WLClient.getInstance();
        appData.put("id", (Object)WLConfig.getInstance().getAppId());
        appData.put("version", (Object)WLConfig.getInstance().getApplicationVersion());
        WLDeviceAuthManager authManager = WLDeviceAuthManager.getInstance();
        String android_id = authManager.getDeviceUUID(client.getContext());
        deviceData.put("id", (Object)android_id);
        deviceData.put("os", (Object)Build.VERSION.RELEASE);
        deviceData.put("model", (Object)Build.MODEL);
        deviceData.put("environment", (Object)"Android");
        payload.put("app", (Object)appData);
        payload.put("device", (Object)deviceData);
        payload.put("token", (Object)token);
        this.onDeviceAuthDataReady(payload);
    }

    protected abstract void onDeviceAuthDataReady(JSONObject var1) throws JSONException;
}

