/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.wlclient.api.challengehandler;

import com.worklight.wlclient.WLRequest;
import com.worklight.wlclient.api.WLResponse;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseChallengeHandler<T> {
    private String realm;
    protected WLRequest activeRequest = null;
    private List<WLRequest> requestWaitingList = new ArrayList<WLRequest>();

    public String getRealm() {
        return this.realm;
    }

    protected BaseChallengeHandler(String realm) {
        this.realm = realm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startHandleChallenge(WLRequest request, T challenge) {
        BaseChallengeHandler baseChallengeHandler = this;
        synchronized (baseChallengeHandler) {
            if (!request.getOptions().isFromChallenge()) {
                if (this.activeRequest != null) {
                    this.requestWaitingList.add(request);
                    return;
                }
                this.activeRequest = request;
            }
        }
        this.handleChallenge(challenge);
    }

    protected void submitFailure(WLResponse wlResponse) {
        this.clearChallengeRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearChallengeRequests() {
        BaseChallengeHandler baseChallengeHandler = this;
        synchronized (baseChallengeHandler) {
            this.activeRequest = null;
            this.clearWaitingList();
        }
    }

    public abstract void handleChallenge(T var1);

    public synchronized void releaseWaitingList() {
        for (WLRequest request : this.requestWaitingList) {
            request.removeExpectedAnswer(this.realm);
        }
        this.clearWaitingList();
    }

    public synchronized void clearWaitingList() {
        this.requestWaitingList.clear();
    }
}

