/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.wlclient.api;

import com.worklight.common.Logger;
import com.worklight.nativeandroid.common.WLUtils;
import com.worklight.wlclient.api.WLRequestOptions;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.json.JSONException;
import org.json.JSONObject;

public class WLResponse {
    private static Logger logger = Logger.getInstance("wl.response");
    private int status;
    private WLRequestOptions requestOptions;
    protected String responseText;
    private Header[] headers;
    private HttpResponse httpResponseCache;
    private JSONObject responseJSON;

    public WLResponse(HttpResponse httpResponse) {
        this.status = httpResponse.getStatusLine().getStatusCode();
        this.headers = httpResponse.getAllHeaders();
        this.httpResponseCache = httpResponse;
        try {
            if (this.status == 204) {
                return;
            }
            if (this.status == 201) {
                httpResponse.getEntity().consumeContent();
                return;
            }
            if (httpResponse.getHeaders("Content-Encoding").length > 0) {
                logger.trace("Content encoding is " + httpResponse.getHeaders("Content-Encoding")[0].getValue());
                this.responseText = httpResponse.getHeaders("Content-Encoding")[0].getValue().equalsIgnoreCase("gzip") ? WLUtils.convertGZIPStreamToString(httpResponse.getEntity().getContent()) : WLUtils.convertStreamToString(httpResponse.getEntity().getContent());
            } else {
                Header contentLengthHeader = httpResponse.getFirstHeader("Content-Length");
                if (contentLengthHeader != null) {
                    logger.trace("Response does not include a Content-Encoding header. Attempting to read response body as a string.");
                }
                this.responseText = WLUtils.convertStreamToString(httpResponse.getEntity().getContent());
            }
        }
        catch (Exception e) {
            logger.error("Error getting content from server response: " + e.getMessage(), e);
        }
        this.responseTextToJSON(this.responseText);
    }

    WLResponse(WLResponse response) {
        this.status = response.status;
        this.requestOptions = response.requestOptions;
        this.responseText = response.responseText;
        this.responseJSON = response.responseJSON;
        this.httpResponseCache = response.httpResponseCache;
    }

    WLResponse(int status, String responseText, WLRequestOptions requestOptions) {
        this.status = status;
        this.requestOptions = requestOptions;
        this.responseText = responseText;
        this.responseTextToJSON(responseText);
    }

    private void responseTextToJSON(String responseText) {
        int firstIndex = this.responseText.indexOf(123);
        int lastIndex = this.responseText.lastIndexOf(125);
        if (firstIndex == -1 || lastIndex == -1) {
            this.responseJSON = null;
            return;
        }
        String jsonText = this.responseText.substring(firstIndex, lastIndex + 1);
        try {
            this.responseJSON = new JSONObject(jsonText);
        }
        catch (JSONException e) {
            logger.error("Response from Worklight server failed because could not read JSON from response with text " + jsonText, e);
            this.responseJSON = null;
        }
    }

    public int getStatus() {
        return this.status;
    }

    public Object getInvocationContext() {
        return this.requestOptions.getInvocationContext();
    }

    public String getResponseText() {
        return this.responseText;
    }

    void setInvocationContext(Object invocationContext) {
        this.requestOptions.setInvocationContext(invocationContext);
    }

    public WLRequestOptions getOptions() {
        return this.requestOptions;
    }

    public void setOptions(WLRequestOptions wlOptions) {
        this.requestOptions = wlOptions;
    }

    public Header getHeader(String text) {
        for (int i = 0; i < this.headers.length; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCase(text)) continue;
            return this.headers[i];
        }
        return null;
    }

    public Header[] getHeaders() {
        return this.headers;
    }

    void setResponseHeader(String name, String value) {
        this.httpResponseCache.setHeader(name, value);
        this.headers = this.httpResponseCache.getAllHeaders();
    }

    public JSONObject getResponseJSON() {
        return this.responseJSON;
    }

    public String toString() {
        return "WLResponse [invocationContext=" + this.requestOptions.getInvocationContext() + ", responseText=" + this.responseText + ", status=" + this.status + "]";
    }
}

