/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.wlclient.api;

import android.app.Activity;
import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import com.google.android.gcm.GCMRegistrar;
import com.worklight.common.Logger;
import com.worklight.common.WLConfig;
import com.worklight.nativeandroid.common.WLUtils;
import com.worklight.push.GCMErrorCode;
import com.worklight.wlclient.WLRequest;
import com.worklight.wlclient.WLRequestListener;
import com.worklight.wlclient.api.WLEventSourceListener;
import com.worklight.wlclient.api.WLFailResponse;
import com.worklight.wlclient.api.WLNotificationListener;
import com.worklight.wlclient.api.WLOnReadyToSubscribeListener;
import com.worklight.wlclient.api.WLPushOptions;
import com.worklight.wlclient.api.WLRequestOptions;
import com.worklight.wlclient.api.WLResponse;
import com.worklight.wlclient.api.WLResponseListener;
import com.worklight.wlclient.push.GCMIntentService;
import com.worklight.wlclient.ui.UIActivity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WLPush {
    private static Logger logger = Logger.getInstance(WLPush.class.getName());
    private static final String FROM_NOTIFICATION_BAR = "notificationBar";
    private WLConfig config;
    private Context context;
    private Activity activity;
    private boolean isTokenUpdatedOnServer = false;
    private HashMap<String, RegisteredEventSource> registeredEventSources = new HashMap();
    private ArrayList<String> subscribedEventSources = new ArrayList();
    private ArrayList<String> subscribedTags = new ArrayList();
    private ArrayList<JSONObject> pendingPushEvents = new ArrayList();
    private ArrayList<GCMIntentService.Message> pending = new ArrayList();
    private String serverToken = null;
    private String deviceToken = null;
    private static final String RESOURCE_BUNDLE = "com/worklight/wlclient/messages";
    private static final String ERROR_ID = "WLClient.error";
    private static final String NOT_UPDATE_FAILURE = "WLClient.notificationUpdateFailure";
    private static final String OK = "WLClient.ok";
    private WLOnReadyToSubscribeListener onReadyToSubscribeListener = null;
    private WLNotificationListener notificationListener = null;
    private BroadcastReceiver onRegister = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            WLPush.this.deviceToken = intent.getStringExtra("registrationId");
            logger.debug("Successfully registered.Returned deviceToken: " + WLPush.this.deviceToken);
            WLPush.this.updateTokenCallback(WLPush.this.deviceToken);
            WLPush.this.activity.unregisterReceiver(WLPush.this.onRegister);
            WLPush.this.activity.unregisterReceiver(WLPush.this.onRegisterError);
        }
    };
    private BroadcastReceiver onRegisterError = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            GCMErrorCode gcmError;
            ResourceBundle bundle = WLUtils.getMessagesBundle();
            String error = intent.getStringExtra("errorId");
            try {
                gcmError = GCMErrorCode.valueOf(error);
            }
            catch (Exception e) {
                gcmError = GCMErrorCode.UNEXPECTED;
                logger.error("Registering to notification failed because " + error + ".");
            }
            String errDesc = gcmError.getDescription();
            String errorMsg = bundle.getString(errDesc);
            logger.error("The application will not receive push notifications, because registration for push notifications failed with " + errorMsg);
            WLPush.this.showErrorDialogue(bundle.getString(WLPush.ERROR_ID), bundle.getString(WLPush.NOT_UPDATE_FAILURE) + "\n" + errorMsg, bundle.getString(WLPush.OK));
            WLPush.this.activity.unregisterReceiver(WLPush.this.onRegister);
            WLPush.this.activity.unregisterReceiver(WLPush.this.onRegisterError);
        }
    };
    private BroadcastReceiver onMessage = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            logger.debug("Successfully received message for dispatching");
            boolean isFromNotificationBar = intent.getBooleanExtra(WLPush.FROM_NOTIFICATION_BAR, false);
            ArrayList arrayList = WLPush.this.pending;
            synchronized (arrayList) {
                GCMIntentService.Message message = (GCMIntentService.Message)intent.getParcelableExtra("message");
                if (GCMIntentService.isAppForeground() && !isFromNotificationBar) {
                    logger.debug("Push: App on foreground. Add message from intent to pending: " + message);
                    WLPush.this.pending.add(message);
                }
                if (isFromNotificationBar) {
                    WLPush.this.moveQueueToPending();
                }
            }
            if (GCMIntentService.isAppForeground()) {
                WLPush.this.dispatchPending();
            }
            if (!isFromNotificationBar) {
                this.setResultCode(-1);
            }
        }
    };

    WLPush(WLConfig config, Context context) {
        if (context == null) {
            throw new RuntimeException("getPush() call failed because the input parameter 'context' is null. Pass a valid context instance.");
        }
        if (Build.VERSION.SDK_INT < 8) {
            String errorMsg = "The current Android version " + Build.VERSION.RELEASE + " not allowed to work with push.";
            logger.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        this.activity = (Activity)context;
        try {
            GCMRegistrar.checkDevice((Context)this.activity);
        }
        catch (Exception e) {
            throw new RuntimeException("Your device is not allowed to work with push. " + e.getMessage());
        }
        try {
            GCMRegistrar.checkManifest((Context)this.activity);
        }
        catch (Exception e) {
            throw new RuntimeException("Your manifest is not allowed to work with push. " + e.getMessage());
        }
        try {
            WLUtils.getResourceId(context, "drawable", "push");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to find the icon resource. Add the icon file under the /res/drawable folder.");
        }
        this.config = config;
        this.context = context;
        this.setForeground(true);
        this.unregisterReceivers();
        this.activity.registerReceiver(this.onMessage, new IntentFilter(WLUtils.getFullAppName((Context)this.activity) + ".C2DM_MESSAGE"));
        if ((WLUtils.getFullAppName((Context)this.activity) + ".NOTIFICATION").equals(this.activity.getIntent().getAction())) {
            logger.debug("Activity started from message notification");
            this.activity.getIntent().putExtra(FROM_NOTIFICATION_BAR, true);
            this.onMessage.onReceive((Context)this.activity, this.activity.getIntent());
        }
        this.dispatchPending();
    }

    public void setOnReadyToSubscribeListener(WLOnReadyToSubscribeListener listener) {
        this.onReadyToSubscribeListener = listener;
    }

    WLOnReadyToSubscribeListener getOnReadyToSubscribeListener() {
        return this.onReadyToSubscribeListener;
    }

    public void setWLNotificationListener(WLNotificationListener notificationListener) {
        this.notificationListener = notificationListener;
        if (this.hasPendings()) {
            this.dispatchPendings();
        }
    }

    public WLNotificationListener getWLNotificationListener() {
        return this.notificationListener;
    }

    public void registerEventSourceCallback(String alias, String adapter, String eventSource, WLEventSourceListener eventSourceListener) {
        if (WLUtils.isStringEmpty(alias) || WLUtils.isStringEmpty(adapter) || WLUtils.isStringEmpty(eventSource)) {
            logger.error("Cannot register to event source callback with alias '" + alias + "', adapter '" + adapter + "' and eventSource '" + eventSource + "'. Use concrete values which are not null or empty.");
            return;
        }
        if (this.registeredEventSources.get(alias) != null) {
            logger.warn("Event source callback is already registered with alias: " + alias);
            return;
        }
        if (this.isAbleToSubscribe()) {
            this.updateRegisteredEventSources(alias, adapter, eventSource, eventSourceListener);
        }
    }

    public void subscribe(String alias, WLPushOptions pushOptions, WLResponseListener responseListener) {
        if (WLUtils.isStringEmpty(alias)) {
            logger.error("Cannot subscribe to event source with alias '" + alias + "', because it is either null or empty.");
            return;
        }
        if (!this.isAbleToSubscribeEventSource(alias)) {
            return;
        }
        RegisteredEventSource registeredEventSource = this.registeredEventSources.get(alias);
        if (registeredEventSource == null) {
            logger.error("Event source with alias '" + alias + "' is not registered. Register before subscribing to event source.");
            return;
        }
        WLRequestOptions requestOptions = new WLRequestOptions();
        requestOptions.addParameter("alias", alias);
        requestOptions.addParameter("adapter", registeredEventSource.adapter);
        requestOptions.addParameter("eventSource", registeredEventSource.eventSource);
        this.internalSubscribe(requestOptions, pushOptions, new EventSourceSubscribeRequestListener(alias), responseListener, "WLPush.subscribe");
    }

    public void subscribeTag(String tagName, WLPushOptions pushOptions, WLResponseListener responseListener) {
        if (WLUtils.isStringEmpty(tagName)) {
            logger.error("Cannot subscribe to tag with name '" + tagName + "', because it is either null or empty.");
            return;
        }
        if (!this.isAbleToSubscribe()) {
            return;
        }
        WLRequestOptions requestOptions = new WLRequestOptions();
        requestOptions.addParameter("tag", tagName);
        this.internalSubscribe(requestOptions, pushOptions, new TagSubscribeRequestListener(tagName), responseListener, "WLPush.subscribeTag");
    }

    public boolean isSubscribed(String alias) {
        return this.subscribedEventSources != null && this.subscribedEventSources.contains(alias);
    }

    public boolean isTagSubscribed(String tagName) {
        return this.subscribedTags != null && this.subscribedTags.contains(tagName);
    }

    public void unsubscribe(String alias, WLResponseListener responseListener) {
        if (WLUtils.isStringEmpty(alias)) {
            logger.error("Cannot unsubscribe from event source with alias '" + alias + "'.Please check if the input alias is valid.");
            return;
        }
        if (!this.isAbleToSubscribeEventSource(alias)) {
            return;
        }
        RegisteredEventSource registeredEventSource = this.registeredEventSources.get(alias);
        WLRequestOptions requestOptions = new WLRequestOptions();
        requestOptions.addParameter("alias", alias);
        requestOptions.addParameter("adapter", registeredEventSource.adapter);
        requestOptions.addParameter("eventSource", registeredEventSource.eventSource);
        this.internalUnsubscribe(requestOptions, new EventSourceUnSubscribeRequestListener(alias), responseListener, "WLPush.unsubscribe");
    }

    public void unsubscribeTag(String tagName, WLResponseListener responseListener) {
        if (WLUtils.isStringEmpty(tagName)) {
            logger.error("Cannot unsubscribe from tag with name '" + tagName + "'.Please check if the input tag name is valid.");
            return;
        }
        if (!this.isAbleToSubscribe()) {
            return;
        }
        WLRequestOptions requestOptions = new WLRequestOptions();
        requestOptions.addParameter("tag", tagName);
        this.internalUnsubscribe(requestOptions, new TagUnSubscribeRequestListener(tagName), responseListener, "WLPush.unsubscribeTag");
    }

    public boolean isPushSupported() {
        return this.isDeviceSupportPush();
    }

    private void updateRegisteredEventSources(String alias, String adapter, String eventSource, WLEventSourceListener eventSourceListener) {
        RegisteredEventSource registeredEventSource;
        if (this.registeredEventSources == null) {
            this.registeredEventSources = new HashMap();
        }
        if ((registeredEventSource = this.registeredEventSources.get(alias)) == null) {
            registeredEventSource = new RegisteredEventSource();
        }
        registeredEventSource.setAdapter(adapter);
        registeredEventSource.setEventSource(eventSource);
        registeredEventSource.setEventSourceListener(eventSourceListener);
        this.registeredEventSources.put(alias, registeredEventSource);
    }

    private boolean isDeviceSupportPush() {
        return Build.VERSION.SDK_INT >= 10;
    }

    private boolean isAbleToSubscribe() {
        if (!this.isDeviceSupportPush()) {
            logger.error("The current Android version " + Build.VERSION.RELEASE + " does not support push notifications.");
            return false;
        }
        if (!this.isTokenUpdatedOnServer) {
            logger.error("Can't subscribe, notification token is not updated on the server");
            return false;
        }
        return true;
    }

    private boolean isAbleToSubscribeEventSource(String alias) {
        if (!this.isAbleToSubscribe()) {
            return false;
        }
        if (this.registeredEventSources == null || this.registeredEventSources.get(alias) == null) {
            logger.error("No registered push event source for alias '" + alias + "'.");
            return false;
        }
        return true;
    }

    private void internalSubscribe(WLRequestOptions requestOptions, WLPushOptions pushOptions, WLRequestListener listener, WLResponseListener responseListener, final String originMethod) {
        if (pushOptions == null) {
            pushOptions = new WLPushOptions();
        }
        StringBuffer paramBuffer = new StringBuffer();
        String paramName = null;
        Set<String> paramSet = null;
        Iterator<String> paramIterator = null;
        Map<String, String> parameters = pushOptions.getSubscriptionParameters();
        paramBuffer.append("{");
        if (parameters != null && !parameters.isEmpty()) {
            paramSet = parameters.keySet();
            paramIterator = paramSet.iterator();
            while (paramIterator.hasNext()) {
                paramName = paramIterator.next();
                paramBuffer.append("\"");
                paramBuffer.append(paramName);
                paramBuffer.append("\":\"");
                paramBuffer.append(parameters.get(paramName));
                paramBuffer.append("\"");
                if (!paramIterator.hasNext()) continue;
                paramBuffer.append(",");
            }
        }
        paramBuffer.append("}");
        requestOptions.addParameter("subscribe", paramBuffer.toString());
        if (responseListener == null) {
            responseListener = new WLResponseListener(){

                @Override
                public void onSuccess(WLResponse response) {
                }

                @Override
                public void onFailure(WLFailResponse response) {
                    logger.error(originMethod + ": error subscribing for notifications");
                }
            };
        }
        requestOptions.setResponseListener(responseListener);
        WLRequest notificationRequest = new WLRequest(listener, requestOptions, this.config, this.context);
        notificationRequest.makeRequest("notifications");
        this.dispatch();
    }

    private void internalUnsubscribe(WLRequestOptions requestOptions, WLRequestListener listener, WLResponseListener responseListener, final String originMethod) {
        if (responseListener == null) {
            responseListener = new WLResponseListener(){

                @Override
                public void onSuccess(WLResponse response) {
                }

                @Override
                public void onFailure(WLFailResponse response) {
                    logger.error(originMethod + ": error unsubscribing from notifications");
                }
            };
        }
        requestOptions.setResponseListener(responseListener);
        requestOptions.addParameter("unsubscribe", "{}");
        WLRequest notificationRequest = new WLRequest(listener, requestOptions, this.config, this.context);
        notificationRequest.makeRequest("notifications");
    }

    public void updateToken(String serverToken) {
        this.serverToken = serverToken;
        try {
            this.activity.unregisterReceiver(this.onRegister);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.activity.unregisterReceiver(this.onRegisterError);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.activity.registerReceiver(this.onRegister, new IntentFilter(WLUtils.getFullAppName((Context)this.activity) + ".C2DM_REGISTERED"));
        this.activity.registerReceiver(this.onRegisterError, new IntentFilter(WLUtils.getFullAppName((Context)this.activity) + ".C2DM_ERROR"));
        logger.debug("Registering at the GCM server.");
        GCMRegistrar.register((Context)this.context.getApplicationContext(), (String[])new String[]{this.config.getGCMSender()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveQueueToPending() {
        LinkedList<Intent> linkedList = GCMIntentService.intentsQueue;
        synchronized (linkedList) {
            Iterator<Intent> iter = GCMIntentService.intentsQueue.descendingIterator();
            while (iter.hasNext()) {
                GCMIntentService.Message message = (GCMIntentService.Message)iter.next().getParcelableExtra("message");
                this.pending.add(message);
            }
            GCMIntentService.intentsQueue.clear();
        }
    }

    public void clearSubscribedEventSources() {
        logger.debug("Clearing notification subscriptions.");
        this.subscribedEventSources.clear();
    }

    public void clearSubscribedTags() {
        logger.debug("Clearing tag notification subscriptions.");
        this.subscribedTags.clear();
    }

    public void updateSubscribedEventSources(JSONArray eventSources) {
        logger.debug("Updating notification subscriptions.");
        try {
            int length = eventSources.length();
            for (int i = 0; i < length; ++i) {
                JSONObject eventSourceObject = (JSONObject)eventSources.get(i);
                String alias = (String)eventSourceObject.get("alias");
                if (this.subscribedEventSources.contains(alias)) continue;
                this.subscribedEventSources.add(alias);
            }
        }
        catch (JSONException e) {
            logger.error("Updating notification subscriptions failed, because " + e.getMessage());
        }
    }

    public void updateSubscribedTags(JSONArray tags) {
        logger.debug("Updating tag notification subscriptions.");
        try {
            int length = tags.length();
            for (int i = 0; i < length; ++i) {
                String tag = (String)tags.get(i);
                if (this.subscribedTags.contains(tag)) continue;
                this.subscribedTags.add(tag);
            }
        }
        catch (JSONException e) {
            logger.error("Updating tag notification subscriptions failed, because " + e.getMessage());
        }
    }

    private void onMessage(JSONObject props, JSONObject payload) {
        try {
            if (!payload.isNull("alias")) {
                String alias = (String)payload.get("alias");
                logger.debug("WLPush received notification for alias: " + alias);
                if (this.subscribedEventSources.contains(alias) && this.registeredEventSources.containsKey(alias) && this.registeredEventSources.get(alias).eventSourceListener != null) {
                    this.registeredEventSources.get(alias).eventSourceListener.onReceive(props.toString(), payload.toString());
                } else {
                    this.pendingPushEvents.add(new JSONObject("{\"alias\":" + alias + ", \"props\":" + props.toString() + ", \"payload\":" + payload.toString() + "}"));
                }
            } else if (this.notificationListener != null) {
                this.notificationListener.onMessage(props.toString(), payload.toString());
            } else {
                this.pendingPushEvents.add(new JSONObject("{\"props\":" + props.toString() + ", \"payload\":" + payload.toString() + "}"));
            }
        }
        catch (Exception e) {
            logger.error("Failed processing pending push events, because " + e.getMessage());
        }
    }

    private boolean hasPendings() {
        return this.pendingPushEvents != null && this.pendingPushEvents.size() > 0;
    }

    private void dispatchPendings() {
        JSONObject event = null;
        Iterator<JSONObject> pendingIterator = this.pendingPushEvents.iterator();
        while (pendingIterator.hasNext()) {
            event = pendingIterator.next();
            try {
                String alias;
                String string = alias = event.isNull("alias") ? null : (String)event.get("alias");
                if (alias != null) {
                    if (!this.subscribedEventSources.contains(alias) || !this.registeredEventSources.containsKey(alias) || this.registeredEventSources.get(alias).eventSourceListener == null) continue;
                    this.registeredEventSources.get(alias).eventSourceListener.onReceive(event.getString("props"), event.getString("payload"));
                    pendingIterator.remove();
                    this.cancelAllNotification();
                    continue;
                }
                if (this.notificationListener == null) continue;
                this.notificationListener.onMessage(event.getString("props"), event.getString("payload"));
                pendingIterator.remove();
                this.cancelAllNotification();
            }
            catch (JSONException e) {
                logger.error("Failed processing pending push events." + e.getMessage());
            }
        }
    }

    private void updateTokenCallback(String deviceToken) {
        if (this.serverToken == null || !this.serverToken.equals(deviceToken)) {
            logger.debug("Push notification device token has changed, Updating on server [serverToken: " + this.serverToken + ", deviceToken: " + deviceToken + "]");
            WLRequestOptions requestOptions = new WLRequestOptions();
            requestOptions.addParameter("updateToken", deviceToken);
            UpdateTokenListener listener = new UpdateTokenListener();
            WLRequest updateTokenRequest = new WLRequest(listener, requestOptions, this.config, this.context);
            updateTokenRequest.makeRequest("notifications");
        } else {
            this.isTokenUpdatedOnServer = true;
            if (this.onReadyToSubscribeListener != null) {
                this.onReadyToSubscribeListener.onReadyToSubscribe();
            }
            if (this.hasPendings()) {
                this.dispatchPendings();
            }
        }
        this.serverToken = null;
    }

    private void cancelAllNotification() {
        NotificationManager notificationManager = (NotificationManager)this.activity.getSystemService("notification");
        notificationManager.cancelAll();
    }

    public void unregisterReceivers() {
        if (this.activity != null) {
            try {
                this.activity.unregisterReceiver(this.onRegister);
            }
            catch (Exception e) {
                logger.warn("unregisterReceivers:" + e.getMessage());
            }
            try {
                this.activity.unregisterReceiver(this.onRegisterError);
            }
            catch (Exception e) {
                logger.warn("unregisterReceivers:" + e.getMessage());
            }
            try {
                this.activity.unregisterReceiver(this.onMessage);
            }
            catch (Exception e) {
                logger.warn("unregisterReceivers:" + e.getMessage());
            }
        }
        if (GCMRegistrar.isRegistered((Context)this.context.getApplicationContext())) {
            GCMRegistrar.onDestroy((Context)this.context.getApplicationContext());
        }
    }

    private void dispatch() {
        this.dispatchPending();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchPending() {
        while (true) {
            GCMIntentService.Message message = null;
            ArrayList<GCMIntentService.Message> arrayList = this.pending;
            synchronized (arrayList) {
                if (this.pending.size() > 0) {
                    message = this.pending.remove(0);
                }
            }
            if (message == null) break;
            this.onMessage(message.getProps(), message.getPayload());
        }
    }

    private void showErrorDialogue(String title, String message, String buttonText) {
        Intent intent = new Intent(this.context, UIActivity.class);
        intent.putExtra("action", "exit");
        intent.putExtra("dialogue_message", message);
        intent.putExtra("dialogue_title", title);
        intent.putExtra("positive_button_text", buttonText);
        this.context.startActivity(intent);
    }

    public boolean isForeground() {
        return GCMIntentService.isAppForeground();
    }

    public void setForeground(boolean isForeground) {
        GCMIntentService.setAppForeground(isForeground);
        if (isForeground) {
            this.moveQueueToPending();
            this.dispatchPending();
            if (this.pendingPushEvents.isEmpty()) {
                this.cancelAllNotification();
            }
        }
    }

    private void removeOldSubscribedAliases(String alias) {
        RegisteredEventSource regEventSrc = this.registeredEventSources.get(alias);
        String eventSource = regEventSrc.eventSource;
        String adapter = regEventSrc.adapter;
        for (Map.Entry<String, RegisteredEventSource> entry : this.registeredEventSources.entrySet()) {
            RegisteredEventSource itEventSrc = entry.getValue();
            if (!itEventSrc.eventSource.equals(eventSource) || !itEventSrc.adapter.equals(adapter) || entry.getKey().equals(alias)) continue;
            this.subscribedEventSources.remove(entry.getKey());
        }
    }

    class RegisteredEventSource {
        private String adapter;
        private String eventSource;
        private WLEventSourceListener eventSourceListener;

        RegisteredEventSource() {
        }

        public String getAdapter() {
            return this.adapter;
        }

        public void setAdapter(String adapter) {
            this.adapter = adapter;
        }

        public String getEventSource() {
            return this.eventSource;
        }

        public void setEventSource(String eventSource) {
            this.eventSource = eventSource;
        }

        public WLEventSourceListener getEventSourceListener() {
            return this.eventSourceListener;
        }

        public void setEventSourceListener(WLEventSourceListener eventSourceListener) {
            this.eventSourceListener = eventSourceListener;
        }
    }

    class UpdateTokenListener
    implements WLRequestListener {
        @Override
        public void onSuccess(WLResponse wlResponse) {
            WLPush.this.isTokenUpdatedOnServer = true;
            if (WLPush.this.onReadyToSubscribeListener != null) {
                WLPush.this.onReadyToSubscribeListener.onReadyToSubscribe();
            } else {
                logger.debug("onReadyToSubscribeListener is NULL");
            }
            if (WLPush.this.hasPendings()) {
                WLPush.this.dispatchPendings();
            }
        }

        @Override
        public void onFailure(WLFailResponse wlFailResponse) {
            WLPush.this.isTokenUpdatedOnServer = false;
            logger.error("Failed to update token on server");
        }
    }

    class TagUnSubscribeRequestListener
    extends UnSubscribeRequestListener {
        private String tagName;

        public TagUnSubscribeRequestListener(String tagName) {
            this.tagName = tagName;
        }

        @Override
        public void onSuccess(WLResponse response) {
            if (WLPush.this.subscribedTags.contains(this.tagName)) {
                WLPush.this.subscribedTags.remove(this.tagName);
            }
            super.onSuccess(response);
        }
    }

    class EventSourceUnSubscribeRequestListener
    extends UnSubscribeRequestListener {
        private String alias;

        public EventSourceUnSubscribeRequestListener(String alias) {
            this.alias = alias;
        }

        @Override
        public void onSuccess(WLResponse response) {
            WLPush.this.removeOldSubscribedAliases(this.alias);
            if (WLPush.this.subscribedEventSources.contains(this.alias)) {
                WLPush.this.subscribedEventSources.remove(this.alias);
            }
            super.onSuccess(response);
        }
    }

    class UnSubscribeRequestListener
    implements WLRequestListener {
        UnSubscribeRequestListener() {
        }

        @Override
        public void onFailure(WLFailResponse failResponse) {
            failResponse.getOptions().getResponseListener().onFailure(failResponse);
        }

        @Override
        public void onSuccess(WLResponse response) {
            response.getOptions().getResponseListener().onSuccess(response);
        }
    }

    class TagSubscribeRequestListener
    extends SubscribeRequestListener {
        private String tagName;

        public TagSubscribeRequestListener(String tagName) {
            this.tagName = tagName;
        }

        @Override
        public void onSuccess(WLResponse response) {
            if (!WLPush.this.subscribedTags.contains(this.tagName)) {
                WLPush.this.subscribedTags.add(this.tagName);
            }
            super.onSuccess(response);
        }
    }

    class EventSourceSubscribeRequestListener
    extends SubscribeRequestListener {
        private String alias;

        public EventSourceSubscribeRequestListener(String alias) {
            this.alias = alias;
        }

        @Override
        public void onSuccess(WLResponse response) {
            WLPush.this.removeOldSubscribedAliases(this.alias);
            if (!WLPush.this.subscribedEventSources.contains(this.alias)) {
                WLPush.this.subscribedEventSources.add(this.alias);
            }
            super.onSuccess(response);
        }
    }

    class SubscribeRequestListener
    implements WLRequestListener {
        SubscribeRequestListener() {
        }

        @Override
        public void onFailure(WLFailResponse failResponse) {
            failResponse.getOptions().getResponseListener().onFailure(failResponse);
        }

        @Override
        public void onSuccess(WLResponse response) {
            response.getOptions().getResponseListener().onSuccess(response);
            if (WLPush.this.hasPendings()) {
                WLPush.this.dispatchPendings();
            }
        }
    }
}

