/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.wlclient.api;

import com.worklight.common.Logger;
import com.worklight.nativeandroid.common.WLUtils;
import com.worklight.wlclient.api.WLErrorCode;
import com.worklight.wlclient.api.WLRequestOptions;
import com.worklight.wlclient.api.WLResponse;
import org.apache.http.HttpResponse;
import org.json.JSONObject;

public class WLFailResponse
extends WLResponse {
    private static Logger logger = Logger.getInstance("wl.failResponse");
    private static final String JSON_KEY_ERROR_MSG = "errorMsg";
    private static final String JSON_KEY_ERROR_CODE = "errorCode";
    WLErrorCode errorCode;
    String errorMsg;

    WLFailResponse(HttpResponse httpResponse) {
        super(httpResponse);
        this.parseErrorFromResponse();
    }

    public WLFailResponse(WLResponse wlResponse) {
        super(wlResponse);
        this.parseErrorFromResponse();
    }

    public WLFailResponse(WLErrorCode errorCode, String errorMsg, WLRequestOptions requestOptions) {
        super(500, "", requestOptions);
        this.setErrorCode(errorCode);
        this.setErrorMsg(errorMsg);
    }

    public WLErrorCode getErrorCode() {
        return this.errorCode;
    }

    void setErrorCode(WLErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMsg() {
        if (this.errorMsg == null) {
            return this.errorCode.getDescription();
        }
        return this.errorMsg;
    }

    void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    private void parseErrorFromResponse() {
        block7: {
            if (this.getResponseText() != null && this.getResponseText().length() > 0) {
                try {
                    JSONObject jsonResponse = WLUtils.convertStringToJSON(this.getResponseText());
                    this.errorCode = WLErrorCode.UNEXPECTED_ERROR;
                    if (jsonResponse.has(JSON_KEY_ERROR_CODE)) {
                        this.errorCode = WLErrorCode.valueOf(jsonResponse.getString(JSON_KEY_ERROR_CODE));
                    }
                    if (jsonResponse.has(JSON_KEY_ERROR_MSG)) {
                        this.errorMsg = jsonResponse.getString(JSON_KEY_ERROR_MSG);
                    }
                }
                catch (Exception e) {
                    logger.debug(String.format("Additional error information is not available for the current response and response text is: %s", this.getResponseText()), e);
                    this.errorCode = WLErrorCode.UNEXPECTED_ERROR;
                    if (this.getStatus() >= 500) {
                        this.errorCode = WLErrorCode.UNRESPONSIVE_HOST;
                    }
                    if (this.getStatus() >= 408) {
                        this.errorCode = WLErrorCode.REQUEST_TIMEOUT;
                    }
                    if (this.getStatus() < 404) break block7;
                    this.errorCode = WLErrorCode.REQUEST_SERVICE_NOT_FOUND;
                }
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + " WLFailResponse [errorMsg=" + this.errorMsg + ", errorCode=" + (Object)((Object)this.errorCode) + "]";
    }
}

