/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.wlclient.api;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import com.worklight.common.Logger;
import com.worklight.common.WLConfig;
import com.worklight.common.WLTrusteer;
import com.worklight.location.api.WLDevice;
import com.worklight.location.api.WLEventTransmissionPolicy;
import com.worklight.location.internal.nativeImpl.AndroidWLDevice;
import com.worklight.nativeandroid.common.WLUtils;
import com.worklight.wlclient.AsynchronousRequestSender;
import com.worklight.wlclient.HttpClientManager;
import com.worklight.wlclient.WLRequest;
import com.worklight.wlclient.WLRequestListener;
import com.worklight.wlclient.api.WLErrorCode;
import com.worklight.wlclient.api.WLFailResponse;
import com.worklight.wlclient.api.WLProcedureInvocationData;
import com.worklight.wlclient.api.WLProcedureInvocationFailResponse;
import com.worklight.wlclient.api.WLProcedureInvocationResult;
import com.worklight.wlclient.api.WLPush;
import com.worklight.wlclient.api.WLRequestOptions;
import com.worklight.wlclient.api.WLResponse;
import com.worklight.wlclient.api.WLResponseListener;
import com.worklight.wlclient.api.challengehandler.BaseChallengeHandler;
import com.worklight.wlclient.api.challengehandler.ChallengeHandler;
import com.worklight.wlclient.api.challengehandler.WLChallengeHandler;
import com.worklight.wlclient.challengehandler.AntiXSRFChallengeHandler;
import com.worklight.wlclient.challengehandler.AuthenticityChallengeHandler;
import com.worklight.wlclient.challengehandler.NoProvisioningChallengeHandler;
import com.worklight.wlclient.challengehandler.RemoteDisableChallengeHandler;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONException;
import org.json.JSONObject;

public class WLClient {
    public static final Object WAIT_LOCK = new Object();
    private static Logger logger = Logger.getInstance(WLClient.class.getSimpleName());
    private static final String ANTI_XSRF_REALM = "wl_antiXSRFRealm";
    private static final String NO_PROVISIONING_REALM = "wl_deviceNoProvisioningRealm";
    private static final String REMOTE_DISABLE_REALM = "wl_remoteDisableRealm";
    private static final String AUTHENTICITY_REALM = "wl_authenticityRealm";
    private static final String CHALLENGE_HANDLER_NULL_ERROR = "Cannot register 'null' challenge handler";
    private static final String NO_REALM_REGISTER_ERROR = "Application will exit because the challengeHandler parameter for registerChallengeHandler (challengeHandler) has a null realm property. Call this API with a valid reference to challenge handler.";
    private static final String INVOKE_PROCEDURE_INIT_ERROR = "invokeProcedure() will not be executed because WLCLient is not initialized, ensure WLCLient.connect function has been called.";
    protected static final String LOG_ACTIVITY_INIT_ERROR = "logActivity() will not be executed because WLCLient is not initialized, ensure WLCLient.connect function has been called.";
    private static final String INVOKE_PROCEDURE_INVALID_INVOCATION_DATA = "Error during invocation of remote procedure, because invocation data can't be null.";
    private static final String INVOKE_PROCEDURE_RUN_ERROR = "Error during invocation of remote procedure, because responseListener parameter can't be null.";
    private static final String HEART_BEAT_ERROR = "WLClient not initialized - cannot send heart beat message before connect";
    private static final String LOGIN_RUN_ERROR = "Error during login, because realmName or listener parameter can't be null.";
    private static final String LOGOUT_RUN_ERROR = "Error during logout, because realmName or listener parameter can't be null.";
    private static WLClient wlClient = null;
    private static final String REQ_PATH_WL_TOKEN = "oauth/token";
    protected boolean isInitialized;
    private Timer timer;
    private int heartbeatInterval = 420;
    private Context context;
    ActivityListener activityListener = null;
    private WLPush wlPush = null;
    private AndroidWLDevice wlDevice;
    private Hashtable<String, BaseChallengeHandler> chMap;
    private HashMap<String, String> userPreferenceMap;
    private Map<String, String> wlAccessTokens;
    private String wlLastAccessToken = null;

    public Context getContext() {
        return this.context;
    }

    protected Map<String, String> getGlobalHeaders() {
        return AsynchronousRequestSender.getInstance().getGlobalHeaders();
    }

    protected Map<String, String> getUserPreferencemap() {
        return this.userPreferenceMap;
    }

    protected Hashtable<String, BaseChallengeHandler> getchMap() {
        return this.chMap;
    }

    private WLClient(Context context) {
        this.context = context;
        this.wlDevice = new AndroidWLDevice(context);
        this.chMap = new Hashtable();
        this.userPreferenceMap = new HashMap();
        this.wlAccessTokens = new HashMap<String, String>();
        this.registerDefaultChallengeHandlers();
        if (Build.VERSION.SDK_INT >= 14) {
            Application thisApp = (Application)context.getApplicationContext();
            this.activityListener = new ActivityListener();
            thisApp.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityListener);
        }
    }

    public static WLClient createInstance(Context context) {
        if (wlClient != null) {
            logger.debug("WLClient has already been created.");
            WLClient.releaseInstance();
        }
        wlClient = new WLClient(context);
        WLConfig.createInstance(context);
        HttpClientManager.createInstance(context);
        WLTrusteer.createInstance(context);
        return wlClient;
    }

    public static WLClient getInstance() {
        if (wlClient == null) {
            throw new RuntimeException("WLClient object has not been created. You must call WLClient.createInstance first.");
        }
        return wlClient;
    }

    @Deprecated
    public WLConfig getConfig() {
        if (wlClient == null) {
            throw new RuntimeException("WLClient object has not been created. You must call WLClient.createInstance first.");
        }
        WLConfig.createInstance(this.context);
        return WLConfig.getInstance();
    }

    protected static void releaseInstance() {
        wlClient = null;
    }

    public void init(WLResponseListener responseListener) {
        this.connect(responseListener);
    }

    public void connect(WLResponseListener responseListener) {
        this.connect(responseListener, null);
    }

    public void connect(WLResponseListener responseListener, WLRequestOptions options) {
        String instanceId = WLConfig.getInstance().readWLPref("WL-Instance-Id");
        if (!WLUtils.isStringEmpty(instanceId)) {
            this.addGlobalHeader("WL-Instance-Id", instanceId);
        }
        if (options == null) {
            options = new WLRequestOptions();
        }
        options.addParameter("action", "test");
        options.setResponseListener(responseListener);
        InitRequestListener initRequestListener = new InitRequestListener();
        WLRequest initRequest = new WLRequest(initRequestListener, options, WLConfig.getInstance(), this.context);
        initRequest.makeRequest("init");
    }

    public void login(String realmName, WLRequestListener listener, WLRequestOptions options) {
        if (realmName == null || listener == null) {
            throw new IllegalArgumentException(LOGIN_RUN_ERROR);
        }
        if (options == null) {
            options = new WLRequestOptions();
        }
        options.addParameter("realm", realmName);
        WLRequest loginRequest = new WLRequest(listener, options, WLConfig.getInstance(), this.context);
        loginRequest.makeRequest("login");
    }

    public void login(String realmName, WLRequestListener listener) {
        this.login(realmName, listener, null);
    }

    public void logout(String realmName, WLRequestListener listener, WLRequestOptions options) {
        if (realmName == null || listener == null) {
            throw new IllegalArgumentException(LOGOUT_RUN_ERROR);
        }
        if (options == null) {
            options = new WLRequestOptions();
        }
        options.addParameter("realm", realmName);
        WLRequest logoutRequest = new WLRequest(listener, options, WLConfig.getInstance(), this.context);
        logoutRequest.makeRequest("logout");
    }

    public void logout(String realmName, WLRequestListener listener) {
        this.logout(realmName, listener, null);
    }

    public void checkForNotifications() {
        if (!this.isInitialized) {
            return;
        }
        WLRequestListener listener = new WLRequestListener(){

            @Override
            public void onSuccess(WLResponse wlResponse) {
            }

            @Override
            public void onFailure(WLFailResponse wlFailResponse) {
            }
        };
        WLRequest checkNotificationRequest = new WLRequest(listener, new WLRequestOptions(), WLConfig.getInstance(), this.context);
        checkNotificationRequest.makeRequest("authenticate");
    }

    public void addGlobalHeader(String headerName, String value) {
        AsynchronousRequestSender.getInstance().addGlobalHeader(headerName, value);
    }

    public void removeGlobalHeader(String headerName) {
        AsynchronousRequestSender.getInstance().removeGlobalHeader(headerName);
    }

    public void invokeProcedure(WLProcedureInvocationData invocationData, WLResponseListener responseListener, WLRequestOptions requestOptions) {
        if (!this.isInitialized) {
            logger.error(INVOKE_PROCEDURE_INIT_ERROR);
            return;
        }
        if (invocationData == null) {
            throw new IllegalArgumentException(INVOKE_PROCEDURE_INVALID_INVOCATION_DATA);
        }
        if (responseListener == null) {
            throw new IllegalArgumentException(INVOKE_PROCEDURE_RUN_ERROR);
        }
        if (requestOptions == null) {
            requestOptions = new WLRequestOptions();
        }
        requestOptions.setResponseListener(responseListener);
        requestOptions.addParameters(invocationData.getInvocationDataMap());
        InvokeProcedureRequestListener invokeProcedureInternalListener = new InvokeProcedureRequestListener();
        WLRequest invokeProcedureWLRequest = new WLRequest(invokeProcedureInternalListener, requestOptions, WLConfig.getInstance(), this.context);
        invokeProcedureWLRequest.makeRequest("query");
    }

    public void sendInvoke(WLProcedureInvocationData invocationData, WLResponseListener responseListener, WLRequestOptions requestOptions) {
        if (responseListener == null) {
            throw new IllegalArgumentException(INVOKE_PROCEDURE_RUN_ERROR);
        }
        if (requestOptions == null) {
            requestOptions = new WLRequestOptions();
        }
        requestOptions.setResponseListener(responseListener);
        requestOptions.addParameters(invocationData.getInvocationDataMap());
        InvokeProcedureRequestListener invokeProcedureInternalListener = new InvokeProcedureRequestListener();
        WLRequest invokeProcedureWLRequest = new WLRequest(invokeProcedureInternalListener, requestOptions, WLConfig.getInstance(), this.context);
        invokeProcedureWLRequest.makeRequest("invoke", true);
    }

    public void invokeProcedure(WLProcedureInvocationData invocationData, WLResponseListener responseListener) {
        this.invokeProcedure(invocationData, responseListener, null);
    }

    public void logActivity(String activityType) {
        if (!this.isInitialized) {
            logger.error(LOG_ACTIVITY_INIT_ERROR);
            return;
        }
        if (activityType == null) {
            throw new RuntimeException("ActivityType cannot be null");
        }
        WLRequestOptions requestOptions = new WLRequestOptions();
        requestOptions.addParameter("activity", activityType);
        LogActivityListener logActivityListener = new LogActivityListener();
        WLRequest logActivityWLRequest = new WLRequest(logActivityListener, requestOptions, WLConfig.getInstance(), this.context);
        logActivityWLRequest.makeRequest("logactivity");
    }

    protected void setInitialized(boolean isInitialized) {
        this.isInitialized = isInitialized;
    }

    public void setHeartBeatInterval(int newInterval) {
        this.heartbeatInterval = newInterval;
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.sendHeartBeat();
    }

    void sendHeartBeat() {
        if (this.timer == null && this.heartbeatInterval > 0) {
            this.timer = new Timer();
            this.timer.scheduleAtFixedRate((TimerTask)new HeartBeatTask(this.context), this.heartbeatInterval * 1000, (long)(this.heartbeatInterval * 1000));
        }
    }

    public static boolean isApplicationSentToBackground(Context context) {
        if (Build.VERSION.SDK_INT >= 14) {
            return WLClient.wlClient.activityListener.isAppInBackground();
        }
        if (context.checkCallingOrSelfPermission("android.permission.GET_TASKS") == 0) {
            ComponentName topActivity;
            ActivityManager am = (ActivityManager)context.getSystemService("activity");
            List tasks = am.getRunningTasks(1);
            return !tasks.isEmpty() && !(topActivity = ((ActivityManager.RunningTaskInfo)tasks.get((int)0)).topActivity).getPackageName().equals(context.getPackageName());
        }
        logger.warn("Heartbeat calls will continue while the app is in the background. To suspend heartbeat calls while the app is in the background, add the GET_TASKS permission to AndroidManifest.xml");
        return false;
    }

    private void registerDefaultChallengeHandlers() {
        this.registerChallengeHandler(new AntiXSRFChallengeHandler(ANTI_XSRF_REALM));
        this.registerChallengeHandler(new NoProvisioningChallengeHandler(NO_PROVISIONING_REALM));
        this.registerChallengeHandler(new RemoteDisableChallengeHandler(REMOTE_DISABLE_REALM));
        this.registerChallengeHandler(new AuthenticityChallengeHandler(AUTHENTICITY_REALM));
    }

    public void registerChallengeHandler(BaseChallengeHandler challengeHandler) {
        if (challengeHandler == null) {
            logger.error(CHALLENGE_HANDLER_NULL_ERROR);
            throw new RuntimeException(CHALLENGE_HANDLER_NULL_ERROR);
        }
        String realm = challengeHandler.getRealm();
        if (realm == null) {
            logger.error(NO_REALM_REGISTER_ERROR);
            throw new RuntimeException(NO_REALM_REGISTER_ERROR);
        }
        this.chMap.put(realm, challengeHandler);
    }

    public WLChallengeHandler getWLChallengeHandler(String realm) {
        if (realm == null) {
            return null;
        }
        BaseChallengeHandler handler = this.chMap.get(realm);
        if (handler != null && handler instanceof WLChallengeHandler) {
            return (WLChallengeHandler)handler;
        }
        return null;
    }

    public ChallengeHandler getChallengeHandler(WLResponse response) {
        Iterator<Map.Entry<String, BaseChallengeHandler>> iter = this.chMap.entrySet().iterator();
        while (iter.hasNext()) {
            ChallengeHandler cl;
            BaseChallengeHandler handler = iter.next().getValue();
            if (!(handler instanceof ChallengeHandler) || !(cl = (ChallengeHandler)handler).isCustomResponse(response)) continue;
            return cl;
        }
        return null;
    }

    public WLPush getPush() {
        if (this.wlPush == null) {
            this.wlPush = new WLPush(WLConfig.getInstance(), this.context);
        }
        return this.wlPush;
    }

    protected String getWLServerURL() {
        String context = WLConfig.getInstance().getServerContext();
        String host = WLConfig.getInstance().getAppURL().getHost();
        String serverUrl = context != null && context.trim().length() > 1 ? host + context : host;
        return serverUrl;
    }

    public WLDevice getWLDevice() {
        return this.wlDevice;
    }

    public void transmitEvent(JSONObject event) {
        this.transmitEvent(event, false);
    }

    public void transmitEvent(JSONObject event, boolean transmitImmediately) {
        this.wlDevice.getEventTransmitter().transmitEvent(event, transmitImmediately);
    }

    public void setEventTransmissionPolicy(WLEventTransmissionPolicy policy) {
        this.wlDevice.getEventTransmitter().setEventTransmissionPolicy(policy);
    }

    public void purgeEventTransmissionBuffer() {
        this.wlDevice.getEventTransmitter().purgeEvents();
    }

    public void obtainAccessToken(String scope, WLResponseListener responseListener) {
        this.obtainAccessToken(scope, responseListener, null);
    }

    public void obtainAccessToken(String scope, WLResponseListener responseListener, WLRequestOptions requestOptions) {
        if (scope == null) {
            throw new IllegalArgumentException("scope cannot be null");
        }
        WLConfig config = WLConfig.getInstance();
        if (null == requestOptions) {
            requestOptions = new WLRequestOptions();
        }
        String WL_APPNAME = config.getAppId();
        String WL_ENV = config.getWLEnvironment();
        String accessTokenHeaderName = "wl-oauth-client";
        String accessTokenHeaderValue = String.format("WLapp %s:%s", WL_APPNAME, WL_ENV);
        requestOptions.addHeader("wl-oauth-client", accessTokenHeaderValue);
        requestOptions.addParameter("grant_type", "client_credentials");
        requestOptions.addParameter("scope", scope);
        requestOptions.setResponseListener(responseListener);
        WLRequest accessTokenRequest = new WLRequest(new ObtainAccessTokenRequestListener(), requestOptions, config, this.context);
        accessTokenRequest.makeRequest(REQ_PATH_WL_TOKEN, true);
    }

    public String getLastAccessToken() {
        return this.wlLastAccessToken;
    }

    public String getLastAccessToken(String scope) {
        return this.wlAccessTokens.get(scope);
    }

    public String getRequiredAccessTokenScope(int status, String header) {
        if (status != 401 && status != 403) {
            return null;
        }
        Map<String, String> headerAttributes = this.parseAuthenticationHeader(header);
        return headerAttributes.get("scope");
    }

    private Map<String, String> parseAuthenticationHeader(String header) {
        String[] typeAndAttributes = header.split(" ");
        if (typeAndAttributes.length < 2) {
            return null;
        }
        if (!typeAndAttributes[0].equals("Bearer")) {
            return null;
        }
        String[] attributes = header.substring(typeAndAttributes[0].length() + 1).split(",");
        HashMap<String, String> res = new HashMap<String, String>();
        for (int i = 0; i < attributes.length; ++i) {
            String[] pair = attributes[i].split("=");
            if (pair.length != 2) continue;
            String attrName = pair[0];
            String attrValue = pair[1].replace("\"", "");
            res.put(attrName, attrValue);
        }
        return res;
    }

    class ActivityListener
    implements Application.ActivityLifecycleCallbacks {
        private int activityCount = 0;

        ActivityListener() {
        }

        public boolean isAppInBackground() {
            return this.activityCount == 0;
        }

        public void onActivityCreated(Activity arg0, Bundle arg1) {
            logger.debug("on activity created " + arg0.getClass().getName());
        }

        public void onActivityDestroyed(Activity arg0) {
            logger.debug("on activity destroyed " + arg0.getClass().getName());
        }

        public void onActivityPaused(Activity arg0) {
            --this.activityCount;
            logger.debug("on activity paused " + arg0.getClass().getName() + " . activity count = " + this.activityCount);
        }

        public void onActivityResumed(Activity arg0) {
            ++this.activityCount;
            logger.debug("on activity resumed " + arg0.getClass().getName() + " . activity count = " + this.activityCount);
        }

        public void onActivitySaveInstanceState(Activity arg0, Bundle arg1) {
            logger.debug("on activity save instance state " + arg0.getClass().getName());
        }

        public void onActivityStarted(Activity arg0) {
            logger.debug("on activity started " + arg0.getClass().getName());
        }

        public void onActivityStopped(Activity arg0) {
            logger.debug("on activity stopped " + arg0.getClass().getName());
        }
    }

    class HeartbeatListener
    implements WLRequestListener {
        HeartbeatListener() {
        }

        @Override
        public void onFailure(WLFailResponse failResponse) {
            logger.debug("Failed to send heartbeat.");
        }

        @Override
        public void onSuccess(WLResponse response) {
            logger.debug("Heartbeat sent successfully");
        }
    }

    class ObtainAccessTokenRequestListener
    implements WLRequestListener {
        ObtainAccessTokenRequestListener() {
        }

        @Override
        public void onFailure(WLFailResponse failResponse) {
            failResponse.getOptions().getResponseListener().onFailure(failResponse);
        }

        @Override
        public void onSuccess(WLResponse response) {
            try {
                String tokenValue = response.getResponseJSON().getString("access_token");
                String tokenScope = response.getResponseJSON().getString("scope");
                WLClient.this.wlAccessTokens.put(tokenScope, tokenValue);
                WLClient.this.wlLastAccessToken = tokenValue;
                response.getOptions().getResponseListener().onSuccess(response);
            }
            catch (JSONException e) {
                response.getOptions().getResponseListener().onFailure(new WLFailResponse(response));
            }
        }
    }

    class InvokeProcedureRequestListener
    implements WLRequestListener {
        InvokeProcedureRequestListener() {
        }

        @Override
        public void onFailure(WLFailResponse failResponse) {
            WLProcedureInvocationFailResponse pifResponse = new WLProcedureInvocationFailResponse(failResponse);
            failResponse.getOptions().getResponseListener().onFailure(pifResponse);
        }

        @Override
        public void onSuccess(WLResponse response) {
            WLProcedureInvocationResult piResponse = new WLProcedureInvocationResult(response);
            if (piResponse.isSuccessful()) {
                piResponse.getOptions().getResponseListener().onSuccess(piResponse);
            } else {
                WLProcedureInvocationFailResponse pifResponse = new WLProcedureInvocationFailResponse(response);
                pifResponse.setErrorCode(WLErrorCode.PROCEDURE_ERROR);
                pifResponse.getOptions().getResponseListener().onFailure(pifResponse);
            }
            Logger.processAutomaticTrigger();
        }
    }

    class LogActivityListener
    implements WLRequestListener {
        LogActivityListener() {
        }

        @Override
        public void onFailure(WLFailResponse failResponse) {
            logger.error("Activity will not be logged in Worklight server using logActivity() because of " + failResponse.getErrorMsg());
        }

        @Override
        public void onSuccess(WLResponse response) {
            logger.debug("logActivity success. Response from server is " + response.toString());
        }
    }

    class InitRequestListener
    implements WLRequestListener {
        InitRequestListener() {
        }

        @Override
        public void onFailure(WLFailResponse failResponse) {
            failResponse.getOptions().getResponseListener().onFailure(failResponse);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onSuccess(WLResponse response) {
            WLClient.getInstance().setInitialized(true);
            WLClient client = WLClient.getInstance();
            if (client != null) {
                client.sendHeartBeat();
                try {
                    JSONObject userPrefJSON = response.getResponseJSON().getJSONObject("userPrefs");
                    String value = null;
                    if (userPrefJSON != null) {
                        Iterator itr = userPrefJSON.keys();
                        while (itr.hasNext()) {
                            try {
                                String key = (String)itr.next();
                                value = (String)userPrefJSON.get(key);
                                WLClient.this.userPreferenceMap.put(key, value);
                            }
                            catch (JSONException je) {
                                throw new RuntimeException(je.getMessage());
                            }
                        }
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            response.getOptions().getResponseListener().onSuccess(response);
            Logger.processAutomaticTrigger();
        }
    }

    class HeartBeatTask
    extends TimerTask {
        private Context context = null;

        HeartBeatTask(Context context) {
            this.context = context;
        }

        @Override
        public void run() {
            if (!WLClient.this.isInitialized) {
                throw new RuntimeException(WLClient.HEART_BEAT_ERROR);
            }
            if (WLClient.isApplicationSentToBackground(this.context)) {
                return;
            }
            WLRequestOptions requestOptions = new WLRequestOptions();
            HeartbeatListener heartBeatListener = new HeartbeatListener();
            WLClient client = WLClient.getInstance();
            if (client != null) {
                WLRequest heartBeatWLRequest = new WLRequest(heartBeatListener, requestOptions, WLConfig.getInstance(), client.getContext());
                heartBeatWLRequest.makeRequest("heartbeat");
            }
        }
    }
}

