/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.wlclient.api;

import android.content.Context;
import com.worklight.common.WLConfig;
import com.worklight.nativeandroid.common.WLUtils;
import com.worklight.wlclient.WLRequestListener;
import com.worklight.wlclient.api.SecurityUtilsException;
import com.worklight.wlclient.api.WLErrorCode;
import com.worklight.wlclient.api.WLFailResponse;
import com.worklight.wlclient.api.WLResponse;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONException;
import org.json.JSONObject;

public class SecurityUtils {
    private static final String UTF_8 = "UTF-8";
    private static final int IV_BYTE_SIZE = 16;
    private static final int PBKDF2_LENGTH_BYTE_SIZE = 32;
    public static final String CYPHER_TEXT_LABEL = "ct";
    public static final String IV_LABEL = "iv";
    public static final String ENCRYPTION_SOURCE_LABEL = "src";
    public static final String VERSION_LABEL = "v";
    private static final String ENCRYPTION_SOURCE = "java";
    private static final int CURRENT_VERSION = 1;

    public static String generateKey(String password, String salt, int iterations) throws SecurityUtilsException {
        return SecurityUtils.generateKey(password, salt, iterations, 32);
    }

    public static String generateKey(String password, String salt, int iterations, int keyLength) throws SecurityUtilsException {
        if (password == null || password.length() <= 0) {
            throw new SecurityUtilsException("Password cannot be null or empty.");
        }
        if (salt == null || salt.length() <= 0) {
            throw new SecurityUtilsException("Salt cannot be null or empty.");
        }
        if (iterations <= 0) {
            throw new SecurityUtilsException("Iterations must be greater than zero.");
        }
        if (keyLength <= 0) {
            throw new SecurityUtilsException("Key length must be greater than zero.");
        }
        try {
            byte[] generatedKey = com.worklight.androidgap.jsonstore.security.SecurityUtils.generateKey(password, salt, iterations, keyLength).getEncoded();
            String hexEncodedKey = WLUtils.byteArrayToHexString(generatedKey);
            return hexEncodedKey;
        }
        catch (Exception e) {
            throw new SecurityUtilsException("Problem occured while encrypting. Make sure the given key is valid.");
        }
    }

    public static JSONObject encrypt(String key, String plainText) throws SecurityUtilsException {
        if (key == null || key.length() <= 0) {
            throw new SecurityUtilsException("Key cannot be null or empty.");
        }
        if (plainText == null || plainText.length() <= 0) {
            throw new SecurityUtilsException("Plain text cannot be null or empty.");
        }
        String iv = SecurityUtils.getRandomString(16);
        Cipher cipher = null;
        try {
            cipher = SecurityUtils.initCipher(1, WLUtils.hexStringToByteArray(key), WLUtils.hexStringToByteArray(iv));
        }
        catch (InvalidKeyException e1) {
            throw new SecurityUtilsException("Problem occured while encrypting. Make sure the given key is valid.", e1);
        }
        catch (NoSuchAlgorithmException e1) {
            throw new SecurityUtilsException("Problem occured while encrypting. Make sure the given key is valid.", e1);
        }
        catch (NoSuchPaddingException e1) {
            throw new SecurityUtilsException("Problem occured while encrypting. Make sure the given key is valid.", e1);
        }
        catch (InvalidAlgorithmParameterException e1) {
            throw new SecurityUtilsException("Problem occured while encrypting. Make sure the given key is valid.", e1);
        }
        byte[] encrypted = null;
        try {
            encrypted = cipher.doFinal(plainText.getBytes());
        }
        catch (IllegalBlockSizeException e1) {
            throw new SecurityUtilsException("Problem occured while encrypting. Make sure the given key is valid.", e1);
        }
        catch (BadPaddingException e1) {
            throw new SecurityUtilsException("Problem occured while encrypting. Make sure the given key is valid.", e1);
        }
        String hexEncodedCypherText = WLUtils.byteArrayToHexString(encrypted);
        JSONObject encryptedObject = new JSONObject();
        try {
            encryptedObject.put(CYPHER_TEXT_LABEL, (Object)hexEncodedCypherText);
            encryptedObject.put(IV_LABEL, (Object)iv);
            encryptedObject.put(ENCRYPTION_SOURCE_LABEL, (Object)ENCRYPTION_SOURCE);
            encryptedObject.put(VERSION_LABEL, 1);
            return encryptedObject;
        }
        catch (JSONException e) {
            throw new SecurityUtilsException("There was a problem while adding properties to the returned JSONObject.", e);
        }
    }

    public static String decrypt(String key, JSONObject encryptedObject) throws SecurityUtilsException {
        if (key == null || key.length() <= 0) {
            throw new SecurityUtilsException("Key cannot be null or empty.");
        }
        if (!(encryptedObject != null && encryptedObject.length() > 0 && encryptedObject.has(CYPHER_TEXT_LABEL) && encryptedObject.has(IV_LABEL) && encryptedObject.has(ENCRYPTION_SOURCE_LABEL) && encryptedObject.has(VERSION_LABEL))) {
            throw new SecurityUtilsException("The given encrypted object is invalid or null.");
        }
        try {
            if (!encryptedObject.getString(ENCRYPTION_SOURCE_LABEL).equals(ENCRYPTION_SOURCE)) {
                throw new SecurityUtilsException("The encrypted object was generated in another environment. Cannot decrypt in this environment.");
            }
            String cipherText = encryptedObject.getString(CYPHER_TEXT_LABEL);
            String iv = encryptedObject.getString(IV_LABEL);
            byte[] bytes = WLUtils.hexStringToByteArray(cipherText);
            Cipher cipher = SecurityUtils.initCipher(2, WLUtils.hexStringToByteArray(key), WLUtils.hexStringToByteArray(iv));
            byte[] original = cipher.doFinal(bytes);
            return new String(original, UTF_8);
        }
        catch (JSONException e1) {
            throw new SecurityUtilsException("There was a problem while decrypting. Make sure the given encryptedObject is valid.", e1);
        }
        catch (Exception e) {
            throw new SecurityUtilsException("There was a problem while adding properties to the returned JSONObject.", e);
        }
    }

    public static String getRandomString(int byteLength) {
        byte[] randomByteArray = com.worklight.androidgap.jsonstore.security.SecurityUtils.generateLocalKey(byteLength);
        return com.worklight.androidgap.jsonstore.security.SecurityUtils.encodeBytesAsHexString(randomByteArray);
    }

    public static void getRandomStringFromServer(final int byteLength, final Context context, final WLRequestListener listener) {
        new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    WLConfig config = SecurityUtils.getConfig(context);
                    URL url = SecurityUtils.buildURL(byteLength, config);
                    HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
                    try {
                        String randomString = SecurityUtils.readRandomStringFromInputStream(urlConnection);
                        WLResponse response = new WLResponse(200, randomString, null);
                        listener.onSuccess(response);
                    }
                    finally {
                        urlConnection.disconnect();
                    }
                }
                catch (Throwable e) {
                    WLFailResponse failure = new WLFailResponse(WLErrorCode.UNEXPECTED_ERROR, e.getMessage(), null);
                    listener.onFailure(failure);
                }
            }
        }.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readRandomStringFromInputStream(HttpURLConnection urlConnection) throws IOException {
        BufferedInputStream inputStream = new BufferedInputStream(urlConnection.getInputStream());
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
        String randomString = "";
        try {
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                randomString = randomString + inputLine;
            }
        }
        finally {
            in.close();
        }
        return randomString;
    }

    static URL buildURL(int byteLength, WLConfig config) throws MalformedURLException {
        String requestPathForSecureRandom = "apps/services/random";
        String urlString = config.getRootURL() + "/" + requestPathForSecureRandom + "?bytes=" + byteLength;
        URL url = new URL(urlString);
        return url;
    }

    private static WLConfig getConfig(Context context) {
        WLConfig config;
        try {
            config = WLConfig.getInstance();
        }
        catch (IllegalStateException e) {
            WLConfig.createInstance(context);
            config = WLConfig.getInstance();
        }
        return config;
    }

    static Cipher initCipher(int mode, byte[] key, byte[] iv) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        IvParameterSpec ivspec = new IvParameterSpec(iv);
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(mode, (Key)skeySpec, ivspec);
        return cipher;
    }
}

