/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.wlclient;

import android.os.Build;
import com.worklight.common.Logger;
import com.worklight.wlclient.HttpClientManager;
import com.worklight.wlclient.WLRequest;
import com.worklight.wlclient.api.WLErrorCode;
import com.worklight.wlclient.api.WLFailResponse;
import com.worklight.wlclient.api.WLResponse;
import com.worklight.wlclient.api.WLResponseListener;
import java.net.SocketTimeoutException;
import java.util.Date;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.json.JSONObject;

class WLRequestSender
implements Runnable {
    private static final Logger logger = Logger.getInstance("wl.request");
    WLRequest request;

    protected WLRequestSender(WLRequest request) {
        this.request = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.debug("Sending request " + this.request.getPostRequest().getURI());
        WLResponse response = null;
        try {
            long responseContentLength;
            Object httpClient = HttpClientManager.getInstance().getHttpClient();
            this.setUserAgentHeader((HttpClient)httpClient);
            this.setConnectionTimeout((HttpClient)httpClient);
            String trackingId = UUID.randomUUID().toString();
            this.request.getPostRequest().addHeader("x-wl-analytics-tracking-id", trackingId);
            long currTime = new Date().getTime();
            JSONObject loggerMetadata = new JSONObject();
            loggerMetadata.put("$path", (Object)this.request.getPostRequest().getURI().getPath());
            loggerMetadata.put("$category", (Object)"network");
            loggerMetadata.put("$trackingid", (Object)trackingId);
            loggerMetadata.put("$type", (Object)"request");
            loggerMetadata.put("$time", currTime);
            logger.analytics("InternalRequestSender outbound", loggerMetadata);
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)this.request.getPostRequest(), HttpClientManager.getInstance().getHttpContext());
            currTime = new Date().getTime();
            loggerMetadata = new JSONObject();
            loggerMetadata.put("$path", (Object)this.request.getPostRequest().getURI().getPath());
            loggerMetadata.put("$category", (Object)"network");
            loggerMetadata.put("$trackingid", (Object)trackingId);
            loggerMetadata.put("$type", (Object)"response");
            loggerMetadata.put("$time", currTime);
            HttpEntity entity = httpResponse.getEntity();
            long l = responseContentLength = entity == null ? 0L : entity.getContentLength();
            if (responseContentLength != -1L) {
                loggerMetadata.put("$bytes", responseContentLength);
            }
            logger.analytics("InternalRequestSender inbound", loggerMetadata);
            response = new WLResponse(httpResponse);
            response.setOptions(this.request.getOptions());
            this.request.requestFinished(response);
        }
        catch (SocketTimeoutException e) {
            this.request.getRequestListener().onFailure(new WLFailResponse(WLErrorCode.REQUEST_TIMEOUT, WLErrorCode.REQUEST_TIMEOUT.getDescription(), this.request.getOptions()));
            return;
        }
        catch (ConnectTimeoutException e) {
            this.request.getRequestListener().onFailure(new WLFailResponse(WLErrorCode.UNRESPONSIVE_HOST, WLErrorCode.UNRESPONSIVE_HOST.getDescription(), this.request.getOptions()));
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.request.getRequestListener().onFailure(new WLFailResponse(WLErrorCode.UNEXPECTED_ERROR, WLErrorCode.UNEXPECTED_ERROR.getDescription(), this.request.getOptions()));
            return;
        }
        finally {
            if (this.request.getOptions() != null && this.request.getOptions().getResponseListener() != null) {
                WLResponseListener wLResponseListener = this.request.getOptions().getResponseListener();
                synchronized (wLResponseListener) {
                    this.request.getOptions().getResponseListener().notifyAll();
                }
            }
        }
    }

    private void setConnectionTimeout(HttpClient httpClient) {
        HttpConnectionParams.setSoTimeout((HttpParams)httpClient.getParams(), (int)this.request.getOptions().getTimeout());
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpClient.getParams(), (int)this.request.getOptions().getTimeout());
    }

    private void setUserAgentHeader(HttpClient httpClient) {
        String userAgent = (String)httpClient.getParams().getParameter("http.useragent");
        String strWLAgent = "WLNativeAPI(" + Build.DEVICE + "; " + Build.DISPLAY + "; " + Build.MODEL + "; SDK " + Build.VERSION.SDK + "; Android " + Build.VERSION.RELEASE + ")";
        if (userAgent != null && userAgent.indexOf("WLNativeAPI(") < 0) {
            httpClient.getParams().setParameter("http.useragent", (Object)(userAgent + " " + strWLAgent));
        } else if (userAgent == null) {
            httpClient.getParams().setParameter("http.useragent", (Object)strWLAgent);
        }
    }
}

