/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.wlclient;

import android.content.Context;
import android.content.Intent;
import com.worklight.common.Logger;
import com.worklight.common.WLConfig;
import com.worklight.nativeandroid.common.WLUtils;
import com.worklight.wlclient.AsynchronousRequestSender;
import com.worklight.wlclient.WLRequestListener;
import com.worklight.wlclient.WLRequestPiggybacker;
import com.worklight.wlclient.api.WLClient;
import com.worklight.wlclient.api.WLErrorCode;
import com.worklight.wlclient.api.WLFailResponse;
import com.worklight.wlclient.api.WLPush;
import com.worklight.wlclient.api.WLRequestOptions;
import com.worklight.wlclient.api.WLResponse;
import com.worklight.wlclient.api.challengehandler.ChallengeHandler;
import com.worklight.wlclient.api.challengehandler.WLChallengeHandler;
import com.worklight.wlclient.ui.UIActivity;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WLRequest {
    private static Logger logger = Logger.getInstance(WLRequest.class.getName());
    private static final String RESOURCE_BUNDLE = "com/worklight/wlclient/messages";
    private static final String AUTH_FAIL_ID = "WLClient.authFailure";
    private static final String ERROR_ID = "WLClient.error";
    private static final String CLOSE_BUTTON_ID = "WLClient.close";
    private static final String ACCESS_DENIED_ID = "WLClient.accessDenied";
    private static final Set<WLRequestPiggybacker> PIGGYBACKERS = Collections.synchronizedSet(new HashSet());
    private WLRequestListener requestListener;
    private HttpPost postRequest;
    protected WLRequestOptions requestOptions;
    private WLConfig config;
    private Context context;
    private String requestURL = null;
    private HashMap<String, Object> wlAnswers = new HashMap();

    public WLRequest(WLRequestListener wlRequestListener, WLRequestOptions wlRequestData, WLConfig wlConfig, Context context) {
        this.requestListener = wlRequestListener;
        this.requestOptions = wlRequestData;
        this.config = wlConfig;
        this.context = context;
    }

    public static void addRequestPiggybacker(WLRequestPiggybacker piggybacker) {
        PIGGYBACKERS.add(piggybacker);
    }

    public static void removeRequestPiggybacker(WLRequestPiggybacker piggybacker) {
        PIGGYBACKERS.remove(piggybacker);
    }

    public void makeRequest(String requestPath) {
        this.makeRequest(requestPath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeRequest(String requestPath, boolean isFullPath) {
        Set<WLRequestPiggybacker> set = PIGGYBACKERS;
        synchronized (set) {
            for (WLRequestPiggybacker piggybacker : PIGGYBACKERS) {
                piggybacker.processOptions(requestPath, this.requestOptions);
            }
        }
        this.requestURL = null;
        this.requestURL = !isFullPath ? this.config.getAppURL().toExternalForm() + requestPath : this.config.getRootURL() + "/" + requestPath;
        this.sendRequest(this.requestURL);
    }

    private void sendRequest(String requestURL) {
        this.postRequest = new HttpPost(requestURL);
        this.addHeaders(this.config, this.postRequest);
        this.addExtraHeaders(this.postRequest);
        this.addParams(this.requestOptions, this.postRequest);
        this.addExpectedAnswers(this.postRequest);
        try {
            AsynchronousRequestSender.getInstance().sendWLRequestAsync(this);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            this.triggerUnexpectedOnFailure(e);
        }
    }

    public void requestFinished(WLResponse response) {
        boolean isContainChallenges;
        try {
            this.checkResponseForSuccesses(response);
        }
        catch (Exception e) {
            this.triggerUnexpectedOnFailure(e);
            return;
        }
        try {
            isContainChallenges = this.checkResponseForChallenges(response);
        }
        catch (Exception e) {
            this.triggerUnexpectedOnFailure(e);
            return;
        }
        if (!isContainChallenges) {
            if (response.getStatus() == 200) {
                try {
                    Object subscriptionStateObj;
                    JSONObject responseJson = response.getResponseJSON();
                    if (responseJson != null && (subscriptionStateObj = responseJson.get("notificationSubscriptionState")) != null) {
                        JSONObject subscriptionState = (JSONObject)subscriptionStateObj;
                        Class.forName("com.google.android.gcm.GCMRegistrar");
                        WLClient client = WLClient.getInstance();
                        WLPush push = client.getPush();
                        String token = null;
                        if (subscriptionState.has("token")) {
                            token = (String)subscriptionState.get("token");
                        }
                        push.updateToken(token);
                        push.clearSubscribedEventSources();
                        if (subscriptionState.has("eventSources")) {
                            push.updateSubscribedEventSources((JSONArray)subscriptionState.get("eventSources"));
                        }
                        push.clearSubscribedTags();
                        if (subscriptionState.has("tags")) {
                            push.updateSubscribedTags((JSONArray)subscriptionState.get("tags"));
                        }
                    }
                }
                catch (JSONException e) {
                }
                catch (ClassNotFoundException e) {
                    logger.error("Push notification will not work because GCMRegistrar class is not available. Check if gcm.jar is available in the path.");
                }
                this.processSuccessResponse(response);
            } else if (response.getStatus() == 201 || response.getStatus() == 204) {
                logger.debug("requestFinished with status: " + response.getStatus());
                this.processSuccessResponse(response);
            } else {
                this.processFailureResponse(response);
            }
        }
    }

    private void triggerUnexpectedOnFailure(Exception e) {
        this.getRequestListener().onFailure(new WLFailResponse(WLErrorCode.UNEXPECTED_ERROR, e.getMessage(), this.getOptions()));
    }

    private void addHeaders(WLConfig config, HttpPost postRequest) {
        postRequest.addHeader("X-Requested-With", "XMLHttpRequest");
        postRequest.addHeader("x-wl-app-version", config.getApplicationVersion());
        postRequest.addHeader("Accept-Language", Locale.getDefault().toString());
        postRequest.addHeader("x-wl-platform-version", config.getPlatformVersion());
    }

    private void addExtraHeaders(HttpPost postRequest) {
        ArrayList<Header> extraHeaders = this.requestOptions.getHeaders();
        if (extraHeaders == null) {
            return;
        }
        for (Header header : extraHeaders) {
            postRequest.addHeader(header);
        }
    }

    private void addParams(WLRequestOptions requestOptions, HttpPost postRequest) {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        if (requestOptions.getParameters() != null && !requestOptions.getParameters().isEmpty()) {
            for (String paramName : requestOptions.getParameters().keySet()) {
                params.add(new BasicNameValuePair(paramName, requestOptions.getParameters().get(paramName)));
            }
        }
        params.add(new BasicNameValuePair("isAjaxRequest", "true"));
        params.add(new BasicNameValuePair("x", String.valueOf(Math.random())));
        UrlEncodedFormEntity encodedFormEntity = null;
        try {
            encodedFormEntity = new UrlEncodedFormEntity(params, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
        if (postRequest.getURI().getPath().endsWith("apps/services/loguploader")) {
            postRequest.setHeader("x-wl-compressed", "true");
            postRequest.setHeader("Content-Encoding", "gzip");
            postRequest.setHeader("Content-Type", "application/json");
            JSONObject paramsMap = new JSONObject();
            for (NameValuePair nameValuePair : params) {
                try {
                    paramsMap.put(nameValuePair.getName(), (Object)nameValuePair.getValue());
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            try {
                GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(bOut);
                gZIPOutputStream.write(paramsMap.toString().getBytes("UTF-8"));
                gZIPOutputStream.finish();
                gZIPOutputStream.close();
                postRequest.setEntity((HttpEntity)new ByteArrayEntity(bOut.toByteArray()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                logger.error(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
                throw new RuntimeException(unsupportedEncodingException);
            }
            catch (IOException iOException) {
                logger.error(iOException.getMessage(), iOException);
                throw new RuntimeException(iOException);
            }
        } else {
            postRequest.setEntity((HttpEntity)encodedFormEntity);
            return;
        }
    }

    private void addExpectedAnswers(HttpPost postRequest) {
        if (this.wlAnswers.isEmpty()) {
            return;
        }
        JSONObject allAnswers = new JSONObject();
        for (Map.Entry<String, Object> entry : this.wlAnswers.entrySet()) {
            String realm = entry.getKey();
            Object answer = entry.getValue();
            if (answer == null) {
                return;
            }
            try {
                allAnswers.accumulate(realm, answer);
            }
            catch (JSONException e) {
                logger.error(e.getMessage(), e);
                throw new RuntimeException(e);
            }
        }
        String strJSON = allAnswers.toString();
        postRequest.addHeader("Authorization", strJSON);
        this.wlAnswers.clear();
    }

    public WLRequestListener getRequestListener() {
        return this.requestListener;
    }

    public HttpPost getPostRequest() {
        return this.postRequest;
    }

    public WLRequestOptions getOptions() {
        return this.requestOptions;
    }

    public WLConfig getConfig() {
        return this.config;
    }

    public Context getContext() {
        return this.context;
    }

    private void setExpectedAnswers(List<String> realms) {
        for (String realm : realms) {
            this.wlAnswers.put(realm, null);
        }
    }

    public void submitAnswer(String realm, Object answer) {
        this.wlAnswers.put(realm, answer);
        this.resendIfNeeded();
    }

    private void resendIfNeeded() {
        boolean resend = true;
        if (this.wlAnswers == null) {
            resend = true;
        } else {
            Collection<Object> answers = this.wlAnswers.values();
            for (Object obj : answers) {
                if (obj != null) continue;
                resend = false;
                break;
            }
        }
        if (resend) {
            this.resendRequest();
        }
    }

    public void removeExpectedAnswer(String realm) {
        this.wlAnswers.remove(realm);
        this.resendIfNeeded();
    }

    private void checkResponseForSuccesses(WLResponse response) {
        JSONObject responseJSON = response.getResponseJSON();
        if (responseJSON == null) {
            return;
        }
        try {
            if (!responseJSON.has("WL-Authentication-Success")) {
                return;
            }
            JSONObject successes = responseJSON.getJSONObject("WL-Authentication-Success");
            if (successes != null) {
                JSONArray realms = successes.names();
                for (int i = 0; i < successes.length(); ++i) {
                    String realm = realms.getString(i);
                    JSONObject success = successes.getJSONObject(realm);
                    WLChallengeHandler handler = WLClient.getInstance().getWLChallengeHandler(realm);
                    if (handler == null) continue;
                    handler.handleSuccess(success);
                    handler.releaseWaitingList();
                }
            }
        }
        catch (Exception e) {
            this.triggerUnexpectedOnFailure(e);
        }
    }

    private boolean checkResponseForChallenges(WLResponse response) {
        boolean containsChallenges = false;
        ResourceBundle bundle = WLUtils.getMessagesBundle();
        if (this.isWl401(response)) {
            JSONObject responseJSON = response.getResponseJSON();
            ArrayList<String> realmNames = new ArrayList<String>();
            try {
                JSONObject challenges = responseJSON.getJSONObject("challenges");
                JSONArray realms = challenges.names();
                for (int i = 0; i < realms.length(); ++i) {
                    realmNames.add(realms.getString(i));
                }
                this.setExpectedAnswers(realmNames);
                for (String realm : realmNames) {
                    JSONObject challenge = challenges.getJSONObject(realm);
                    WLChallengeHandler handler = WLClient.getInstance().getWLChallengeHandler(realm);
                    if (handler == null) {
                        logger.error("Application will exit, because unexpected challenge handler arrived while using realm " + realm + ". Register the challenge handler using registerChallengeHandler().");
                        this.showErrorDialogue(bundle.getString(ERROR_ID), bundle.getString(AUTH_FAIL_ID), bundle.getString(CLOSE_BUTTON_ID));
                        continue;
                    }
                    handler.startHandleChallenge(this, challenge);
                }
            }
            catch (JSONException e) {
                logger.debug("Wrong JSON arrived when processing a challenge in a 401 response. With " + e.getMessage(), e);
            }
            containsChallenges = true;
        } else if (this.isWl403(response)) {
            JSONObject responseJSON = response.getResponseJSON();
            try {
                JSONObject challenges = responseJSON.getJSONObject("WL-Authentication-Failure");
                JSONArray realms = challenges.names();
                for (int i = 0; i < realms.length(); ++i) {
                    String realm = realms.getString(i);
                    JSONObject challenge = challenges.getJSONObject(realm);
                    WLChallengeHandler handler = WLClient.getInstance().getWLChallengeHandler(realm);
                    if (handler != null) {
                        handler.handleFailure(challenge);
                        handler.clearWaitingList();
                        continue;
                    }
                    StringBuilder b = new StringBuilder(bundle.getString(ACCESS_DENIED_ID));
                    String reason = bundle.getString("WLClient.missingHandler");
                    if (reason != null) {
                        b.append("\n" + bundle.getString("WLClient.reason") + ":" + reason + " - " + realm);
                    }
                    logger.error("Connect to Worklight server failed due to missing challenge handler to handle " + realm);
                    this.showErrorDialogue(bundle.getString(ERROR_ID), b.toString(), bundle.getString(CLOSE_BUTTON_ID));
                }
            }
            catch (JSONException e) {
                logger.debug("Wrong JSON arrived when processing a challenge in a 403 response. with " + e.getMessage(), e);
            }
            containsChallenges = true;
        } else {
            containsChallenges = this.handleCustomChallenges(response);
        }
        return containsChallenges;
    }

    private void showErrorDialogue(String title, String message, String buttonText) {
        Context ctx = WLClient.getInstance().getContext();
        Intent intent = new Intent(ctx, UIActivity.class);
        intent.putExtra("action", "exit");
        intent.putExtra("dialogue_message", message);
        intent.putExtra("dialogue_title", title);
        intent.putExtra("positive_button_text", buttonText);
        ctx.startActivity(intent);
    }

    private boolean isWl401(WLResponse response) {
        Header challengesHeader;
        return response.getStatus() == 401 && (challengesHeader = response.getHeader("WWW-Authenticate")) != null && challengesHeader.getValue().equalsIgnoreCase("WL-Composite-Challenge");
    }

    private boolean isWl403(WLResponse response) {
        try {
            return response.getStatus() == 403 && response.getResponseJSON() != null && response.getResponseJSON().get("WL-Authentication-Failure") != null;
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSuccessResponse(WLResponse response) {
        Set<WLRequestPiggybacker> set = PIGGYBACKERS;
        synchronized (set) {
            for (WLRequestPiggybacker piggybacker : PIGGYBACKERS) {
                piggybacker.onSuccess(response);
            }
        }
        this.requestListener.onSuccess(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFailureResponse(WLResponse response) {
        WLFailResponse failResponse = new WLFailResponse(response);
        failResponse.setOptions(this.requestOptions);
        Set<WLRequestPiggybacker> set = PIGGYBACKERS;
        synchronized (set) {
            for (WLRequestPiggybacker piggybacker : PIGGYBACKERS) {
                piggybacker.onFailure(failResponse);
            }
        }
        this.requestListener.onFailure(failResponse);
    }

    private boolean handleCustomChallenges(WLResponse response) {
        boolean containsChallenges = false;
        ChallengeHandler handler = WLClient.getInstance().getChallengeHandler(response);
        if (handler != null) {
            handler.startHandleChallenge(this, response);
            containsChallenges = true;
        }
        return containsChallenges;
    }

    private void resendRequest() {
        if (this.requestURL != null) {
            this.sendRequest(this.requestURL);
        } else {
            logger.debug("resendRequest failed: requestURL is null.");
        }
    }

    public static interface RequestPaths {
        public static final String INIT = "init";
        public static final String INVOKE_PROCEDURE = "query";
        public static final String SEND_INVOKE_PROCEDURE = "invoke";
        public static final String SET_USER_PREFS = "setup";
        public static final String DELETE_USER_PREF = "deleteup";
        public static final String LOG_ACTIVITY = "logactivity";
        public static final String AUTHENTICATE = "authenticate";
        public static final String HEART_BEAT = "heartbeat";
        public static final String EVENTS = "events";
        public static final String NOTIFICATION = "notifications";
        public static final String GET_CONFIG = "apps/services/configprofile";
        public static final String UPLOAD_LOGS = "apps/services/loguploader";
        public static final String LOGIN = "login";
        public static final String LOGOUT = "logout";
        public static final String SSL_CLIENT_AUTH = "sslclientauth";
    }
}

