/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.wlclient;

import android.content.Context;
import android.content.SharedPreferences;
import com.loopj.android.http.PersistentCookieStore;
import com.loopj.android.http.SerializableCookie;
import com.worklight.common.WLConfig;
import com.worklight.common.WLSimpleDataSharing;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.cookie.Cookie;

class WLPersistentCookieStore
extends PersistentCookieStore {
    private final SharedPreferences cookiePreferences;
    private static Context context;
    private static final String SHARED_PREFS_STORE_NAME = "CookiePrefsFile";
    private static final String COOKIE_NAME_PREFIX = "cookie_";
    private List<String> sharableCookies = new ArrayList<String>();

    public WLPersistentCookieStore(Context ctx) {
        super(ctx);
        context = ctx;
        this.cookiePreferences = context.getSharedPreferences(SHARED_PREFS_STORE_NAME, 0);
        this.sharableCookies = WLConfig.getInstance().getShareCookies();
        while (this.sharableCookies.remove("JSESSIONID")) {
        }
    }

    public void addCookie(Cookie cookie) {
        super.addCookie(cookie);
        if (this.sharableCookies.contains(cookie.getName())) {
            new WLSimpleDataSharing(context).setSharedToken(cookie.getName(), this.encodeCookie(new SerializableCookie(cookie)));
        }
        if (cookie.getExpiryDate() == null) {
            SharedPreferences.Editor prefsWriter = this.cookiePreferences.edit();
            prefsWriter.remove(COOKIE_NAME_PREFIX + cookie.getName());
            prefsWriter.commit();
        }
    }

    public List<Cookie> getCookies() {
        List cookies = super.getCookies();
        for (String sharableCookie : this.sharableCookies) {
            String value = new WLSimpleDataSharing(context).getSharedToken(sharableCookie);
            if (value == null || value.equals("")) continue;
            Cookie foundCookie = null;
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(sharableCookie)) continue;
                foundCookie = cookie;
                break;
            }
            cookies.remove(foundCookie);
            Cookie sharedCookie = this.decodeCookie(value);
            cookies.add(sharedCookie);
        }
        return cookies;
    }
}

