/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.wlclient;

import com.worklight.common.Logger;
import com.worklight.wlclient.HttpClientManager;
import com.worklight.wlclient.HttpPostListener;
import java.io.IOException;
import java.util.Date;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.json.JSONObject;

class HttpPostRequestSender
implements Runnable {
    private static Logger logger = Logger.getInstance("HttpPostRequestSender");
    HttpPost httpRequest;
    int requestTimeoutMs;
    HttpPostListener listener;

    protected HttpPostRequestSender(HttpPost httpRequest, int timeoutMs, HttpPostListener listener) {
        this.httpRequest = httpRequest;
        this.requestTimeoutMs = timeoutMs;
        this.listener = listener;
    }

    @Override
    public void run() {
        logger.debug("Sending request " + this.httpRequest.getURI());
        try {
            DefaultHttpClient httpClient = HttpClientManager.getInstance().getHttpClient();
            HttpContext httpContext = HttpClientManager.getInstance().getHttpContext();
            HttpConnectionParams.setSoTimeout((HttpParams)httpClient.getParams(), (int)this.requestTimeoutMs);
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpClient.getParams(), (int)this.requestTimeoutMs);
            httpClient.getParams().setParameter("http.useragent", (Object)HttpClientManager.getInstance().getWebViewUserAgent());
            String trackingId = UUID.randomUUID().toString();
            this.httpRequest.addHeader("x-wl-analytics-tracking-id", trackingId);
            this.logOutboundRequest(trackingId);
            HttpResponse response = httpClient.execute((HttpUriRequest)this.httpRequest, httpContext);
            HttpEntity entity = response.getEntity();
            this.logInboundResponse(trackingId, entity);
            this.listener.onResponse(response);
        }
        catch (ClientProtocolException e) {
            this.listener.onException((Exception)((Object)e));
        }
        catch (IOException e) {
            this.listener.onException(e);
        }
    }

    private void logOutboundRequest(String trackingId) {
        try {
            long currTime = new Date().getTime();
            JSONObject loggerMetadata = new JSONObject();
            loggerMetadata.put("$path", (Object)this.httpRequest.getURI().getPath());
            loggerMetadata.put("$category", (Object)"network");
            loggerMetadata.put("$trackingid", (Object)trackingId);
            loggerMetadata.put("$type", (Object)"request");
            loggerMetadata.put("$time", currTime);
            logger.analytics("InternalRequestSender outbound", loggerMetadata);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void logInboundResponse(String trackingId, HttpEntity entity) {
        try {
            long responseContentLength;
            JSONObject loggerMetadata = new JSONObject();
            long currTime = new Date().getTime();
            loggerMetadata = new JSONObject();
            loggerMetadata.put("$path", (Object)this.httpRequest.getURI().getPath());
            loggerMetadata.put("$category", (Object)"network");
            loggerMetadata.put("$trackingid", (Object)trackingId);
            loggerMetadata.put("$type", (Object)"response");
            loggerMetadata.put("$time", currTime);
            long l = responseContentLength = entity == null ? 0L : entity.getContentLength();
            if (responseContentLength != -1L) {
                loggerMetadata.put("$bytes", responseContentLength);
            }
            logger.analytics("InternalRequestSender inbound", loggerMetadata);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

