/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.wlclient;

import android.content.Context;
import android.net.SSLCertificateSocketFactory;
import android.webkit.WebView;
import com.worklight.common.Logger;
import com.worklight.common.WLConfig;
import com.worklight.wlclient.WLPersistentCookieStore;
import java.security.KeyStore;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.client.CookieStore;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class HttpClientManager {
    private static HttpClientManager instance;
    private DefaultHttpClient httpClient;
    private HttpContext httpContext;
    private String webViewUserAgent;
    private static final int SOCKET_OPERATION_TIMEOUT = 60000;
    private static Logger logger;

    private HttpClientManager(Context context) {
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)false);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)60000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)60000);
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        HttpClientParams.setRedirecting((HttpParams)params, (boolean)false);
        HttpClientParams.setAuthenticating((HttpParams)params, (boolean)false);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        String protocol = WLConfig.getInstance().getProtocol();
        int port = Integer.valueOf(WLConfig.getInstance().getPort());
        if (protocol.equalsIgnoreCase("http") || protocol.equalsIgnoreCase("https")) {
            schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), port));
            try {
                SSLSocketFactory sslSocketFactory = SSLCertificateSocketFactory.getHttpSocketFactory((int)60000, null);
                schemeRegistry.register(new Scheme("https", (SocketFactory)sslSocketFactory, port));
            }
            catch (NoClassDefFoundError e) {
                logger.error("Error while registering the https schema", e);
            }
        } else {
            throw new RuntimeException("HttpClientFactory: Can't create HttpClient with protocol " + protocol);
        }
        ThreadSafeClientConnManager manager = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)manager, (HttpParams)params);
        this.httpClient.setCookieStore((CookieStore)new WLPersistentCookieStore(context));
        this.httpContext = new BasicHttpContext();
        this.httpContext.setAttribute("http.cookie-store", (Object)this.httpClient.getCookieStore());
        this.webViewUserAgent = new WebView(context).getSettings().getUserAgentString();
        if (!this.webViewUserAgent.contains("Worklight")) {
            this.webViewUserAgent = this.webViewUserAgent + "/Worklight/" + WLConfig.getInstance().getPlatformVersion();
        }
    }

    public static boolean setSSLSocketFactory(KeyStore keyStore, char[] keyStorePassword) {
        boolean successfullySetSocketFactory = true;
        try {
            KeyStore trustStore = HttpClientManager.getAndroidCATrustStore();
            if (trustStore == null) {
                return !successfullySetSocketFactory;
            }
            SSLSocketFactory userCertificateSocketFactory = new SSLSocketFactory(keyStore, new String(keyStorePassword), trustStore);
            if (instance != null && HttpClientManager.instance.httpClient != null) {
                HttpClientManager.replaceSocketFactory(userCertificateSocketFactory);
            }
            return successfullySetSocketFactory;
        }
        catch (Exception e) {
            return !successfullySetSocketFactory;
        }
    }

    private static void replaceSocketFactory(SSLSocketFactory userCertificateSocketFactory) {
        SchemeRegistry schemeRegistry = HttpClientManager.instance.httpClient.getConnectionManager().getSchemeRegistry();
        String HTTPS_SCHEME_NAME = "https";
        for (String schemeName : schemeRegistry.getSchemeNames()) {
            if (!schemeName.equalsIgnoreCase(HTTPS_SCHEME_NAME)) continue;
            Scheme httpsScheme = schemeRegistry.getScheme(HTTPS_SCHEME_NAME);
            schemeRegistry.unregister(HTTPS_SCHEME_NAME);
            Scheme newScheme = new Scheme(HTTPS_SCHEME_NAME, (SocketFactory)userCertificateSocketFactory, httpsScheme.getDefaultPort());
            schemeRegistry.register(newScheme);
            break;
        }
    }

    private static KeyStore getAndroidCATrustStore() {
        try {
            KeyStore trustStore = KeyStore.getInstance("AndroidCAStore");
            TrustManagerFactory trustManagerFactory = null;
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            return trustStore;
        }
        catch (Throwable t) {
            return null;
        }
    }

    static HttpClientManager getInstance() {
        if (instance == null) {
            throw new IllegalStateException("HttpClientManager should be created first (before calling getInstance");
        }
        return instance;
    }

    public DefaultHttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public String getWebViewUserAgent() {
        return this.webViewUserAgent;
    }

    public static synchronized void createInstance(Context context) {
        if (instance == null) {
            instance = new HttpClientManager(context);
        }
    }

    static {
        logger = Logger.getInstance(HttpClientManager.class.getName());
    }
}

