/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.wlclient;

import com.worklight.wlclient.HttpClientManager;
import com.worklight.wlclient.api.WLErrorCode;
import com.worklight.wlclient.api.WLFailResponse;
import com.worklight.wlclient.api.WLRequestOptions;
import com.worklight.wlclient.api.WLResponse;
import com.worklight.wlclient.api.WLResponseListener;
import java.net.SocketTimeoutException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

class CustomRequestSender
implements Runnable {
    WLResponseListener listener;
    int requestTimeoutInMilliseconds;
    HttpRequestBase httpRequest;

    protected CustomRequestSender(HttpRequestBase httpRequest, int requestTimeoutInMilliseconds, WLResponseListener listener) {
        this.httpRequest = httpRequest;
        this.requestTimeoutInMilliseconds = requestTimeoutInMilliseconds;
        this.listener = listener;
    }

    @Override
    public void run() {
        DefaultHttpClient httpClient = HttpClientManager.getInstance().getHttpClient();
        if (this.requestTimeoutInMilliseconds > 0) {
            HttpConnectionParams.setSoTimeout((HttpParams)httpClient.getParams(), (int)this.requestTimeoutInMilliseconds);
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpClient.getParams(), (int)this.requestTimeoutInMilliseconds);
        }
        WLResponse response = null;
        try {
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)this.httpRequest, HttpClientManager.getInstance().getHttpContext());
            response = new WLResponse(httpResponse);
        }
        catch (SocketTimeoutException e) {
            this.listener.onFailure(new WLFailResponse(WLErrorCode.REQUEST_TIMEOUT, WLErrorCode.REQUEST_TIMEOUT.getDescription(), new WLRequestOptions()));
            return;
        }
        catch (ConnectTimeoutException e) {
            this.listener.onFailure(new WLFailResponse(WLErrorCode.UNRESPONSIVE_HOST, WLErrorCode.UNRESPONSIVE_HOST.getDescription(), new WLRequestOptions()));
            return;
        }
        catch (Exception e) {
            this.listener.onFailure(new WLFailResponse(WLErrorCode.UNEXPECTED_ERROR, WLErrorCode.UNEXPECTED_ERROR.getDescription(), new WLRequestOptions()));
            return;
        }
        this.listener.onSuccess(response);
    }
}

