/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.wlclient;

import com.worklight.common.WLTrusteer;
import com.worklight.wlclient.CustomRequestSender;
import com.worklight.wlclient.HttpPostListener;
import com.worklight.wlclient.HttpPostRequestSender;
import com.worklight.wlclient.WLRequest;
import com.worklight.wlclient.WLRequestSender;
import com.worklight.wlclient.api.WLResponseListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.json.JSONObject;

public class AsynchronousRequestSender {
    private static final ExecutorService pool = Executors.newFixedThreadPool(6);
    private static AsynchronousRequestSender sender = new AsynchronousRequestSender();
    private Map<String, String> globalHeaders = new HashMap<String, String>();

    private AsynchronousRequestSender() {
    }

    public static AsynchronousRequestSender getInstance() {
        return sender;
    }

    public void sendWLRequestAsync(WLRequest request) {
        this.addGlobalHeadersToRequest((HttpRequestBase)request.getPostRequest());
        pool.execute(new WLRequestSender(request));
    }

    public void sendCustomRequestAsync(HttpRequestBase httpRequest, int requestTimeoutInMilliseconds, WLResponseListener listener) {
        this.addGlobalHeadersToRequest(httpRequest);
        pool.execute(new CustomRequestSender(httpRequest, requestTimeoutInMilliseconds, listener));
    }

    public void sendWLHybridRequestAsync(HttpPost httpRequest, int timeoutMs, HttpPostListener listener) {
        this.addGlobalHeadersToRequest((HttpRequestBase)httpRequest);
        pool.execute(new HttpPostRequestSender(httpRequest, timeoutMs, listener));
    }

    public void addGlobalHeader(String headerName, String headerValue) {
        this.globalHeaders.put(headerName, headerValue);
    }

    public String getGlobalHeader(String headerName) {
        return this.globalHeaders.get(headerName);
    }

    public void removeGlobalHeader(String headerName) {
        this.globalHeaders.remove(headerName);
    }

    public Map<String, String> getGlobalHeaders() {
        return this.globalHeaders;
    }

    public void addGlobalHeadersToRequest(HttpRequestBase request) {
        for (Map.Entry<String, String> entry : this.globalHeaders.entrySet()) {
            request.addHeader(entry.getKey(), entry.getValue());
        }
        if (WLTrusteer.hasTrusteerSDK()) {
            JSONObject tas2 = WLTrusteer.getInstance().getRiskAssessment();
            request.addHeader("WL_TAS", tas2.toString());
        }
    }
}

