/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.utils;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Process;
import com.worklight.common.Logger;
import com.worklight.nativeandroid.common.WLUtils;
import com.worklight.wlclient.api.WLClient;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class WLAlertDialog
implements Runnable {
    private static Logger logger = Logger.getInstance("wl.alertDialog");
    private String title;
    private String message;
    private String positiveButtonText;
    private DialogInterface.OnClickListener clickListener;
    public static final DialogInterface.OnClickListener exitListener = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialog, int which) {
            Process.killProcess((int)Process.myPid());
        }
    };

    public WLAlertDialog() {
    }

    public WLAlertDialog(String title, String message) {
        this.init(title, message, "WLClient.close");
    }

    public WLAlertDialog(String title, String message, String positiveButtonText) {
        this.init(title, message, positiveButtonText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String title, String message, String positiveButtonText) {
        try {
            ResourceBundle bundle = WLUtils.getMessagesBundle();
            if (title != null) {
                try {
                    this.title = bundle.getString(title);
                }
                catch (MissingResourceException e) {
                }
                finally {
                    if (this.title == null) {
                        this.title = title;
                    }
                }
            }
            if (message != null) {
                try {
                    this.message = bundle.getString(message);
                }
                catch (MissingResourceException e) {
                }
                finally {
                    if (this.message == null) {
                        this.message = message;
                    }
                }
            }
            try {
                this.positiveButtonText = bundle.getString(positiveButtonText);
            }
            catch (MissingResourceException e) {
            }
            finally {
                if (this.positiveButtonText == null) {
                    this.positiveButtonText = positiveButtonText;
                }
            }
        }
        catch (MissingResourceException e) {
            logger.error(e.getMessage());
        }
    }

    public void show() {
        try {
            Activity context = (Activity)WLClient.getInstance().getContext();
            if (context == null) {
                return;
            }
            context.runOnUiThread((Runnable)this);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    @Override
    public void run() {
        Activity context = (Activity)WLClient.getInstance().getContext();
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)context);
        builder.setMessage((CharSequence)this.message);
        builder.setTitle((CharSequence)this.title);
        builder.setPositiveButton((CharSequence)this.positiveButtonText, this.clickListener);
        builder.show();
    }

    public DialogInterface.OnClickListener getClickListener() {
        return this.clickListener;
    }

    public void setClickListener(DialogInterface.OnClickListener _clickListener) {
        this.clickListener = _clickListener;
    }

    public String getPositiveButtonText() {
        return this.positiveButtonText;
    }

    public void setPositiveButtonText(String _positiveButtonText) {
        this.positiveButtonText = _positiveButtonText;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }
}

