/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.utils;

import android.content.Context;
import com.worklight.common.Logger;
import com.worklight.utils.Base64;
import com.worklight.utils.PaidSecurityUtils;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONArray;
import org.json.JSONException;

public class SecurityUtils {
    public static final String HASH_ALGORITH_SHA1 = "SHA-1";
    public static final String HASH_ALGORITH_MD5 = "MD5";
    private static Logger logger = Logger.getInstance("SecurityUtils");

    public static String hashData(String data, String algorithm) {
        byte[] b = data.getBytes();
        byte[] messageDigest = SecurityUtils.hashData(b, algorithm);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < messageDigest.length; ++i) {
            result.append(Integer.toString((messageDigest[i] & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    public static byte[] hashData(byte[] data, String algorithm) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.reset();
            md.update(data);
            byte[] messageDigest = md.digest();
            return messageDigest;
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(algorithm + " is not supported on this device", e);
            return null;
        }
    }

    public static InputStream decryptData(InputStream encryptedStream, byte[] key) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, skeySpec);
        CipherInputStream decryptedStream = new CipherInputStream(encryptedStream, cipher);
        return decryptedStream;
    }

    public static byte[] kpg(Context context, String[] arr) {
        try {
            return PaidSecurityUtils.kpg(context, arr);
        }
        catch (Throwable e) {
            return new byte[0];
        }
    }

    public static String hashDataFromJSON(Context activity, JSONArray arguments) throws JSONException, UnsupportedEncodingException {
        String[] sArray = ((String)arguments.get(0)).split(",");
        String chall = sArray[0];
        JSONArray jsonArray = (JSONArray)arguments.get(1);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            list.add(jsonArray.getString(i));
        }
        String s = Base64.encode(SecurityUtils.kpg(activity, list.toArray(new String[0])), "UTF-8").replaceAll("\n", "");
        return SecurityUtils.hashData(chall.trim() + s, HASH_ALGORITH_SHA1);
    }

    public static class PBKDF2 {
        public static Key genKey(char[] password, byte[] salt, int iterations, int dkLen) throws NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
            Mac mac = Mac.getInstance("HMACSHA1");
            int hLen = mac.getMacLength();
            int blocks = PBKDF2.ceil(dkLen, hLen);
            int r = dkLen - (blocks - 1) * hLen;
            byte[] dk = new byte[dkLen];
            byte[] pwdBytes = new String(password).getBytes();
            SecretKeySpec keySpec = new SecretKeySpec(pwdBytes, "HmacSHA1");
            mac.init(keySpec);
            for (int i = 1; i <= blocks; ++i) {
                byte[] t = PBKDF2.f(mac, salt, iterations, i);
                int copyLen = hLen;
                if (i == blocks) {
                    copyLen = r;
                }
                System.arraycopy(t, 0, dk, (i - 1) * hLen, copyLen);
            }
            SecretKeySpec key = new SecretKeySpec(dk, "AES");
            return key;
        }

        private static byte[] f(Mac mac, byte[] salt, int iterations, int block) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
            byte[] result = new byte[mac.getMacLength()];
            byte[] text = PBKDF2.concat(salt, PBKDF2.encodedInt(block));
            for (int i = 1; i <= iterations; ++i) {
                byte[] u = mac.doFinal(text);
                result = PBKDF2.xor(result, u);
                text = u;
            }
            return result;
        }

        private static byte[] xor(byte[] result, byte[] ba2) {
            for (int i = 0; i < result.length; ++i) {
                result[i] = (byte)((result[i] ^ ba2[i]) & 0xFF);
            }
            return result;
        }

        private static byte[] concat(byte[] ba1, byte[] ba2) {
            int length = ba1.length + ba2.length;
            byte[] ba = new byte[length];
            System.arraycopy(ba1, 0, ba, 0, ba1.length);
            System.arraycopy(ba2, 0, ba, ba1.length, ba2.length);
            return ba;
        }

        private static int ceil(int dkLen, int hLen) {
            int len = dkLen / hLen;
            if (dkLen % hLen != 0) {
                ++len;
            }
            return len;
        }

        private static byte[] encodedInt(int i) {
            byte[] encoded = new byte[]{(byte)((i & 0xFF000000) >>> 24), (byte)((i & 0xFF0000) >>> 16), (byte)((i & 0xFF00) >>> 8), (byte)(i & 0xFF)};
            return encoded;
        }
    }
}

