/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.utils;

import android.content.res.AssetManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Vector;

public class MultifileAssetStream
extends SequenceInputStream {
    public MultifileAssetStream(String base_asset_name, AssetManager asset_manager) throws IOException {
        super(MultifileAssetStream.getAssetFileStreams(base_asset_name, asset_manager).elements());
    }

    private static InputStream getFileInputStream(String file, AssetManager asset_manager) {
        try {
            return asset_manager.open(file);
        }
        catch (IOException er) {
            return null;
        }
    }

    private static Vector<InputStream> getAssetFileStreams(String base_asset_name, AssetManager asset_manager) throws IOException {
        boolean keepSearching = true;
        int currentFile = 1;
        Vector<InputStream> inputStreamsOfSplitFiles = new Vector<InputStream>();
        while (keepSearching) {
            InputStream openAttempt = MultifileAssetStream.getFileInputStream(MultifileAssetStream.getAssetFileName(base_asset_name, currentFile), asset_manager);
            if (currentFile == 0 && openAttempt == null) {
                openAttempt = MultifileAssetStream.getFileInputStream(base_asset_name, asset_manager);
            }
            if (openAttempt != null) {
                inputStreamsOfSplitFiles.add(openAttempt);
                ++currentFile;
                continue;
            }
            keepSearching = false;
        }
        if (inputStreamsOfSplitFiles.size() == 0) {
            throw new IOException("Unable to open any files with that base name");
        }
        return inputStreamsOfSplitFiles;
    }

    private static String getAssetFileName(String base, int chunk_num) {
        return base + "." + String.format("%03d", chunk_num);
    }
}

