/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.utils;

import java.io.UnsupportedEncodingException;

public class Base64 {
    private static final byte[] map = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};

    public static byte[] decode(byte[] in) {
        return Base64.decode(in, in.length);
    }

    public static byte[] decode(byte[] in, int len) {
        byte chr;
        int length = len / 4 * 3;
        if (length == 0) {
            return new byte[0];
        }
        byte[] out = new byte[length];
        int pad = 0;
        while (true) {
            if ((chr = in[len - 1]) != 10 && chr != 13 && chr != 32 && chr != 9) {
                if (chr != 61) break;
                ++pad;
            }
            --len;
        }
        int out_index = 0;
        int in_index = 0;
        int bits = 0;
        int quantum = 0;
        for (int i = 0; i < len; ++i) {
            chr = in[i];
            if (chr == 10 || chr == 13 || chr == 32 || chr == 9) continue;
            if (chr >= 65 && chr <= 90) {
                bits = chr - 65;
            } else if (chr >= 97 && chr <= 122) {
                bits = chr - 71;
            } else if (chr >= 48 && chr <= 57) {
                bits = chr + 4;
            } else if (chr == 43) {
                bits = 62;
            } else if (chr == 47) {
                bits = 63;
            } else {
                return null;
            }
            quantum = quantum << 6 | (byte)bits;
            if (in_index % 4 == 3) {
                out[out_index++] = (byte)((quantum & 0xFF0000) >> 16);
                out[out_index++] = (byte)((quantum & 0xFF00) >> 8);
                out[out_index++] = (byte)(quantum & 0xFF);
            }
            ++in_index;
        }
        if (pad > 0) {
            out[out_index++] = (byte)(((quantum <<= 6 * pad) & 0xFF0000) >> 16);
            if (pad == 1) {
                out[out_index++] = (byte)((quantum & 0xFF00) >> 8);
            }
        }
        byte[] result = new byte[out_index];
        System.arraycopy(out, 0, result, 0, out_index);
        return result;
    }

    public static String encode(byte[] in, String charsetName) throws UnsupportedEncodingException {
        int length = in.length * 4 / 3;
        length += length / 76 + 3;
        byte[] out = new byte[length];
        int index = 0;
        int crlr = 0;
        int end = in.length - in.length % 3;
        for (int i = 0; i < end; i += 3) {
            out[index++] = map[(in[i] & 0xFF) >> 2];
            out[index++] = map[(in[i] & 3) << 4 | (in[i + 1] & 0xFF) >> 4];
            out[index++] = map[(in[i + 1] & 0xF) << 2 | (in[i + 2] & 0xFF) >> 6];
            out[index++] = map[in[i + 2] & 0x3F];
            if ((index - crlr) % 76 == 0 && index == 0) continue;
        }
        switch (in.length % 3) {
            case 1: {
                out[index++] = map[(in[end] & 0xFF) >> 2];
                out[index++] = map[(in[end] & 3) << 4];
                out[index++] = 61;
                out[index++] = 61;
                break;
            }
            case 2: {
                out[index++] = map[(in[end] & 0xFF) >> 2];
                out[index++] = map[(in[end] & 3) << 4 | (in[end + 1] & 0xFF) >> 4];
                out[index++] = map[(in[end + 1] & 0xF) << 2];
                out[index++] = 61;
            }
        }
        return new String(out, 0, index, charsetName);
    }

    public static String encodeUrlSafe(byte[] in, String charsetName) throws UnsupportedEncodingException {
        String regEncoded = Base64.encode(in, charsetName);
        return regEncoded.replace('+', '-').replace('/', '_');
    }
}

