/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.nativeandroid.common;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Environment;
import android.os.StatFs;
import com.worklight.common.Logger;
import com.worklight.common.NoSuchResourceException;
import com.worklight.common.WLConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WLUtils {
    private static final Logger logger = Logger.getInstance(WLUtils.class.getName());
    public static final String LOG_CAT = "WL";
    public static final int ANDROID_BUFFER_8K = 8192;
    public static final String WL_PREFS = "WLPrefs";
    public static final String WL_CHALLENGE_DATA = "WL-Challenge-Data";
    public static final String WL_CHALLENGE_RESPONSE_DATA = "WL-Challenge-Response-Data";
    public static final String WL_INSTANCE_AUTH_ID = "WL-Instance-Id";
    public static final String WWW = "www";
    public static final String BUNDLE_BASENAME = "com.worklight.wlclient.messages";
    public static final String BUNDLE_RESOURCE = "/com/worklight/wlclient/messages";
    private static HashSet<String> LOADED_LIBS = new HashSet();
    private static ResourceBundle bundle;

    public static Drawable scaleImage(Drawable drawable, float scaleWidth, float scaleHeight) {
        BitmapDrawable resizedDrawable = null;
        if (drawable != null) {
            Bitmap bitmapOrg = ((BitmapDrawable)drawable).getBitmap();
            int width = bitmapOrg.getWidth();
            int height = bitmapOrg.getHeight();
            Matrix matrix = new Matrix();
            matrix.postScale(scaleWidth, scaleHeight);
            Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)bitmapOrg, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
            resizedDrawable = new BitmapDrawable(resizedBitmap);
        }
        return resizedDrawable;
    }

    public static int getResourceId(Context context, String resourceCategory, String resourceName) throws NoSuchResourceException {
        int resourceId = -1;
        try {
            Class<?>[] classes = Class.forName(context.getPackageName() + ".R").getDeclaredClasses();
            for (int i = 0; i < classes.length; ++i) {
                if (!classes[i].getSimpleName().equals(resourceCategory)) continue;
                resourceId = classes[i].getField(resourceName).getInt(null);
                break;
            }
        }
        catch (Exception e) {
            throw new NoSuchResourceException("Failed to find resource R." + resourceCategory + "." + resourceName, e);
        }
        return resourceId;
    }

    public static String getResourceString(String recourceName, Context context) {
        return WLUtils.getResourceString(recourceName, null, context);
    }

    public static String getResourceString(String recourceName, String argument, Context context) {
        Class<?> rStringClass = null;
        try {
            if (rStringClass == null) {
                rStringClass = Class.forName(context.getPackageName() + ".R$string");
            }
            Integer resourceId = (Integer)rStringClass.getDeclaredField(recourceName).get(null);
            if (argument == null) {
                return context.getResources().getString(resourceId.intValue());
            }
            return context.getResources().getString(resourceId.intValue(), new Object[]{argument});
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            return "";
        }
    }

    public static long getFreeSpaceOnDevice() {
        File path = Environment.getDataDirectory();
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSize();
        long availableBlocks = stat.getAvailableBlocks();
        long availableStorageInBytes = blockSize * availableBlocks;
        return availableStorageInBytes;
    }

    public static void copyFile(File in, File out) throws IOException {
        FileInputStream fis = new FileInputStream(in);
        if (!out.exists()) {
            if (in.isDirectory()) {
                out.mkdirs();
            } else {
                File parentDir = new File(out.getParent());
                if (!parentDir.exists()) {
                    parentDir.mkdirs();
                }
                out.createNewFile();
            }
        }
        FileOutputStream fos = new FileOutputStream(out);
        try {
            byte[] buf = new byte[8192];
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            fis.close();
            fos.close();
        }
    }

    public static void copyFile(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
        out.flush();
    }

    public static boolean deleteDirectory(File fileOrDirectory) {
        if (fileOrDirectory.isDirectory()) {
            for (File child : fileOrDirectory.listFiles()) {
                WLUtils.deleteDirectory(child);
            }
        }
        return fileOrDirectory.delete();
    }

    public static void calculateCheckSum(InputStream ios, Checksum checksum) {
        byte[] buffer = new byte[8192];
        int bytesRead = 0;
        try {
            while ((bytesRead = ios.read(buffer)) != -1) {
                checksum.update(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            String errorMsg = "An error occurred while trying to read checksum from assets folder";
            logger.error(errorMsg, e);
            throw new RuntimeException(errorMsg);
        }
        finally {
            try {
                if (ios != null) {
                    ios.close();
                }
            }
            catch (IOException e) {
                logger.debug("Problem while trying to close InputStream", e);
            }
        }
    }

    public static long computeChecksumOnExternal(String targetDir) {
        File targetFile = new File(targetDir);
        List<File> files = WLUtils.getTree(targetFile);
        Collections.sort(files);
        CRC32 checksum = new CRC32();
        for (File file : files) {
            try {
                WLUtils.calculateCheckSum(new FileInputStream(file), checksum);
            }
            catch (IOException e) {
                logger.error("Application failed to load, because checksum was not calculated for file " + file.getName() + " with " + e.getMessage(), e);
            }
        }
        return checksum.getValue();
    }

    public static String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reding input stream (" + is + ").", e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.debug("Failed to close input stream because " + e.getMessage(), e);
            }
        }
        return sb.toString();
    }

    public static String convertGZIPStreamToString(InputStream is) {
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            GZIPInputStream gzipInputStream = new GZIPInputStream(is);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)gzipInputStream, Charset.forName("UTF-8")));
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reding input stream (" + is + ").", e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.debug("Failed to close input stream because " + e.getMessage(), e);
            }
        }
        return sb.toString();
    }

    public static void showDialog(Context context, String title, String message, String buttonText) {
        WLUtils.showDialog(context, title, message, buttonText, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
    }

    public static void showDialog(final Context context, final String title, final String message, final String buttonText, final DialogInterface.OnClickListener buttonClickListener) {
        ((Activity)context).runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AlertDialog.Builder dlg = new AlertDialog.Builder(context);
                dlg.setTitle((CharSequence)title);
                dlg.setMessage((CharSequence)message);
                dlg.setCancelable(false);
                dlg.setPositiveButton((CharSequence)buttonText, buttonClickListener);
                dlg.create();
                dlg.show();
            }
        });
    }

    public static void unpack(InputStream in, File targetDir) throws IOException {
        ZipEntry entry;
        ZipInputStream zin = new ZipInputStream(in);
        while ((entry = zin.getNextEntry()) != null) {
            String extractFilePath = entry.getName();
            if (extractFilePath.startsWith("/") || extractFilePath.startsWith("\\")) {
                extractFilePath = extractFilePath.substring(1);
            }
            File extractFile = new File(targetDir.getPath() + File.separator + extractFilePath);
            if (entry.isDirectory()) {
                if (extractFile.exists()) continue;
                extractFile.mkdirs();
                continue;
            }
            File parent = extractFile.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            FileOutputStream os = new FileOutputStream(extractFile);
            WLUtils.copyFile(zin, os);
            os.flush();
            os.close();
        }
    }

    public static List<File> getTree(File rootDir) {
        ArrayList<File> files = new ArrayList<File>();
        return WLUtils.getTree(rootDir, files);
    }

    private static List<File> getTree(File rootDir, List<File> files) {
        File[] filesToIterate;
        for (File file : filesToIterate = rootDir.listFiles()) {
            if (file.isDirectory()) {
                WLUtils.getTree(file, files);
                continue;
            }
            files.add(file);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(File file) throws IOException {
        byte[] buffer = new byte[(int)file.length()];
        FileInputStream ios = null;
        try {
            ios = new FileInputStream(file);
            if (((InputStream)ios).read(buffer) == -1) {
                throw new IOException("EOF reached while trying to read the whole file");
            }
        }
        finally {
            try {
                if (ios != null) {
                    ((InputStream)ios).close();
                }
            }
            catch (IOException iOException) {}
        }
        return buffer;
    }

    public static String getFullAppName(Context context) {
        return context.getPackageName() + "." + context.getString(WLUtils.getResourceId(context, "string", "app_name"));
    }

    public static final JSONObject convertStringToJSON(String jsonString) throws JSONException {
        int beginIndex = jsonString.indexOf("{");
        int endIndex = jsonString.lastIndexOf("}");
        if (beginIndex == -1 || endIndex == -1 || beginIndex > endIndex + 1) {
            String message = "Input string does not contain brackets, or input string is invalid. The string is: " + jsonString;
            logger.debug(message);
            throw new JSONException(message);
        }
        String secureJSONString = jsonString.substring(beginIndex, endIndex + 1);
        JSONObject jsonObject = new JSONObject(secureJSONString);
        return jsonObject;
    }

    public static final List<String> convertJSONArrayToList(JSONArray jsonArray) {
        ArrayList<String> listToReturn = new ArrayList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            try {
                listToReturn.add((String)jsonArray.get(i));
                continue;
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        return listToReturn;
    }

    public static final boolean isStringEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static final byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static final String byteArrayToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        Formatter formatter = new Formatter(sb);
        for (byte b : bytes) {
            formatter.format("%02x", b);
        }
        formatter.close();
        return sb.toString();
    }

    public static final synchronized void loadLib(Context ctx, String library) {
        if (!LOADED_LIBS.contains(library)) {
            String ARMEABI = "armeabi";
            String X86 = "x86";
            String arch = System.getProperty("os.arch");
            String nonArch = null;
            if (arch != null && arch.toLowerCase().startsWith("i")) {
                arch = "x86";
                nonArch = "armeabi";
            } else {
                arch = "armeabi";
                nonArch = "x86";
            }
            String libPath = "featurelibs" + File.separator + arch + File.separator + library;
            File sourceLocation = new File(ctx.getFilesDir(), libPath + ".zip");
            File nonArchStorage = new File(ctx.getFilesDir(), "featurelibs" + File.separator + nonArch);
            WLUtils.deleteDirectory(nonArchStorage);
            File targetFile = new File(ctx.getFilesDir(), library);
            targetFile.delete();
            logger.debug("Extracting zip file: " + libPath);
            try {
                InputStream istr = ctx.getAssets().open(libPath + ".zip");
                WLUtils.unpack(istr, targetFile.getParentFile());
            }
            catch (IOException e) {
                // empty catch block
            }
            logger.debug("Loading library using System.load: " + targetFile.getAbsolutePath());
            sourceLocation.delete();
            System.load(targetFile.getAbsolutePath());
            LOADED_LIBS.add(library);
        }
    }

    public static synchronized ResourceBundle getMessagesBundle() {
        if (bundle != null) {
            return bundle;
        }
        String languagePrefs = WLConfig.getInstance().getLanguagePreferences();
        try {
            if (languagePrefs != null && languagePrefs.length() > 0) {
                Locale locale = Locale.getDefault();
                String lang = locale.getLanguage();
                String region = locale.getCountry();
                if (lang.isEmpty()) {
                    bundle = ResourceBundle.getBundle(BUNDLE_BASENAME, Locale.getDefault());
                    return bundle;
                }
                String deviceLocale = lang + (region.isEmpty() ? "" : "-" + region);
                String[] languagePrefsOrder = languagePrefs.split(",");
                for (int i = 0; i < languagePrefsOrder.length; ++i) {
                    languagePrefsOrder[i] = languagePrefsOrder[i].trim();
                }
                for (String pref : languagePrefsOrder) {
                    if (!deviceLocale.equals(pref) || (bundle = WLUtils.getBundle(lang, region, true)) == null) continue;
                    return bundle;
                }
                if (!region.isEmpty()) {
                    for (String pref : languagePrefsOrder) {
                        if (!lang.equals(pref) || (bundle = WLUtils.getBundle(lang, null, true)) == null) continue;
                        return bundle;
                    }
                }
                for (String pref : languagePrefsOrder) {
                    String tempLang;
                    String tempRegion = null;
                    if (pref.length() > 2) {
                        tempLang = pref.substring(0, 2);
                        tempRegion = pref.substring(3, 2);
                    } else {
                        tempLang = pref;
                    }
                    bundle = WLUtils.getBundle(tempLang, tempRegion, true);
                    if (bundle == null) continue;
                    return bundle;
                }
                bundle = WLUtils.getBundle("en", null, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bundle == null) {
            bundle = WLUtils.getBundle(null, null, false);
        }
        return bundle;
    }

    private static ResourceBundle getBundle(String lang, String region, boolean isStrict) {
        URL url;
        if (lang == null) {
            return ResourceBundle.getBundle(BUNDLE_BASENAME, Locale.getDefault());
        }
        if (region == null) {
            if (isStrict) {
                if ("en".equals(lang)) {
                    return ResourceBundle.getBundle(BUNDLE_BASENAME, new Locale(""));
                }
                URL url2 = WLUtils.class.getResource("/com/worklight/wlclient/messages_" + lang + ".properties");
                if (url2 == null) {
                    return null;
                }
            }
            return ResourceBundle.getBundle(BUNDLE_BASENAME, new Locale(lang));
        }
        if (isStrict && (url = WLUtils.class.getResource("/com/worklight/wlclient/messages_" + lang + "_" + region + ".properties")) == null) {
            return null;
        }
        return ResourceBundle.getBundle(BUNDLE_BASENAME, new Locale(lang, region));
    }
}

