/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.wifi.triggers;

import com.worklight.location.api.WLConfidenceLevel;
import com.worklight.location.api.wifi.WLWifiAccessPointFilter;
import com.worklight.location.api.wifi.WLWifiAcquisitionPolicy;
import com.worklight.location.api.wifi.triggers.WLWifiTrigger;
import com.worklight.location.internal.wifi.triggers.AbstractWifiFilterTrigger;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractWifiAreaTrigger
extends WLWifiTrigger {
    private List<WLWifiAccessPointFilter> areaAccessPoints = new ArrayList<WLWifiAccessPointFilter>();
    private boolean otherAccessPointsAllowed = false;
    private WLConfidenceLevel confidenceLevel = WLConfidenceLevel.LOW;

    @Override
    public boolean validate(WLWifiAcquisitionPolicy policy) {
        for (WLWifiAccessPointFilter areaFilter : this.areaAccessPoints) {
            if (AbstractWifiFilterTrigger.doesPolicyIntersectWithFilter(policy, areaFilter)) continue;
            return false;
        }
        return true;
    }

    public List<WLWifiAccessPointFilter> getAreaAccessPoints() {
        return this.areaAccessPoints;
    }

    public WLConfidenceLevel getConfidenceLevel() {
        return this.confidenceLevel;
    }

    public boolean areOtherAccessPointsAllowed() {
        return this.otherAccessPointsAllowed;
    }

    public AbstractWifiAreaTrigger setAreaAccessPoints(List<WLWifiAccessPointFilter> areaAccessPoints) {
        this.areaAccessPoints = areaAccessPoints == null ? new ArrayList() : areaAccessPoints;
        return this;
    }

    public AbstractWifiAreaTrigger setOtherAccessPointsAllowed(boolean otherAccessPointsAllowed) {
        this.otherAccessPointsAllowed = otherAccessPointsAllowed;
        return this;
    }

    public AbstractWifiAreaTrigger setConfidenceLevel(WLConfidenceLevel confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
        return this;
    }
}

