/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.wifi.triggerEvaluators;

import com.worklight.location.api.wifi.WLWifiAccessPoint;
import com.worklight.location.api.wifi.WLWifiLocation;
import com.worklight.location.internal.AbstractPosition;
import com.worklight.location.internal.wifi.WifiInternalAccessPoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class WifiInternalLocation
extends AbstractPosition {
    private final List<WifiInternalAccessPoint> accessPoints;
    private final WLWifiAccessPoint connectedAccessPoint;
    private final Integer connectedSignalStrength;

    public WifiInternalLocation(Collection<WifiInternalAccessPoint> accessPoints, WLWifiAccessPoint connectedAccessPoint, Integer connectedSignalStrength, long acquisitionTime) {
        super(acquisitionTime);
        this.accessPoints = new ArrayList<WifiInternalAccessPoint>(accessPoints);
        this.connectedAccessPoint = connectedAccessPoint;
        this.connectedSignalStrength = connectedSignalStrength;
    }

    public WLWifiLocation getPublicVersion() {
        ArrayList<WLWifiAccessPoint> points = new ArrayList<WLWifiAccessPoint>();
        for (WifiInternalAccessPoint ap : this.accessPoints) {
            points.add(ap.getPublicVersion());
        }
        return new WLWifiLocation(points, this.connectedAccessPoint, this.connectedSignalStrength, super.getTimestamp());
    }

    public List<WifiInternalAccessPoint> getAccessPoints() {
        return this.accessPoints;
    }

    public WLWifiAccessPoint getConnectedAccessPoint() {
        return this.connectedAccessPoint;
    }

    public Integer getConnectedSignalStrength() {
        return this.connectedSignalStrength;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.accessPoints == null ? 0 : ((Object)this.accessPoints).hashCode());
        result = 31 * result + (this.connectedAccessPoint == null ? 0 : this.connectedAccessPoint.hashCode());
        result = 31 * result + (this.connectedSignalStrength == null ? 0 : this.connectedSignalStrength.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WifiInternalLocation other = (WifiInternalLocation)obj;
        if (this.accessPoints == null ? other.accessPoints != null : !((Object)this.accessPoints).equals(other.accessPoints)) {
            return false;
        }
        if (this.connectedAccessPoint == null ? other.connectedAccessPoint != null : !this.connectedAccessPoint.equals(other.connectedAccessPoint)) {
            return false;
        }
        return !(this.connectedSignalStrength == null ? other.connectedSignalStrength != null : !this.connectedSignalStrength.equals(other.connectedSignalStrength));
    }
}

