/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.wifi.triggerEvaluators;

import com.worklight.location.internal.wifi.triggerEvaluators.WifiAreaTriggerEvaluator;
import com.worklight.location.internal.wifi.triggerEvaluators.WifiInternalLocation;
import com.worklight.location.internal.wifi.triggers.AbstractWifiDwellTrigger;

public abstract class WifiDwellingTrigger
extends WifiAreaTriggerEvaluator {
    private final boolean shouldBeInside;
    private Long startDwellingTime = null;
    private boolean alreadyEvaluatedAsDwelling = false;

    protected WifiDwellingTrigger(AbstractWifiDwellTrigger triggerDef, boolean shouldBeInside, boolean considerStrength) {
        super(triggerDef, considerStrength);
        this.shouldBeInside = shouldBeInside;
    }

    @Override
    public AbstractWifiDwellTrigger getTriggerDefinition() {
        return (AbstractWifiDwellTrigger)super.getTriggerDefinition();
    }

    @Override
    public boolean evaluate(WifiInternalLocation position) {
        this.updatePosition(position);
        if (this.startDwellingTime == null) {
            this.startDwellingTime = this.isInside() == this.shouldBeInside ? position.getTimestamp() : null;
            this.alreadyEvaluatedAsDwelling = false;
        } else if (this.isInside() != this.shouldBeInside) {
            this.startDwellingTime = null;
        } else if (!this.alreadyEvaluatedAsDwelling && this.isInside() == this.shouldBeInside && position.getTimestamp() - this.startDwellingTime >= this.getTriggerDefinition().getDwellingTime()) {
            this.alreadyEvaluatedAsDwelling = true;
            return true;
        }
        return false;
    }
}

