/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.wifi.triggerEvaluators;

import com.worklight.location.api.WLConfidenceLevel;
import com.worklight.location.api.wifi.WLWifiAccessPointFilter;
import com.worklight.location.internal.wifi.WifiInternalAccessPoint;
import com.worklight.location.internal.wifi.triggerEvaluators.WifiInternalLocation;
import com.worklight.location.internal.wifi.triggerEvaluators.WifiTriggerEvaluator;
import com.worklight.location.internal.wifi.triggers.AbstractWifiAreaTrigger;
import java.util.List;

abstract class WifiAreaTriggerEvaluator
extends WifiTriggerEvaluator {
    private boolean isInside;
    private final boolean considerStrength;
    private static final int MEDIUM_CONFIDENCE = 50;
    private static final int HIGH_CONFIDENCE = 80;

    public WifiAreaTriggerEvaluator(AbstractWifiAreaTrigger triggerDef, boolean considerStrength) {
        super(triggerDef);
        this.considerStrength = considerStrength;
    }

    @Override
    public AbstractWifiAreaTrigger getTriggerDefinition() {
        return (AbstractWifiAreaTrigger)super.getTriggerDefinition();
    }

    private static boolean matchesPosition(WLWifiAccessPointFilter areaFilter, WifiInternalLocation position, WLConfidenceLevel triggerCondfidenceLevel, boolean checkStrength, boolean isInside) {
        for (WifiInternalAccessPoint ap : position.getAccessPoints()) {
            if (checkStrength && !isInside && (triggerCondfidenceLevel == WLConfidenceLevel.MEDIUM && ap.getStrength() < 50 || triggerCondfidenceLevel == WLConfidenceLevel.HIGH && ap.getStrength() < 80) || !areaFilter.matches(ap)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesArea(WifiInternalAccessPoint ap, List<WLWifiAccessPointFilter> areaFilters) {
        for (WLWifiAccessPointFilter areaFilter : areaFilters) {
            if (!areaFilter.matches(ap)) continue;
            return true;
        }
        return false;
    }

    protected void updatePosition(WifiInternalLocation position) {
        if (position == null) {
            throw new IllegalArgumentException("position is null");
        }
        if (!this.getTriggerDefinition().areOtherAccessPointsAllowed()) {
            for (WifiInternalAccessPoint ap : position.getAccessPoints()) {
                if (WifiAreaTriggerEvaluator.matchesArea(ap, this.getTriggerDefinition().getAreaAccessPoints())) continue;
                this.isInside = false;
                return;
            }
        }
        for (WLWifiAccessPointFilter areaFilter : this.getTriggerDefinition().getAreaAccessPoints()) {
            if (WifiAreaTriggerEvaluator.matchesPosition(areaFilter, position, this.getTriggerDefinition().getConfidenceLevel(), this.considerStrength, this.isInside)) continue;
            this.isInside = false;
            return;
        }
        this.isInside = true;
    }

    protected boolean isInside() {
        return this.isInside;
    }
}

