/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.wifi.nativeImpl;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import com.worklight.location.api.wifi.WLWifiError;
import com.worklight.location.internal.wifi.IWifiScannerReceiver;
import com.worklight.location.internal.wifi.WifiException;
import com.worklight.location.internal.wifi.WifiInternalAccessPoint;
import com.worklight.location.internal.wifi.WifiScanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AndroidWifiScanner
implements WifiScanner {
    private final Context context;
    private final WifiManager wifiManager;

    public AndroidWifiScanner(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        this.context = context;
        this.wifiManager = (WifiManager)context.getSystemService("wifi");
    }

    @Override
    public void scan(final IWifiScannerReceiver r) throws WifiException {
        if (r == null) {
            throw new IllegalArgumentException("r is null");
        }
        try {
            this.context.registerReceiver(new BroadcastReceiver(){

                public void onReceive(Context ctx, Intent intent) {
                    ctx.unregisterReceiver((BroadcastReceiver)this);
                    List results = AndroidWifiScanner.this.wifiManager.getScanResults();
                    long acqTime = System.currentTimeMillis();
                    try {
                        if (!results.isEmpty()) {
                            acqTime = ((ScanResult)results.iterator().next()).timestamp;
                        }
                    }
                    catch (NoSuchFieldError e) {
                        // empty catch block
                    }
                    r.onScanResults(AndroidWifiScanner.this.resultToAccessPoints(results), acqTime);
                }
            }, new IntentFilter("android.net.wifi.SCAN_RESULTS"));
            if (!this.wifiManager.isWifiEnabled()) {
                throw new WifiException(WLWifiError.WLWifiErrorCodes.DISABLED);
            }
            if (!this.wifiManager.startScan()) {
                throw new WifiException(WLWifiError.WLWifiErrorCodes.FAILED_START_SCAN);
            }
        }
        catch (SecurityException e) {
            throw new WifiException(WLWifiError.WLWifiErrorCodes.PERMISSION);
        }
    }

    private WifiInternalAccessPoint getCurrentSsid() {
        String ssid = null;
        String mac = null;
        ConnectivityManager connManager = (ConnectivityManager)this.context.getSystemService("connectivity");
        NetworkInfo networkInfo = connManager.getNetworkInfo(1);
        if (!networkInfo.isConnected()) {
            return null;
        }
        WifiInfo connectionInfo = this.wifiManager.getConnectionInfo();
        if (connectionInfo == null || connectionInfo.getSSID().equals("")) {
            return null;
        }
        ssid = connectionInfo.getSSID();
        if (0 == ssid.indexOf("\"")) {
            ssid = ssid.substring(1, ssid.length() - 1);
        }
        mac = connectionInfo.getBSSID();
        return new WifiInternalAccessPoint(ssid, mac, 100, true);
    }

    private Collection<WifiInternalAccessPoint> resultToAccessPoints(Iterable<ScanResult> scans) {
        WifiInternalAccessPoint currentNetwork = this.getCurrentSsid();
        ArrayList<WifiInternalAccessPoint> result = new ArrayList<WifiInternalAccessPoint>();
        for (ScanResult scan : scans) {
            boolean isConnected = currentNetwork != null && currentNetwork.getSSID().equals(scan.SSID) && currentNetwork.getMAC().equals(scan.BSSID);
            result.add(new WifiInternalAccessPoint(scan.SSID, scan.BSSID, AndroidWifiScanner.getStrength(scan), isConnected));
        }
        return result;
    }

    private static int getStrength(ScanResult sr) {
        if (sr.getClass() != ScanResult.class) {
            return sr.level;
        }
        return AndroidWifiScanner.getStrength(sr.level);
    }

    private static int getStrength(int srLevel) {
        int MIN_RSSI = -100;
        int MAX_RSSI = -55;
        int levels = 101;
        if (Build.VERSION.SDK_INT >= 14) {
            return WifiManager.calculateSignalLevel((int)srLevel, (int)levels);
        }
        if (srLevel <= MIN_RSSI) {
            return 0;
        }
        if (srLevel >= MAX_RSSI) {
            return levels - 1;
        }
        float inputRange = MAX_RSSI - MIN_RSSI;
        float outputRange = levels - 1;
        return (int)((float)(srLevel - MIN_RSSI) * outputRange / inputRange);
    }

    private static boolean isEmulator() {
        return Build.PRODUCT.equals("sdk_x86") || Build.PRODUCT.equals("google_sdk") || Build.PRODUCT.equals("sdk");
    }
}

