/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.wifi;

import com.worklight.location.api.wifi.WLWifiAccessPoint;
import com.worklight.location.api.wifi.WLWifiAcquisitionPolicy;
import com.worklight.location.internal.wifi.IWifiScannerReceiver;
import com.worklight.location.internal.wifi.WifiInternalAccessPoint;
import com.worklight.location.internal.wifi.WifiInternalCallback;
import com.worklight.location.internal.wifi.WifiPolicyFilterer;
import com.worklight.location.internal.wifi.triggerEvaluators.WifiInternalLocation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

final class WifiScannerReceiver
implements IWifiScannerReceiver {
    private final WifiInternalCallback success;
    private final WifiPolicyFilterer filterer;

    WifiScannerReceiver(WifiInternalCallback success, WLWifiAcquisitionPolicy policy) {
        this.success = success;
        this.filterer = policy == null ? null : new WifiPolicyFilterer(policy);
    }

    @Override
    public void onScanResults(Collection<WifiInternalAccessPoint> scans, long acquisitionTime) {
        HashSet<WifiInternalAccessPoint> results = new HashSet<WifiInternalAccessPoint>();
        WLWifiAccessPoint connectedAccessPoint = null;
        Integer connectedSignalStrength = null;
        if (this.filterer == null) {
            for (WifiInternalAccessPoint ap : scans) {
                if (!ap.isConnected()) continue;
                connectedAccessPoint = ap.getPublicVersion();
                connectedSignalStrength = ap.getStrength();
                results.add(ap);
            }
            if (this.success != null) {
                this.success.execute(new WifiInternalLocation(results, connectedAccessPoint, connectedSignalStrength, acquisitionTime));
            }
            return;
        }
        HashMap<String, WifiInternalAccessPoint> preliminaryResults = new HashMap<String, WifiInternalAccessPoint>();
        for (WifiInternalAccessPoint ap : scans) {
            WLWifiAccessPoint accessPoint;
            if (this.filterer.matchesWithSpecifiedMac(ap)) {
                accessPoint = ap.getPublicVersion();
                results.add(ap);
                if (!ap.isConnected()) continue;
                connectedAccessPoint = accessPoint;
                connectedSignalStrength = ap.getStrength();
                continue;
            }
            if (!this.filterer.matches(ap)) continue;
            accessPoint = ap.getPublicVersionNoMAC();
            WifiInternalAccessPoint intermediateAP = new WifiInternalAccessPoint(ap.getSSID(), null, ap.getStrength(), ap.isConnected());
            if (!preliminaryResults.containsKey(ap.getSSID()) || preliminaryResults.containsKey(ap.getSSID()) && ((WifiInternalAccessPoint)preliminaryResults.get(ap.getSSID())).getStrength() < ap.getStrength()) {
                preliminaryResults.put(ap.getSSID(), intermediateAP);
            }
            if (!ap.isConnected()) continue;
            connectedAccessPoint = accessPoint;
            connectedSignalStrength = ap.getStrength();
        }
        results.addAll(preliminaryResults.values());
        if (this.success != null) {
            this.success.execute(new WifiInternalLocation(results, connectedAccessPoint, connectedSignalStrength, acquisitionTime));
        }
    }
}

