/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.wifi;

import com.worklight.location.api.wifi.WLWifiAccessPointFilter;
import com.worklight.location.api.wifi.WLWifiAcquisitionPolicy;
import com.worklight.location.internal.wifi.WifiInternalAccessPoint;

public class WifiPolicyFilterer {
    private final WLWifiAcquisitionPolicy policy;

    public WifiPolicyFilterer(WLWifiAcquisitionPolicy policy) {
        this.policy = policy;
    }

    public WLWifiAcquisitionPolicy getPolicy() {
        return this.policy;
    }

    public boolean matches(WifiInternalAccessPoint point) {
        return this.findMatch(point, false);
    }

    public boolean matchesWithSpecifiedMac(WifiInternalAccessPoint point) {
        return this.findMatch(point, true);
    }

    private boolean findMatch(WifiInternalAccessPoint point, boolean requireMac) {
        if (this.policy == null) {
            return false;
        }
        for (WLWifiAccessPointFilter filter : this.policy.getAccessPointFilters()) {
            if (requireMac && filter.getMac() == null || !filter.matches(point) || !point.isConnected() && point.getStrength() < this.policy.getSignalStrengthThreshold()) continue;
            return true;
        }
        return false;
    }
}

