/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.wifi;

import com.worklight.location.api.wifi.WLWifiError;

public class WifiException
extends Exception {
    private final WLWifiError.WLWifiErrorCodes errorCode;

    public WifiException(WLWifiError.WLWifiErrorCodes errorCode) {
        super(WifiException.getErrorMessage(errorCode));
        this.errorCode = errorCode;
    }

    private static String getErrorMessage(WLWifiError.WLWifiErrorCodes errorCode) {
        switch (errorCode) {
            case DISABLED: {
                return "The WiFi on the device is turned off";
            }
            case FAILED_START_SCAN: {
                return "The device failed to start scanning. It is recommended that you retry after a few seconds";
            }
            case PERMISSION: {
                return "There is a permissions problem.";
            }
        }
        throw new AssertionError((Object)("Invalid enum " + (Object)((Object)errorCode)));
    }

    public WLWifiError.WLWifiErrorCodes getErrorCode() {
        return this.errorCode;
    }
}

