/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.wifi;

import com.worklight.location.api.wifi.WLWifiAccessPointFilter;
import com.worklight.location.api.wifi.WLWifiAcquisitionPolicy;
import com.worklight.location.api.wifi.WLWifiFailureCallback;
import com.worklight.location.internal.wifi.IWifiScannerReceiver;
import com.worklight.location.internal.wifi.MultiWifiScannerReceiver;
import com.worklight.location.internal.wifi.ScannerTimerTask;
import com.worklight.location.internal.wifi.WifiInternalCallback;
import com.worklight.location.internal.wifi.WifiScanner;
import com.worklight.location.internal.wifi.WifiScannerReceiver;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class WifiAcquisitor {
    private final WifiScanner scanner;
    private Timer timer;
    private WifiScannerReceiver intervalReceiver;

    private static void checkParams(WLWifiAcquisitionPolicy policy) {
        if (policy == null) {
            return;
        }
        List<WLWifiAccessPointFilter> filters = policy.getAccessPointFilters();
        if (filters == null || filters.isEmpty()) {
            throw new IllegalArgumentException("policy has no access points defined");
        }
    }

    public WifiAcquisitor(WifiScanner scanner) {
        if (scanner == null) {
            throw new IllegalArgumentException("scanner is null");
        }
        this.scanner = scanner;
    }

    public void startAcquisition(WifiInternalCallback success, WLWifiFailureCallback failure, WLWifiAcquisitionPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("policy is null");
        }
        this.stopAcquisition();
        WifiAcquisitor.checkParams(policy);
        this.scanWifi(success, failure, policy);
    }

    public void acquireLocation(WifiInternalCallback acquireSucess, WLWifiFailureCallback failure, WLWifiAcquisitionPolicy policy) {
        WifiAcquisitor.checkParams(policy);
        WifiScannerReceiver localReceiver = new WifiScannerReceiver(acquireSucess, policy);
        IWifiScannerReceiver receiver = this.intervalReceiver == null ? localReceiver : new MultiWifiScannerReceiver(this.intervalReceiver, localReceiver);
        new Timer("Acquire Wifi Position timer").schedule((TimerTask)new ScannerTimerTask(this.scanner, failure, receiver), 0L);
    }

    public boolean stopAcquisition() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
            this.intervalReceiver = null;
            return true;
        }
        return false;
    }

    private void scanWifi(WifiInternalCallback success, WLWifiFailureCallback failure, WLWifiAcquisitionPolicy policy) {
        this.timer = new Timer("WifiAcquistion Timer");
        this.intervalReceiver = new WifiScannerReceiver(success, policy);
        this.timer.schedule((TimerTask)new ScannerTimerTask(this.scanner, failure, this.intervalReceiver), policy.getInterval(), (long)policy.getInterval());
    }
}

