/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.nativeImpl;

import android.content.Context;
import com.worklight.common.WLConfig;
import com.worklight.location.internal.DeviceImpl;
import com.worklight.location.internal.PiggbackRegisterer;
import com.worklight.location.internal.RuntimeTriggerContainer;
import com.worklight.location.internal.events.EventTransmitter;
import com.worklight.location.internal.events.nativeImpl.FilePersistentStorageManager;
import com.worklight.location.internal.events.server.IWLRequestFactory;
import com.worklight.location.internal.geo.GeoAcquisitor;
import com.worklight.location.internal.geo.nativeImpl.AndroidLocationListenerFactory;
import com.worklight.location.internal.nativeImpl.CallbackExecutor;
import com.worklight.location.internal.wifi.WifiAcquisitor;
import com.worklight.location.internal.wifi.nativeImpl.AndroidWifiScanner;
import com.worklight.wlclient.WLRequest;
import com.worklight.wlclient.WLRequestListener;
import com.worklight.wlclient.api.WLRequestOptions;
import java.io.File;

public class AndroidWLDevice
extends DeviceImpl {
    private static final String EVENTS_DIR_NAME = "__WL_EVENTS";

    private static File getEventsStorageFolder(Context context) {
        return context.getDir(EVENTS_DIR_NAME, 0);
    }

    private static IWLRequestFactory buildFactory(final Context context) {
        return new IWLRequestFactory(){

            @Override
            public WLRequest createWLRequest(WLRequestListener listener, WLRequestOptions options) {
                if (listener == null) {
                    throw new IllegalArgumentException("listener is null");
                }
                if (options == null) {
                    throw new IllegalArgumentException("options is null");
                }
                return new WLRequest(listener, options, WLConfig.getInstance(), context);
            }
        };
    }

    public AndroidWLDevice(Context context) {
        super(new WifiAcquisitor(new AndroidWifiScanner(context)), new GeoAcquisitor(new AndroidLocationListenerFactory(context)), new FilePersistentStorageManager(AndroidWLDevice.getEventsStorageFolder(context), Long.MAX_VALUE), AndroidWLDevice.buildFactory(context), new CallbackExecutor());
    }

    AndroidWLDevice(WifiAcquisitor wifiAcq, GeoAcquisitor geoAcquisitor, RuntimeTriggerContainer rtc, EventTransmitter transmitter, PiggbackRegisterer registerer) {
        super(wifiAcq, geoAcquisitor, rtc, transmitter, registerer, new CallbackExecutor(), null);
    }
}

