/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.nativeImpl;

import android.os.Handler;
import android.os.Looper;
import com.worklight.location.internal.IRunnableExecutor;
import java.util.concurrent.atomic.AtomicBoolean;

public class AndroidRunnableExecutor
implements IRunnableExecutor {
    private Thread t;
    private volatile Handler handler;

    public AndroidRunnableExecutor() {
        this.init();
    }

    private synchronized void init() {
        if (this.t != null && this.t.isAlive()) {
            return;
        }
        this.handler = null;
        this.t = new Thread(new Runnable(){

            @Override
            public void run() {
                Looper.prepare();
                AndroidRunnableExecutor.this.handler = new Handler();
                Looper.loop();
            }
        });
        this.t.setDaemon(true);
        this.t.start();
        while (this.handler == null) {
            Thread.yield();
        }
    }

    @Override
    public synchronized void execute(final Runnable r) {
        this.init();
        final AtomicBoolean ran = new AtomicBoolean();
        this.handler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    r.run();
                }
                finally {
                    AndroidRunnableExecutor androidRunnableExecutor = AndroidRunnableExecutor.this;
                    synchronized (androidRunnableExecutor) {
                        ran.set(true);
                        AndroidRunnableExecutor.this.notifyAll();
                    }
                }
            }
        });
        while (!ran.get()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                if (!Thread.interrupted()) continue;
                return;
            }
        }
    }

    @Override
    public void execute(Runnable r, long delay) {
        this.init();
        this.handler.postDelayed(r, delay);
    }
}

