/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.geo.triggerEvaluators;

import com.worklight.location.api.geo.WLGeoPosition;
import com.worklight.location.api.geo.WLGeoUtils;
import com.worklight.location.api.geo.triggers.WLGeoPositionChangeTrigger;
import com.worklight.location.internal.geo.triggerEvaluators.GeoTriggerEvaluator;

public class GeoPositionChangeTriggerEvaluator
extends GeoTriggerEvaluator {
    private WLGeoPosition previousPosition;

    public GeoPositionChangeTriggerEvaluator(WLGeoPositionChangeTrigger triggerDef) {
        super(triggerDef);
    }

    @Override
    public WLGeoPositionChangeTrigger getTriggerDefinition() {
        return (WLGeoPositionChangeTrigger)super.getTriggerDefinition();
    }

    @Override
    public boolean evaluate(WLGeoPosition position) {
        double sensitivity = this.getTriggerDefinition().getMinChangeDistance();
        if (position == null) {
            throw new IllegalArgumentException("position is null");
        }
        if (this.previousPosition == null) {
            this.previousPosition = position;
            return true;
        }
        if (position.equals(this.previousPosition)) {
            return false;
        }
        double distanceFromPrevPosition = WLGeoUtils.getDistanceBetweenCoordinates(position.getCoordinate(), this.previousPosition.getCoordinate());
        if (distanceFromPrevPosition >= sensitivity) {
            this.previousPosition = position;
            return true;
        }
        return false;
    }
}

