/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.geo.triggerEvaluators;

import com.worklight.location.api.WLDevice;
import com.worklight.location.api.WLLocationServicesConfiguration;
import com.worklight.location.api.geo.WLGeoAcquisitionPolicy;
import com.worklight.location.api.geo.WLGeoFailureCallback;
import com.worklight.location.api.geo.WLGeoPosition;
import com.worklight.location.internal.IRunnableExecutor;
import com.worklight.location.internal.geo.AcquireGeoPositionPseudoTimerTask;
import com.worklight.location.internal.geo.ChainGeoFailureCallback;
import com.worklight.location.internal.geo.triggerEvaluators.GeoAreaTriggerEvaluator;
import com.worklight.location.internal.geo.triggers.AbstractGeoDwellTrigger;
import com.worklight.location.internal.nativeImpl.TimerRunnableExecutor;
import com.worklight.wlclient.api.WLClient;

abstract class GeoDwellTriggerEvaluator
extends GeoAreaTriggerEvaluator {
    private Long startDwellingTime = null;
    private long startCurrentTime;
    private boolean alreadyEvaluatedAsDwelling = false;
    private WLDevice wlDevice = null;
    private WLGeoAcquisitionPolicy policy = null;
    private WLGeoFailureCallback failureCallback = null;
    private AcquireGeoPositionPseudoTimerTask acquirePosTT = null;
    private IRunnableExecutor runnableExec = null;

    protected GeoDwellTriggerEvaluator(AbstractGeoDwellTrigger triggerDef, boolean shouldBeInside) {
        super(triggerDef, shouldBeInside);
        this.wlDevice = WLClient.getInstance().getWLDevice();
        this.runnableExec = new TimerRunnableExecutor();
    }

    protected GeoDwellTriggerEvaluator(AbstractGeoDwellTrigger triggerDef, boolean shouldBeInside, WLDevice wlDevice, WLGeoAcquisitionPolicy policy, WLGeoFailureCallback failureCallback) {
        super(triggerDef, shouldBeInside);
        this.wlDevice = wlDevice;
        this.policy = policy;
        this.failureCallback = failureCallback;
        this.runnableExec = new TimerRunnableExecutor();
    }

    @Override
    public AbstractGeoDwellTrigger getTriggerDefinition() {
        return (AbstractGeoDwellTrigger)super.getTriggerDefinition();
    }

    private boolean isDwelling() {
        return this.shouldBeInside ? this.isInsideArea() : this.isOutsideArea();
    }

    @Override
    public boolean evaluate(WLGeoPosition position) {
        this.updatePosition(position);
        if (this.startDwellingTime == null) {
            this.startDwellingTime = this.isDwelling() ? position.getTimestamp() : null;
            this.startCurrentTime = System.currentTimeMillis();
            this.alreadyEvaluatedAsDwelling = false;
            this.resetTask();
        } else if (!this.isDwelling()) {
            this.startDwellingTime = null;
            this.cancelTask();
        } else if (!this.alreadyEvaluatedAsDwelling && this.isDwelling() && position.getTimestamp() - this.startDwellingTime >= this.getTriggerDefinition().getDwellingTime()) {
            this.alreadyEvaluatedAsDwelling = true;
            this.cancelTask();
            return true;
        }
        return false;
    }

    @Override
    public void notifyOfConfigurationUpdate(WLLocationServicesConfiguration config) {
        super.notifyOfConfigurationUpdate(config);
        this.policy = config.getPolicy().getGeoPolicy().clone();
        this.policy.setMaximumAge(100L);
        this.failureCallback = new ChainGeoFailureCallback(config.getFailureCallbacks());
        this.resetTask();
    }

    @Override
    public void preDestroy() {
        this.cancelTask();
        super.preDestroy();
    }

    private synchronized void resetTask() {
        this.cancelTask();
        if (this.startDwellingTime == null || this.alreadyEvaluatedAsDwelling) {
            return;
        }
        long delay = this.getTriggerDefinition().getDwellingTime() + 100L - (System.currentTimeMillis() - this.startCurrentTime);
        this.acquirePosTT = new AcquireGeoPositionPseudoTimerTask(this.wlDevice, this.failureCallback, this.policy, delay);
        this.runnableExec.execute(this.acquirePosTT, delay);
    }

    private synchronized void cancelTask() {
        if (this.acquirePosTT != null) {
            this.acquirePosTT.cancel();
            this.acquirePosTT = null;
        }
    }
}

