/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.geo.triggerEvaluators;

import com.worklight.location.api.WLConfidenceLevel;
import com.worklight.location.api.geo.WLArea;
import com.worklight.location.api.geo.WLGeoPosition;
import com.worklight.location.api.geo.WLGeoUtils;
import com.worklight.location.internal.geo.triggerEvaluators.GeoTriggerEvaluator;
import com.worklight.location.internal.geo.triggers.AbstractGeoAreaTrigger;

abstract class GeoAreaTriggerEvaluator
extends GeoTriggerEvaluator {
    protected final boolean shouldBeInside;
    private Boolean isInsideArea = null;

    protected GeoAreaTriggerEvaluator(AbstractGeoAreaTrigger triggerDef, boolean shouldBeInside) {
        super(triggerDef);
        this.shouldBeInside = shouldBeInside;
    }

    @Override
    public AbstractGeoAreaTrigger getTriggerDefinition() {
        return (AbstractGeoAreaTrigger)super.getTriggerDefinition();
    }

    protected void updatePosition(WLGeoPosition position) {
        WLArea area = this.getTriggerDefinition().getArea();
        WLConfidenceLevel confidence = this.getTriggerDefinition().getConfidenceLevel();
        double bufferZoneWidth = this.getTriggerDefinition().getBufferZoneWidth();
        boolean isInside = WLGeoUtils.isInsideArea(position.getCoordinate(), area, bufferZoneWidth, this.shouldBeInside ? confidence : WLConfidenceLevel.LOW);
        boolean isOutside = WLGeoUtils.isOutsideArea(position.getCoordinate(), area, bufferZoneWidth, this.shouldBeInside ? WLConfidenceLevel.LOW : confidence);
        if (this.isInsideArea == null) {
            if (isInside) {
                this.isInsideArea = true;
            } else if (isOutside) {
                this.isInsideArea = false;
            }
        } else if (this.isInsideArea.booleanValue()) {
            if (isOutside) {
                this.isInsideArea = false;
            }
        } else if (isInside) {
            this.isInsideArea = true;
        }
    }

    protected boolean isInsideArea() {
        return !this.isInLimbo() && this.isInsideArea != false;
    }

    protected boolean isOutsideArea() {
        return !this.isInLimbo() && this.isInsideArea == false;
    }

    protected boolean isInLimbo() {
        return this.isInsideArea == null;
    }
}

