/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.geo.nativeImpl;

import android.content.Context;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Looper;
import com.worklight.common.Logger;
import com.worklight.location.api.geo.WLCoordinate;
import com.worklight.location.api.geo.WLGeoAcquisitionPolicy;
import com.worklight.location.api.geo.WLGeoError;
import com.worklight.location.api.geo.WLGeoPosition;
import com.worklight.location.internal.geo.LocationHandler;
import com.worklight.location.internal.geo.NativeLocationListener;
import com.worklight.location.internal.nativeImpl.AndroidRunnableExecutor;

public class AndroidLocationListener
implements NativeLocationListener,
LocationListener {
    private static final Logger logger = Logger.getInstance(AndroidLocationListener.class.getName());
    private static AndroidRunnableExecutor runExecutor = new AndroidRunnableExecutor();
    protected LocationManager locationManager;
    private String TAG = "[Worklight Android Location Listener]";
    private String provider;
    private LocationHandler handler;
    private WLGeoAcquisitionPolicy policy;

    public AndroidLocationListener(Context context, LocationHandler handler, WLGeoAcquisitionPolicy policy) {
        this.handler = handler;
        this.policy = policy;
        this.locationManager = (LocationManager)context.getSystemService("location");
    }

    @Override
    public void cancelNativeAcquisition() {
        runExecutor.execute(new Runnable(){

            @Override
            public void run() {
                AndroidLocationListener.this.locationManager.removeUpdates((LocationListener)AndroidLocationListener.this);
            }
        });
    }

    @Override
    public void startNativeAcquisition(final boolean singleAcquisition) {
        this.provider = this.getProvider();
        if (this.provider != null) {
            runExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    if (singleAcquisition) {
                        AndroidLocationListener.this.locationManager.requestSingleUpdate(AndroidLocationListener.this.provider, (LocationListener)AndroidLocationListener.this, Looper.myLooper());
                    } else {
                        AndroidLocationListener.this.locationManager.requestLocationUpdates(AndroidLocationListener.this.provider, (long)AndroidLocationListener.this.policy.getMinChangeTime(), (float)AndroidLocationListener.this.policy.getMinChangeDistance(), (LocationListener)AndroidLocationListener.this);
                    }
                }
            });
        }
    }

    @Override
    public WLGeoPosition getCachedPosition() {
        Location last = null;
        Location lastFromGPS = null;
        Location lastFromNetwork = null;
        try {
            lastFromGPS = this.locationManager.getLastKnownLocation("gps");
        }
        catch (SecurityException e) {
            // empty catch block
        }
        try {
            lastFromNetwork = this.locationManager.getLastKnownLocation("network");
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (lastFromGPS != null && lastFromNetwork != null) {
            last = lastFromGPS.getTime() >= lastFromNetwork.getTime() ? lastFromGPS : lastFromNetwork;
        } else if (lastFromGPS != null) {
            last = lastFromGPS;
        } else if (lastFromNetwork != null) {
            last = lastFromNetwork;
        }
        return last != null ? this.convertToPosition(last) : null;
    }

    private String getProvider() {
        int desiredAccuracy;
        Criteria criteria = new Criteria();
        int accuracy = this.policy.isEnableHighAccuracy() ? ((desiredAccuracy = this.policy.getDesiredAccuracy()) < 100 ? 3 : (desiredAccuracy <= 500 ? 2 : 1)) : 1;
        criteria.setHorizontalAccuracy(accuracy);
        String provider = this.locationManager.getBestProvider(criteria, true);
        if (provider == null) {
            this.handler.sendError(WLGeoError.WLGeoErrorCodes.PERMISSION_DENIED, "Android couldn't find a location provider for accuracy level " + this.getAccuracyCriteriaString(accuracy) + " according to permissions in the Manifest and provider enablements in the device settings");
        } else if (accuracy == 3 && provider.equals("network")) {
            logger.warn("Network provider selected for accuracy level " + this.getAccuracyCriteriaString(accuracy) + ". Check the manifest for the ACCESS_FINE_LOCATION permission");
        }
        return provider;
    }

    protected String getAccuracyCriteriaString(int accuracy) {
        String accName = accuracy == 3 ? "ACCURACY_HIGH" : (accuracy == 2 ? "ACCURACY_MEDIUM" : "ACCURACY_LOW");
        return accName;
    }

    public void onLocationChanged(Location loc) {
        logger.debug("New location acquired");
        this.handler.sendAndSetTimeoutTimer(this.convertToPosition(loc));
    }

    protected WLGeoPosition convertToPosition(Location loc) {
        WLCoordinate coordinate = new WLCoordinate(loc.getLatitude(), loc.getLongitude(), loc.hasAltitude() ? Double.valueOf(loc.getAltitude()) : null, loc.getAccuracy(), null, loc.hasBearing() ? Double.valueOf(loc.getBearing()) : null, loc.hasSpeed() ? Double.valueOf(loc.getSpeed()) : null);
        return new WLGeoPosition(coordinate, loc.getTime());
    }

    public void onProviderDisabled(String provider) {
        logger.debug("Location provider '" + provider + "' disabled.");
        this.handler.sendError(WLGeoError.WLGeoErrorCodes.POSITION_UNAVAILABLE, provider + " provider disabled.");
    }

    public void onProviderEnabled(String provider) {
        logger.debug("Location provider " + provider + " has been enabled");
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
        logger.debug("The status of the provider " + provider + " has changed");
        if (status == 0) {
            logger.debug(provider + " is OUT OF SERVICE");
            this.handler.sendError(WLGeoError.WLGeoErrorCodes.POSITION_UNAVAILABLE, "Provider " + provider + " is out of service.");
        } else if (status == 1) {
            logger.debug(provider + " is TEMPORARILY_UNAVAILABLE");
        } else {
            logger.debug(provider + " is AVAILABLE");
        }
    }
}

