/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.geo;

import com.worklight.location.api.geo.WLGeoAcquisitionPolicy;
import com.worklight.location.api.geo.WLGeoCallback;
import com.worklight.location.api.geo.WLGeoPosition;
import com.worklight.location.internal.DeviceImpl;
import com.worklight.location.internal.ICallbackExecutor;
import com.worklight.location.internal.geo.EmptyGeoPosition;

public final class RTCGeoAcquireLinker
implements WLGeoCallback {
    private final DeviceImpl wlDevice;
    private final WLGeoCallback successCallback;
    private final WLGeoAcquisitionPolicy policy;
    private ICallbackExecutor executor;

    public RTCGeoAcquireLinker(DeviceImpl wlDeviceImpl, WLGeoCallback successCallback, WLGeoAcquisitionPolicy policy, ICallbackExecutor executor) {
        this.wlDevice = wlDeviceImpl;
        this.successCallback = successCallback;
        this.policy = policy;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(WLGeoPosition pos) {
        boolean updateRequired = this.isUpdateRequired(pos, true);
        if (updateRequired) {
            this.wlDevice.getDeviceContextImpl().setGeoPosition(pos);
        }
        try {
            this.executor.executeGeoAcquisitionCallback(this.successCallback, pos);
        }
        finally {
            if (updateRequired && this.isUpdateRequired(pos, false)) {
                this.wlDevice.getRTC().geoLocationAcquired(pos);
            }
        }
    }

    private boolean isUpdateRequired(WLGeoPosition pos, boolean checkPosition) {
        if (!this.wlDevice.getGeoAcquisitor().isAcquiring()) {
            return false;
        }
        WLGeoPosition lastPosition = this.wlDevice.getDeviceContextImpl().getGeoPosition();
        if (lastPosition != null && !(lastPosition instanceof EmptyGeoPosition)) {
            if (pos.getTimestamp() < lastPosition.getTimestamp()) {
                return false;
            }
            if (checkPosition && pos.equals(lastPosition)) {
                return false;
            }
            if (!this.policy.isEnableHighAccuracy() && this.wlDevice.getGeoAcquisitor().getWatchPolicy().isEnableHighAccuracy()) {
                return false;
            }
        }
        return true;
    }
}

