/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.geo;

import com.worklight.location.api.geo.WLGeoAcquisitionPolicy;
import com.worklight.location.api.geo.WLGeoCallback;
import com.worklight.location.api.geo.WLGeoError;
import com.worklight.location.api.geo.WLGeoFailureCallback;
import com.worklight.location.api.geo.WLGeoPosition;
import com.worklight.location.internal.geo.GeoFactory;
import com.worklight.location.internal.geo.NativeLocationListener;
import com.worklight.location.internal.geo.TimeoutTimerTask;
import java.util.Timer;
import java.util.TimerTask;

public class LocationHandler {
    protected WLGeoCallback successCallback;
    protected WLGeoFailureCallback errorCallback;
    protected WLGeoAcquisitionPolicy policy;
    protected boolean isWatchRequest;
    protected WLGeoPosition lastSent;
    protected static Timer timer = new Timer();
    private TimeoutTimerTask timeoutTask;
    private NativeLocationListener nativeLocationHandler;
    private GeoFactory factory;

    public LocationHandler(GeoFactory factory, WLGeoCallback successCallback, WLGeoFailureCallback errorCallback, WLGeoAcquisitionPolicy policy, boolean isWatchRequest) {
        this.factory = factory;
        this.successCallback = successCallback;
        this.errorCallback = errorCallback;
        this.policy = policy;
        this.isWatchRequest = isWatchRequest;
    }

    public synchronized void start() {
        long age;
        this.nativeLocationHandler = this.factory.createLocationListener(this, this.policy);
        boolean cachedPositionSent = false;
        WLGeoPosition cached = this.nativeLocationHandler.getCachedPosition();
        if (cached != null && (double)(age = this.calcAge(cached)) <= this.policy.getMaximumAge()) {
            this.sendPosition(cached);
            cachedPositionSent = true;
        }
        if (!cachedPositionSent || this.isWatchRequest) {
            this.scheduleTimeout();
            this.nativeLocationHandler.startNativeAcquisition(!this.isWatchRequest);
        }
    }

    protected synchronized void scheduleTimeout() {
        if (this.policy.getTimeout() == -1L) {
            return;
        }
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
        }
        timer.purge();
        this.timeoutTask = new TimeoutTimerTask(this);
        timer.schedule((TimerTask)this.timeoutTask, this.policy.getTimeout());
    }

    public synchronized void cancel() {
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
            this.timeoutTask = null;
        }
        timer.purge();
        this.nativeLocationHandler.cancelNativeAcquisition();
    }

    public synchronized void sendError(WLGeoError.WLGeoErrorCodes errorCode, String message) {
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
        }
        WLGeoError error = new WLGeoError(errorCode, message);
        this.errorCallback.execute(error);
    }

    protected synchronized void sendPosition(WLGeoPosition pos) {
        this.lastSent = pos;
        this.successCallback.execute(pos);
    }

    public void sendAndSetTimeoutTimer(WLGeoPosition pos) {
        this.sendPosition(pos);
        if (this.isWatchRequest) {
            this.scheduleTimeout();
        }
    }

    protected long calcAge(WLGeoPosition pos) {
        return System.currentTimeMillis() - pos.getTimestamp();
    }

    public void sendTimeout() {
        if (this.isWatchRequest) {
            this.scheduleTimeout();
        } else {
            this.nativeLocationHandler.cancelNativeAcquisition();
        }
        this.sendError(WLGeoError.WLGeoErrorCodes.TIMEOUT, "No location update obtained in the given timeout");
    }
}

