/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.location.internal.geo;

import com.worklight.location.api.WLConfidenceLevel;
import com.worklight.location.api.geo.WLCircle;
import com.worklight.location.api.geo.WLCoordinate;
import com.worklight.location.api.geo.WLGeoUtils;
import com.worklight.location.api.geo.WLPolygon;
import com.worklight.location.internal.geo.AreaVisitor;

public class IsOutsideAreaVisitor
implements AreaVisitor {
    private final WLConfidenceLevel confidence;
    private final WLCoordinate coordinate;
    private final double bufferZoneWidth;

    public IsOutsideAreaVisitor(WLConfidenceLevel confidence, WLCoordinate coordinate, double bufferZoneWidth) {
        this.confidence = confidence;
        this.coordinate = coordinate;
        this.bufferZoneWidth = bufferZoneWidth;
    }

    @Override
    public Boolean visitCircle(WLCircle circle) {
        return WLGeoUtils.isOutsideCircle(this.coordinate, circle, this.bufferZoneWidth, this.confidence);
    }

    @Override
    public Boolean visitPolygon(WLPolygon polygon) {
        return WLGeoUtils.isOutsidePolygon(this.coordinate, polygon, this.bufferZoneWidth, this.confidence);
    }
}

